/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import java.util.Arrays;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionSparseTransposed
extends ReaderColumnSelection {
    private final SparseBlock a;
    private final int[] sparsePos;
    private boolean atEnd = false;

    protected ReaderColumnSelectionSparseTransposed(MatrixBlock data, int[] colIndexes, int rl, int ru) {
        super(colIndexes, rl, Math.min(ru, data.getNumColumns()));
        this.sparsePos = new int[colIndexes.length];
        this.a = data.getSparseBlock();
        ++this._rl;
        for (int i = 0; i < colIndexes.length; ++i) {
            int len;
            int pos;
            int c = this._colIndexes[i];
            if (this.a.isEmpty(c)) {
                this.atEnd = true;
                this.sparsePos[i] = -1;
                continue;
            }
            int[] aIdx = this.a.indexes(c);
            int spa = Arrays.binarySearch(aIdx, pos = this.a.pos(c), len = this.a.size(c) + pos, this._rl);
            if (spa >= 0) {
                if (aIdx[spa] < this._ru) {
                    this.sparsePos[i] = spa;
                    continue;
                }
                this.sparsePos[i] = -1;
                this.atEnd = true;
                continue;
            }
            int spaC = Math.abs(spa + 1);
            if (spaC < len && aIdx[spaC] < this._ru) {
                this.sparsePos[i] = spaC;
                continue;
            }
            this.atEnd = true;
            this.sparsePos[i] = -1;
        }
    }

    @Override
    protected DblArray getNextRow() {
        if (!this.atEnd) {
            return this.getNextRowBeforeEnd();
        }
        return this.getNextRowAtEnd();
    }

    protected DblArray getNextRowBeforeEnd() {
        this.skipToRow();
        if (this._rl >= this._ru) {
            this._rl = this._ru;
            return null;
        }
        for (int i = 0; i < this._colIndexes.length; ++i) {
            int c = this._colIndexes[i];
            int sp = this.sparsePos[i];
            int[] aix = this.a.indexes(c);
            if (aix[sp] == this._rl) {
                int spa;
                double[] avals = this.a.values(c);
                this.reusableArr[i] = avals[sp];
                int n = i;
                this.sparsePos[n] = this.sparsePos[n] + 1;
                int len = this.a.size(c) + this.a.pos(c) - 1;
                if (spa < len && aix[spa] < this._ru) continue;
                this.sparsePos[i] = -1;
                this.atEnd = true;
                continue;
            }
            this.reusableArr[i] = 0.0;
        }
        return this.reusableReturn;
    }

    private void skipToRow() {
        this._rl = this.a.indexes(this._colIndexes[0])[this.sparsePos[0]];
        for (int i = 1; i < this._colIndexes.length; ++i) {
            this._rl = Math.min(this.a.indexes(this._colIndexes[i])[this.sparsePos[i]], this._rl);
        }
    }

    protected DblArray getNextRowAtEnd() {
        this.skipToRowAtEnd();
        if (this._rl == this._ru) {
            this._rl = this._ru;
            return null;
        }
        for (int i = 0; i < this._colIndexes.length; ++i) {
            int c = this._colIndexes[i];
            int sp = this.sparsePos[i];
            if (sp == -1) continue;
            int[] aix = this.a.indexes(c);
            if (aix[sp] == this._rl) {
                double[] avals = this.a.values(c);
                this.reusableArr[i] = avals[sp];
                int n = i;
                this.sparsePos[n] = this.sparsePos[n] + 1;
                if (this.sparsePos[n] < this.a.size(c) + this.a.pos(c)) continue;
                this.sparsePos[i] = -1;
                continue;
            }
            this.reusableArr[i] = 0.0;
        }
        return this.reusableReturn;
    }

    private void skipToRowAtEnd() {
        boolean allDone = true;
        int mr = this._ru;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            int sp = this.sparsePos[i];
            if (sp != -1) {
                allDone = false;
                mr = Math.min(this.a.indexes(this._colIndexes[i])[sp], mr);
                continue;
            }
            this.reusableArr[i] = 0.0;
        }
        this._rl = mr;
        if (allDone) {
            this._rl = this._ru;
        }
    }
}

