/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.dp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.lops.compile.Dag;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;

public abstract class DataPartitionFederatedScheme {
    public abstract Result partition(MatrixObject var1, MatrixObject var2, int var3);

    static List<MatrixObject> sliceFederatedMatrix(MatrixObject fedMatrix) {
        if (fedMatrix.isFederated(FTypes.FType.ROW)) {
            List<MatrixObject> slices = Collections.synchronizedList(new ArrayList());
            fedMatrix.getFedMapping().forEachParallel((range, data) -> {
                MatrixObject slice = new MatrixObject(fedMatrix.getValueType(), Dag.getNextUniqueVarname(Types.DataType.MATRIX));
                slice.setMetaData(new MetaDataFormat(new MatrixCharacteristics(range.getSize(0), range.getSize(1)), Types.FileFormat.BINARY));
                slice.setPrivacyConstraints(fedMatrix.getPrivacyConstraint());
                ArrayList<Pair<FederatedRange, FederatedData>> newFedHashMap = new ArrayList<Pair<FederatedRange, FederatedData>>();
                newFedHashMap.add(Pair.of((Object)range, (Object)data));
                slice.setFedMapping(new FederationMap(fedMatrix.getFedMapping().getID(), newFedHashMap));
                slice.getFedMapping().setType(FTypes.FType.ROW);
                slices.add(slice);
                return null;
            });
            return slices;
        }
        throw new DMLRuntimeException("Federated data partitioner: currently only supports row federated data");
    }

    static BalanceMetrics getBalanceMetrics(List<MatrixObject> slices) {
        long minRows;
        if (slices == null || slices.size() == 0) {
            return new BalanceMetrics(0L, 0L, 0L);
        }
        long maxRows = minRows = slices.get(0).getNumRows();
        long sum = 0L;
        for (MatrixObject slice : slices) {
            if (slice.getNumRows() < minRows) {
                minRows = slice.getNumRows();
            } else if (slice.getNumRows() > maxRows) {
                maxRows = slice.getNumRows();
            }
            sum += slice.getNumRows();
        }
        return new BalanceMetrics(minRows, sum / (long)slices.size(), maxRows);
    }

    static List<Double> getWeightingFactors(List<MatrixObject> pFeatures, BalanceMetrics balanceMetrics) {
        ArrayList<Double> weightingFactors = new ArrayList<Double>();
        pFeatures.forEach(feature -> weightingFactors.add((double)feature.getNumRows() / (double)balanceMetrics._avgRows));
        return weightingFactors;
    }

    static void shuffle(MatrixObject m, MatrixBlock P) {
        int k = InfrastructureAnalyzer.getLocalParallelism();
        AggregateBinaryOperator mm = InstructionUtils.getMatMultOperator(k);
        MatrixBlock out = P.aggregateBinaryOperations(P, (MatrixBlock)m.acquireReadAndRelease(), new MatrixBlock(), mm);
        m.acquireModify(out);
        m.release();
    }

    static void replicateTo(MatrixObject m, MatrixBlock R) {
        int k = InfrastructureAnalyzer.getLocalParallelism();
        AggregateBinaryOperator mm = InstructionUtils.getMatMultOperator(k);
        MatrixBlock out = R.aggregateBinaryOperations(R, (MatrixBlock)m.acquireReadAndRelease(), new MatrixBlock(), mm);
        m.acquireModify(((MatrixBlock)m.acquireReadAndRelease()).append(out, new MatrixBlock(), false));
        m.release();
    }

    static void subsampleTo(MatrixObject m, MatrixBlock S) {
        int k = InfrastructureAnalyzer.getLocalParallelism();
        AggregateBinaryOperator mm = InstructionUtils.getMatMultOperator(k);
        MatrixBlock out = S.aggregateBinaryOperations(S, (MatrixBlock)m.acquireReadAndRelease(), new MatrixBlock(), mm);
        m.acquireModify(out);
        m.release();
    }

    public static final class BalanceMetrics {
        public final long _minRows;
        public final long _avgRows;
        public final long _maxRows;

        public BalanceMetrics(long minRows, long avgRows, long maxRows) {
            this._minRows = minRows;
            this._avgRows = avgRows;
            this._maxRows = maxRows;
        }
    }

    public static final class Result {
        public final List<MatrixObject> _pFeatures;
        public final List<MatrixObject> _pLabels;
        public final int _workerNum;
        public final BalanceMetrics _balanceMetrics;
        public final List<Double> _weightingFactors;

        public Result(List<MatrixObject> pFeatures, List<MatrixObject> pLabels, int workerNum, BalanceMetrics balanceMetrics, List<Double> weightingFactors) {
            this._pFeatures = pFeatures;
            this._pLabels = pLabels;
            this._workerNum = workerNum;
            this._balanceMetrics = balanceMetrics;
            this._weightingFactors = weightingFactors;
        }
    }
}

