/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.Utils;

public class H5Superblock {
    protected static final byte[] HDF5_FILE_SIGNATURE = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};
    protected static final int HDF5_FILE_SIGNATURE_LENGTH = HDF5_FILE_SIGNATURE.length;
    public int versionOfSuperblock;
    public int versionNumberOfTheFileFreeSpaceInformation;
    public int versionOfRootGroupSymbolTableEntry;
    public int versionOfSharedHeaderMessageFormat;
    public int sizeOfOffsets;
    public int sizeOfLengths;
    public int groupLeafNodeK;
    public int groupInternalNodeK;
    public long baseAddressByte;
    public long addressOfGlobalFreeSpaceIndex;
    public long endOfFileAddress;
    public long driverInformationBlockAddress;
    public long rootGroupSymbolTableAddress;

    public H5Superblock() {
    }

    static boolean verifySignature(BufferedInputStream bis, long offset) {
        byte[] signature = new byte[HDF5_FILE_SIGNATURE_LENGTH];
        try {
            bis.reset();
            bis.skip(offset);
            bis.read(signature);
        }
        catch (IOException e) {
            throw new H5RuntimeException("Failed to read from address: " + offset, e);
        }
        return Arrays.equals(HDF5_FILE_SIGNATURE, signature);
    }

    public H5Superblock(BufferedInputStream bis, long address) {
        int superBlockHeaderSize = 12;
        long fileLocation = address + (long)HDF5_FILE_SIGNATURE_LENGTH;
        address += (long)(12 + HDF5_FILE_SIGNATURE_LENGTH);
        ByteBuffer header = ByteBuffer.allocate(superBlockHeaderSize);
        try {
            byte[] b = new byte[superBlockHeaderSize];
            bis.reset();
            bis.skip((int)fileLocation);
            bis.read(b);
            header.put(b);
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
        header.order(ByteOrder.LITTLE_ENDIAN);
        header.rewind();
        try {
            this.versionOfSuperblock = header.get();
            if (this.versionOfSuperblock != 0 && this.versionOfSuperblock != 1) {
                throw new H5RuntimeException("Detected superblock version not 0 or 1");
            }
            this.versionNumberOfTheFileFreeSpaceInformation = header.get();
            this.versionOfRootGroupSymbolTableEntry = header.get();
            header.position(header.position() + 1);
            this.versionOfSharedHeaderMessageFormat = header.get();
            this.sizeOfOffsets = Byte.toUnsignedInt(header.get());
            this.sizeOfLengths = Byte.toUnsignedInt(header.get());
            header.position(header.position() + 1);
            this.groupLeafNodeK = Short.toUnsignedInt(header.getShort());
            this.groupInternalNodeK = Short.toUnsignedInt(header.getShort());
            int nextSectionSize = 4 * this.sizeOfOffsets;
            header = ByteBuffer.allocate(nextSectionSize);
            byte[] hb = new byte[nextSectionSize];
            bis.reset();
            bis.skip(address += 4L);
            bis.read(hb);
            header.put(hb);
            address += (long)nextSectionSize;
            header.order(ByteOrder.LITTLE_ENDIAN);
            header.rewind();
            this.baseAddressByte = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
            this.addressOfGlobalFreeSpaceIndex = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
            this.endOfFileAddress = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
            this.driverInformationBlockAddress = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
            this.rootGroupSymbolTableAddress = address;
        }
        catch (Exception e) {
            throw new H5RuntimeException("Failed to read superblock from address " + address, e);
        }
    }

    protected H5BufferBuilder toBuffer() {
        H5BufferBuilder bb = new H5BufferBuilder();
        this.toBuffer(bb);
        return bb;
    }

    public void toBuffer(H5BufferBuilder bb) {
        bb.writeBytes(HDF5_FILE_SIGNATURE);
        bb.writeByte(this.versionOfSuperblock);
        bb.writeByte(this.versionNumberOfTheFileFreeSpaceInformation);
        bb.writeByte(this.versionOfRootGroupSymbolTableEntry);
        bb.writeByte(0);
        bb.writeByte(this.versionOfSharedHeaderMessageFormat);
        bb.writeByte(this.sizeOfOffsets);
        bb.writeByte(this.sizeOfLengths);
        bb.writeByte(0);
        bb.writeShort((short)this.groupLeafNodeK);
        bb.writeShort((short)this.groupInternalNodeK);
        bb.writeInt(0);
        bb.writeLong(this.baseAddressByte);
        bb.writeLong(this.addressOfGlobalFreeSpaceIndex);
        bb.writeLong(this.endOfFileAddress);
        bb.writeLong(this.driverInformationBlockAddress);
    }
}

