/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.ValueExistencePolicy;

final class HashCode
extends MetadataVisitor<Integer> {
    private static final ThreadLocal<HashCode> VISITORS = ThreadLocal.withInitial(HashCode::new);
    private int code;

    private HashCode() {
    }

    static HashCode getOrCreate() {
        return VISITORS.get();
    }

    @Override
    final ThreadLocal<HashCode> creator() {
        return VISITORS;
    }

    @Override
    MetadataVisitor.Filter preVisit(PropertyAccessor accessor) {
        this.code = accessor.type.hashCode();
        return MetadataVisitor.Filter.NON_EMPTY;
    }

    @Override
    Object visit(Class<?> type, Object value) {
        if (!ValueExistencePolicy.isNullOrEmpty(value)) {
            int c = this.code;
            this.code = c += value.hashCode();
        }
        return value;
    }

    @Override
    Integer result() {
        return this.code;
    }
}

