/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Script {
    private static final String KEY_PREFIX = "_args_";
    private final StringBuilder scriptBuilder = new StringBuilder();
    private final Map<Object, String> parameters = new HashMap<Object, String>();

    public void init() {
        this.scriptBuilder.setLength(0);
        this.parameters.clear();
    }

    public Script append(String script) {
        this.scriptBuilder.append(script);
        return this;
    }

    public Script setCharAtEnd(char ch) {
        this.scriptBuilder.setCharAt(this.scriptBuilder.length() - 1, ch);
        return this;
    }

    public <V> Script getBoundKeyOrAssign(boolean withParameters, V value) {
        if (withParameters) {
            if (!this.parameters.containsKey(value)) {
                this.parameters.put(value, this.getNextBoundKey());
            }
            this.append(this.parameters.get(value));
        } else {
            this.append(value.toString());
        }
        return this;
    }

    public String getScript() {
        return this.scriptBuilder.toString();
    }

    public Optional<Map<String, Object>> getParameters() {
        return Optional.ofNullable(this.parameters.isEmpty() ? null : this.parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
    }

    private String getNextBoundKey() {
        return KEY_PREFIX + this.parameters.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        List strings = Stream.of(this.getScript(), this.getParameters()).filter(o -> null != o).filter(o -> {
            if (o instanceof Map) {
                return !((Map)o).isEmpty();
            }
            return !o.toString().isEmpty();
        }).map(Object::toString).collect(Collectors.toList());
        if (!strings.isEmpty()) {
            builder.append('(');
            builder.append(String.join((CharSequence)",", strings));
            builder.append(')');
        }
        return "Script[" + builder.toString() + "]";
    }
}

