/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.PopContaining;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AndStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalFlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ComputerAwareStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ConnectiveStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathRetractionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.PathUtil;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class MatchStep<S, E>
extends ComputerAwareStep<S, Map<String, E>>
implements TraversalParent,
Scoping,
PathProcessor {
    private List<Traversal.Admin<Object, Object>> matchTraversals;
    private boolean first = true;
    private Set<String> matchStartLabels = new HashSet<String>();
    private Set<String> matchEndLabels = new HashSet<String>();
    private Set<String> scopeKeys = null;
    private final ConnectiveStep.Connective connective;
    private final String computedStartLabel;
    private MatchAlgorithm matchAlgorithm;
    private Class<? extends MatchAlgorithm> matchAlgorithmClass = CountMatchAlgorithm.class;
    private Map<String, Set<String>> referencedLabelsMap;
    private Set<List<Object>> dedups = null;
    private Set<String> dedupLabels = null;
    private Set<String> keepLabels = null;
    private TraverserSet standardAlgorithmBarrier;

    public MatchStep(Traversal.Admin traversal, ConnectiveStep.Connective connective, Traversal ... matchTraversals) {
        super(traversal);
        this.connective = connective;
        this.matchTraversals = Stream.of(matchTraversals).map(Traversal::asAdmin).collect(Collectors.toList());
        this.matchTraversals.forEach(this::configureStartAndEndSteps);
        this.matchTraversals.forEach(this::integrateChild);
        this.standardAlgorithmBarrier = this.traversal.getTraverserSetSupplier().get();
        this.computedStartLabel = Helper.computeStartLabel(this.matchTraversals);
    }

    private String pullOutVariableStartStepToParent(WhereTraversalStep<?> whereStep) {
        return this.pullOutVariableStartStepToParent(new HashSet<String>(), whereStep.getLocalChildren().get(0), true).size() != 1 ? null : this.pullOutVariableStartStepToParent(new HashSet<String>(), whereStep.getLocalChildren().get(0), false).iterator().next();
    }

    private Set<String> pullOutVariableStartStepToParent(Set<String> selectKeys, Traversal.Admin<?, ?> traversal, boolean testRun) {
        Step<?, ?> startStep = traversal.getStartStep();
        if (startStep instanceof WhereTraversalStep.WhereStartStep && !((WhereTraversalStep.WhereStartStep)startStep).getScopeKeys().isEmpty()) {
            selectKeys.addAll(((WhereTraversalStep.WhereStartStep)startStep).getScopeKeys());
            if (!testRun) {
                ((WhereTraversalStep.WhereStartStep)startStep).removeScopeKey();
            }
        } else if (startStep instanceof ConnectiveStep || startStep instanceof NotStep) {
            ((TraversalParent)((Object)startStep)).getLocalChildren().forEach(child -> this.pullOutVariableStartStepToParent(selectKeys, (Traversal.Admin<?, ?>)child, testRun));
        }
        return selectKeys;
    }

    private void configureStartAndEndSteps(Traversal.Admin<?, ?> matchTraversal) {
        String label;
        FilterStep whereStep;
        ConnectiveStrategy.instance().apply(matchTraversal);
        Step<?, ?> startStep = matchTraversal.getStartStep();
        if (startStep instanceof ConnectiveStep) {
            MatchStep<S, E> matchStep = new MatchStep<S, E>(matchTraversal, startStep instanceof AndStep ? ConnectiveStep.Connective.AND : ConnectiveStep.Connective.OR, ((ConnectiveStep)startStep).getLocalChildren().toArray(new Traversal[((ConnectiveStep)startStep).getLocalChildren().size()]));
            TraversalHelper.replaceStep(startStep, matchStep, matchTraversal);
            this.matchStartLabels.addAll(matchStep.matchStartLabels);
            this.matchEndLabels.addAll(matchStep.matchEndLabels);
        } else if (startStep instanceof NotStep) {
            DefaultTraversal notTraversal = new DefaultTraversal();
            TraversalHelper.removeToTraversal(startStep, startStep.getNextStep(), notTraversal);
            matchTraversal.addStep(0, new WhereTraversalStep(matchTraversal, notTraversal));
            this.configureStartAndEndSteps(matchTraversal);
        } else if (StartStep.isVariableStartStep(startStep)) {
            String label2 = startStep.getLabels().iterator().next();
            this.matchStartLabels.add(label2);
            TraversalHelper.replaceStep(matchTraversal.getStartStep(), new MatchStartStep(matchTraversal, label2), matchTraversal);
        } else if (startStep instanceof WhereTraversalStep) {
            whereStep = (WhereTraversalStep)startStep;
            TraversalHelper.insertBeforeStep(new MatchStartStep(matchTraversal, this.pullOutVariableStartStepToParent((WhereTraversalStep<?>)whereStep)), whereStep, matchTraversal);
        } else if (startStep instanceof WherePredicateStep) {
            whereStep = (WherePredicateStep)startStep;
            TraversalHelper.insertBeforeStep(new MatchStartStep(matchTraversal, ((WherePredicateStep)whereStep).getStartKey().orElse(null)), whereStep, matchTraversal);
            ((WherePredicateStep)whereStep).removeStartKey();
        } else {
            throw new IllegalArgumentException("All match()-traversals must have a single start label (i.e. variable): " + matchTraversal);
        }
        Step<?, ?> endStep = matchTraversal.getEndStep();
        if (endStep.getLabels().size() > 1) {
            throw new IllegalArgumentException("The end step of a match()-traversal can have at most one label: " + endStep);
        }
        String string = label = endStep.getLabels().size() == 0 ? null : endStep.getLabels().iterator().next();
        if (null != label) {
            endStep.removeLabel(label);
        }
        MatchEndStep matchEndStep = new MatchEndStep(matchTraversal, label);
        if (null != label) {
            this.matchEndLabels.add(label);
        }
        matchTraversal.asAdmin().addStep(matchEndStep);
        if (TraversalHelper.getStepsOfAssignableClass(Barrier.class, matchTraversal).stream().filter(s -> !(s instanceof NoOpBarrierStep)).findAny().isPresent()) {
            DefaultTraversal newTraversal = new DefaultTraversal();
            TraversalHelper.removeToTraversal(matchTraversal.getStartStep().getNextStep(), matchTraversal.getEndStep(), newTraversal);
            TraversalHelper.insertAfterStep(new TraversalFlatMapStep(matchTraversal, newTraversal), matchTraversal.getStartStep(), matchTraversal);
        }
    }

    public ConnectiveStep.Connective getConnective() {
        return this.connective;
    }

    @Override
    public void addGlobalChild(Traversal.Admin<?, ?> globalChildTraversal) {
        this.configureStartAndEndSteps(globalChildTraversal);
        this.matchTraversals.add(this.integrateChild(globalChildTraversal));
    }

    @Override
    public void removeGlobalChild(Traversal.Admin<?, ?> globalChildTraversal) {
        this.matchTraversals.remove(globalChildTraversal);
    }

    public List<Traversal.Admin<Object, Object>> getGlobalChildren() {
        return Collections.unmodifiableList(this.matchTraversals);
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
        if (null != this.dedupLabels) {
            this.keepLabels.addAll(this.dedupLabels);
        }
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    public Set<String> getMatchEndLabels() {
        return this.matchEndLabels;
    }

    public Set<String> getMatchStartLabels() {
        return this.matchStartLabels;
    }

    @Override
    public Set<String> getScopeKeys() {
        if (null == this.scopeKeys) {
            this.scopeKeys = new HashSet<String>();
            this.matchTraversals.forEach(traversal -> {
                if (traversal.getStartStep() instanceof Scoping) {
                    this.scopeKeys.addAll(((Scoping)((Object)traversal.getStartStep())).getScopeKeys());
                }
                if (traversal.getEndStep() instanceof Scoping) {
                    this.scopeKeys.addAll(((Scoping)((Object)traversal.getEndStep())).getScopeKeys());
                }
            });
            this.scopeKeys.removeAll(this.matchEndLabels);
            this.scopeKeys.remove(this.computedStartLabel);
            this.scopeKeys = Collections.unmodifiableSet(this.scopeKeys);
        }
        return this.scopeKeys;
    }

    @Override
    public HashSet<PopContaining.PopInstruction> getPopInstructions() {
        HashSet<PopContaining.PopInstruction> popInstructions = new HashSet<PopContaining.PopInstruction>();
        popInstructions.addAll(Scoping.super.getPopInstructions());
        popInstructions.addAll(TraversalParent.super.getPopInstructions());
        return popInstructions;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[]{this.dedupLabels, this.connective, this.matchTraversals});
    }

    @Override
    public void reset() {
        super.reset();
        this.first = true;
    }

    public void setMatchAlgorithm(Class<? extends MatchAlgorithm> matchAlgorithmClass) {
        this.matchAlgorithmClass = matchAlgorithmClass;
    }

    public MatchAlgorithm getMatchAlgorithm() {
        if (null == this.matchAlgorithm) {
            this.initializeMatchAlgorithm(this.traverserStepIdAndLabelsSetByChild);
        }
        return this.matchAlgorithm;
    }

    @Override
    public MatchStep<S, E> clone() {
        MatchStep clone = (MatchStep)super.clone();
        clone.matchTraversals = new ArrayList<Traversal.Admin<Object, Object>>();
        for (Traversal.Admin<Object, Object> traversal : this.matchTraversals) {
            clone.matchTraversals.add(traversal.clone());
        }
        if (this.dedups != null) {
            clone.dedups = new HashSet<List<Object>>();
        }
        clone.standardAlgorithmBarrier = this.traversal.getTraverserSetSupplier().get();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        for (Traversal.Admin<Object, Object> traversal : this.matchTraversals) {
            this.integrateChild(traversal);
        }
    }

    public void setDedupLabels(Set<String> labels) {
        if (!labels.isEmpty()) {
            this.dedups = new HashSet<List<Object>>();
            this.dedupLabels = new HashSet<String>(labels);
            if (null != this.keepLabels) {
                this.keepLabels.addAll(this.dedupLabels);
            }
        }
    }

    private boolean isDuplicate(Traverser<S> traverser) {
        if (null == this.dedups) {
            return false;
        }
        Path path = traverser.path();
        for (String label : this.dedupLabels) {
            if (path.hasLabel(label)) continue;
            return false;
        }
        ArrayList objects = new ArrayList(this.dedupLabels.size());
        for (String label : this.dedupLabels) {
            objects.add(path.get(Pop.last, label));
        }
        return this.dedups.contains(objects);
    }

    private boolean hasMatched(ConnectiveStep.Connective connective, Traverser.Admin<S> traverser) {
        int counter = 0;
        boolean matched = false;
        for (Traversal.Admin<Object, Object> matchTraversal : this.matchTraversals) {
            if (!traverser.getTags().contains(matchTraversal.getStartStep().getId())) continue;
            if (connective == ConnectiveStep.Connective.OR) {
                matched = true;
                break;
            }
            ++counter;
        }
        if (!matched) {
            boolean bl = matched = this.matchTraversals.size() == counter;
        }
        if (matched && this.dedupLabels != null) {
            Path path = traverser.path();
            ArrayList objects = new ArrayList(this.dedupLabels.size());
            for (String label : this.dedupLabels) {
                objects.add(path.get(Pop.last, label));
            }
            this.dedups.add(objects);
        }
        return matched;
    }

    private Map<String, E> getBindings(Traverser<S> traverser) {
        HashMap bindings = new HashMap();
        traverser.path().forEach((object, labels) -> {
            for (String label : labels) {
                if (!this.matchStartLabels.contains(label) && !this.matchEndLabels.contains(label)) continue;
                bindings.put(label, object);
            }
        });
        return bindings;
    }

    private void initializeMatchAlgorithm(boolean onComputer) {
        try {
            this.matchAlgorithm = this.matchAlgorithmClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.matchAlgorithm.initialize(onComputer, this.matchTraversals);
    }

    private boolean hasPathLabel(Path path, Set<String> labels) {
        for (String label : labels) {
            if (!path.hasLabel(label)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Set<String>> getReferencedLabelsMap() {
        if (null == this.referencedLabelsMap) {
            this.referencedLabelsMap = new HashMap<String, Set<String>>();
            for (Traversal.Admin<Object, Object> traversal : this.matchTraversals) {
                HashSet<String> referencedLabels = new HashSet<String>();
                for (Step step : traversal.getSteps()) {
                    referencedLabels.addAll(PathUtil.getReferencedLabels(step));
                }
                this.referencedLabelsMap.put(traversal.getStartStep().getId(), referencedLabels);
            }
        }
        return this.referencedLabelsMap;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Iterator<Traverser.Admin<Map<String, E>>> standardAlgorithm() throws NoSuchElementException {
        block0: while (true) {
            block11: {
                block10: {
                    if (!this.first) break block10;
                    this.first = false;
                    this.initializeMatchAlgorithm(false);
                    if (null == this.keepLabels || !this.keepLabels.containsAll(this.matchEndLabels) || !this.keepLabels.containsAll(this.matchStartLabels)) break block11;
                    this.keepLabels = null;
                    break block11;
                }
                stop = false;
                for (Traversal.Admin<Object, Object> matchTraversal : this.matchTraversals) {
                    while (matchTraversal.hasNext()) {
                        this.standardAlgorithmBarrier.add(matchTraversal.nextTraverser());
                        if (null != this.keepLabels && this.standardAlgorithmBarrier.size() < PathRetractionStrategy.MAX_BARRIER_SIZE) continue;
                        stop = true;
                        break;
                    }
                    if (!stop) continue;
                    break;
                }
            }
            if (this.standardAlgorithmBarrier.isEmpty()) {
                traverser = this.starts.next();
                if (!traverser.getTags().contains(this.getId())) {
                    traverser.getTags().add(this.getId());
                    if (!this.hasPathLabel(traverser.path(), this.matchStartLabels)) {
                        traverser.addLabels(Collections.singleton(this.computedStartLabel));
                    }
                }
            } else {
                traverser = this.standardAlgorithmBarrier.remove();
            }
            if (this.isDuplicate((Traverser<S>)traverser)) continue;
            if (this.hasMatched(this.connective, (Traverser.Admin<S>)traverser)) {
                return IteratorUtils.of(traverser.split(this.getBindings((Traverser<S>)traverser), this));
            }
            if (this.connective == ConnectiveStep.Connective.AND) {
                matchTraversal = (Traversal.Admin)this.getMatchAlgorithm().apply(traverser);
                traverser.getTags().add(matchTraversal.getStartStep().getId());
                matchTraversal.addStart(traverser);
                continue;
            }
            var2_3 = this.matchTraversals.iterator();
            while (true) {
                if (var2_3.hasNext()) ** break;
                continue block0;
                matchTraversal = var2_3.next();
                split = traverser.split();
                split.getTags().add(matchTraversal.getStartStep().getId());
                matchTraversal.addStart(split);
            }
            break;
        }
    }

    @Override
    protected Iterator<Traverser.Admin<Map<String, E>>> computerAlgorithm() throws NoSuchElementException {
        Object traverser;
        do {
            if (this.first) {
                this.first = false;
                this.initializeMatchAlgorithm(true);
                if (null != this.keepLabels && this.keepLabels.containsAll(this.matchEndLabels) && this.keepLabels.containsAll(this.matchStartLabels)) {
                    this.keepLabels = null;
                }
            }
            if ((traverser = this.starts.next()).getTags().contains(this.getId())) continue;
            traverser.getTags().add(this.getId());
            if (this.hasPathLabel(traverser.path(), this.matchStartLabels)) continue;
            traverser.addLabels(Collections.singleton(this.computedStartLabel));
        } while (this.isDuplicate((Traverser<S>)traverser));
        if (this.hasMatched(this.connective, (Traverser.Admin<S>)traverser)) {
            traverser.setStepId(this.getNextStep().getId());
            traverser.addLabels(this.labels);
            return IteratorUtils.of(traverser.split(this.getBindings((Traverser<S>)traverser), this));
        }
        if (this.connective == ConnectiveStep.Connective.AND) {
            Traversal.Admin matchTraversal = (Traversal.Admin)this.getMatchAlgorithm().apply(traverser);
            traverser.getTags().add(matchTraversal.getStartStep().getId());
            traverser.setStepId(matchTraversal.getStartStep().getId());
            return IteratorUtils.of(traverser);
        }
        ArrayList traversers = new ArrayList(this.matchTraversals.size());
        for (Traversal.Admin<Object, Object> matchTraversal : this.matchTraversals) {
            Traverser.Admin split = traverser.split();
            split.getTags().add(matchTraversal.getStartStep().getId());
            split.setStepId(matchTraversal.getStartStep().getId());
            traversers.add(split);
        }
        return traversers.iterator();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ this.connective.hashCode();
        for (Traversal traversal : this.matchTraversals) {
            result ^= traversal.hashCode();
        }
        return result;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.LABELED_PATH, TraverserRequirement.SIDE_EFFECTS);
    }

    public static class CountMatchAlgorithm
    implements MatchAlgorithm {
        protected List<Bundle> bundles;
        protected int counter = 0;
        protected boolean onComputer;

        @Override
        public void initialize(boolean onComputer, List<Traversal.Admin<Object, Object>> traversals) {
            this.onComputer = onComputer;
            this.bundles = traversals.stream().map(x$0 -> new Bundle((Traversal.Admin<Object, Object>)x$0)).collect(Collectors.toList());
        }

        @Override
        public Traversal.Admin<Object, Object> apply(Traverser.Admin<Object> traverser) {
            if (this.onComputer) {
                List<Set<String>> labels = traverser.path().labels();
                Set<String> lastLabels = labels.get(labels.size() - 1);
                Collections.sort(this.bundles, Comparator.comparingLong(b -> Helper.getStartLabels(b.traversal).stream().filter(startLabel -> !lastLabels.contains(startLabel)).count()).thenComparingInt(b -> b.traversalType.ordinal()).thenComparingDouble(b -> b.multiplicity));
            }
            Bundle startLabelsBundle = null;
            for (Bundle bundle : this.bundles) {
                if (Helper.hasExecutedTraversal(traverser, bundle.traversal) || !Helper.hasStartLabels(traverser, bundle.traversal)) continue;
                if (bundle.traversalType != TraversalType.MATCH_TRAVERSAL || Helper.hasEndLabel(traverser, bundle.traversal)) {
                    return bundle.traversal;
                }
                if (null != startLabelsBundle) continue;
                startLabelsBundle = bundle;
            }
            if (null != startLabelsBundle) {
                return startLabelsBundle.traversal;
            }
            throw (IllegalStateException)UNMATCHABLE_PATTERN.apply(this.bundles.stream().map(record -> record.traversal).collect(Collectors.toList()));
        }

        @Override
        public void recordStart(Traverser.Admin<Object> traverser, Traversal.Admin<Object, Object> traversal) {
            ++this.getBundle(traversal).startsCount;
        }

        @Override
        public void recordEnd(Traverser.Admin<Object> traverser, Traversal.Admin<Object, Object> traversal) {
            this.getBundle(traversal).incrementEndCount();
            if (!this.onComputer) {
                if (this.counter < 200 || this.counter % 250 == 0) {
                    Collections.sort(this.bundles, Comparator.comparingInt(b -> b.traversalType.ordinal()).thenComparingDouble(b -> b.multiplicity));
                }
                ++this.counter;
            }
        }

        protected Bundle getBundle(Traversal.Admin<Object, Object> traversal) {
            for (Bundle bundle : this.bundles) {
                if (bundle.traversal != traversal) continue;
                return bundle;
            }
            throw new IllegalStateException("No equivalent traversal could be found in " + CountMatchAlgorithm.class.getSimpleName() + ": " + traversal);
        }

        public class Bundle {
            public Traversal.Admin<Object, Object> traversal;
            public TraversalType traversalType;
            public long startsCount;
            public long endsCount;
            public double multiplicity;

            public Bundle(Traversal.Admin<Object, Object> traversal) {
                this.traversal = traversal;
                this.traversalType = Helper.getTraversalType(traversal);
                this.startsCount = 0L;
                this.endsCount = 0L;
                this.multiplicity = 0.0;
            }

            public final void incrementEndCount() {
                this.multiplicity = (double)(++this.endsCount) / (double)this.startsCount;
            }
        }
    }

    public static class GreedyMatchAlgorithm
    implements MatchAlgorithm {
        private List<Traversal.Admin<Object, Object>> traversals;

        @Override
        public void initialize(boolean onComputer, List<Traversal.Admin<Object, Object>> traversals) {
            this.traversals = traversals;
        }

        @Override
        public Traversal.Admin<Object, Object> apply(Traverser.Admin<Object> traverser) {
            for (Traversal.Admin<Object, Object> traversal : this.traversals) {
                if (Helper.hasExecutedTraversal(traverser, traversal) || !Helper.hasStartLabels(traverser, traversal)) continue;
                return traversal;
            }
            throw (IllegalStateException)UNMATCHABLE_PATTERN.apply(this.traversals);
        }
    }

    public static interface MatchAlgorithm
    extends Function<Traverser.Admin<Object>, Traversal.Admin<Object, Object>>,
    Serializable {
        public static final Function<List<Traversal.Admin<Object, Object>>, IllegalStateException> UNMATCHABLE_PATTERN = traversals -> new IllegalStateException("The provided match pattern is unsolvable: " + traversals);

        public void initialize(boolean var1, List<Traversal.Admin<Object, Object>> var2);

        default public void recordStart(Traverser.Admin<Object> traverser, Traversal.Admin<Object, Object> traversal) {
        }

        default public void recordEnd(Traverser.Admin<Object> traverser, Traversal.Admin<Object, Object> traversal) {
        }
    }

    public static final class Helper {
        private Helper() {
        }

        public static Optional<String> getEndLabel(Traversal.Admin<Object, Object> traversal) {
            Step<?, Object> endStep = traversal.getEndStep();
            return endStep instanceof ProfileStep ? ((MatchEndStep)endStep.getPreviousStep()).getMatchKey() : ((MatchEndStep)endStep).getMatchKey();
        }

        public static Set<String> getStartLabels(Traversal.Admin<Object, Object> traversal) {
            return ((Scoping)((Object)traversal.getStartStep())).getScopeKeys();
        }

        public static boolean hasStartLabels(Traverser.Admin<Object> traverser, Traversal.Admin<Object, Object> traversal) {
            for (String label : Helper.getStartLabels(traversal)) {
                if (traverser.path().hasLabel(label)) continue;
                return false;
            }
            return true;
        }

        public static boolean hasEndLabel(Traverser.Admin<Object> traverser, Traversal.Admin<Object, Object> traversal) {
            Optional<String> endLabel = Helper.getEndLabel(traversal);
            return endLabel.isPresent() && traverser.path().hasLabel(endLabel.get());
        }

        public static boolean hasExecutedTraversal(Traverser.Admin<Object> traverser, Traversal.Admin<Object, Object> traversal) {
            return traverser.getTags().contains(traversal.getStartStep().getId());
        }

        public static TraversalType getTraversalType(Traversal.Admin<Object, Object> traversal) {
            Step<?, ?> nextStep = traversal.getStartStep().getNextStep();
            if (nextStep instanceof WherePredicateStep) {
                return TraversalType.WHERE_PREDICATE;
            }
            if (nextStep instanceof WhereTraversalStep) {
                return TraversalType.WHERE_TRAVERSAL;
            }
            return TraversalType.MATCH_TRAVERSAL;
        }

        public static String computeStartLabel(List<Traversal.Admin<Object, Object>> traversals) {
            HashSet<String> startLabels = new HashSet<String>();
            HashSet endLabels = new HashSet();
            for (Traversal.Admin<Object, Object> traversal : traversals) {
                Helper.getEndLabel(traversal).ifPresent(endLabels::add);
                startLabels.addAll(Helper.getStartLabels(traversal));
            }
            startLabels.removeAll(endLabels);
            if (!startLabels.isEmpty()) {
                return (String)startLabels.iterator().next();
            }
            ArrayList sort = new ArrayList();
            for (Traversal.Admin<Object, Object> traversal : traversals) {
                Helper.getStartLabels(traversal).stream().filter(startLabel -> !sort.contains(startLabel)).forEach(sort::add);
                Helper.getEndLabel(traversal).ifPresent(endLabel -> {
                    if (!sort.contains(endLabel)) {
                        sort.add(endLabel);
                    }
                });
            }
            Collections.sort(sort, (a, b) -> {
                for (Traversal.Admin traversal : traversals) {
                    Optional<String> endLabel = Helper.getEndLabel(traversal);
                    if (!endLabel.isPresent()) continue;
                    Set<String> startLabels = Helper.getStartLabels(traversal);
                    if (a.equals(endLabel.get()) && startLabels.contains(b)) {
                        return 1;
                    }
                    if (!b.equals(endLabel.get()) || !startLabels.contains(a)) continue;
                    return -1;
                }
                return 0;
            });
            return (String)sort.get(0);
        }
    }

    public static final class MatchEndStep
    extends ComputerAwareStep.EndStep<Object>
    implements Scoping {
        private final String matchKey;
        private final Set<String> matchKeyCollection;
        private MatchStep<?, ?> parent;

        public MatchEndStep(Traversal.Admin traversal, String matchKey) {
            super(traversal);
            this.matchKey = matchKey;
            this.matchKeyCollection = null == matchKey ? Collections.emptySet() : Collections.singleton(this.matchKey);
        }

        private <S> Traverser.Admin<S> retractUnnecessaryLabels(Traverser.Admin<S> traverser) {
            if (null == this.parent.getKeepLabels()) {
                return traverser;
            }
            HashSet<String> keepers = new HashSet<String>(this.parent.getKeepLabels());
            Set<String> tags = traverser.getTags();
            for (Traversal.Admin matchTraversal : ((MatchStep)this.parent).matchTraversals) {
                String startStepId = matchTraversal.getStartStep().getId();
                if (tags.contains(startStepId)) continue;
                keepers.addAll((Collection)((MatchStep)this.parent).getReferencedLabelsMap().get(startStepId));
            }
            return PathProcessor.processTraverserPathLabels(traverser, keepers);
        }

        @Override
        protected Traverser.Admin<Object> processNextStart() throws NoSuchElementException {
            Object traverser;
            Path path;
            if (null == this.parent) {
                this.parent = (MatchStep)this.getTraversal().getParent().asStep();
            }
            do {
                traverser = this.starts.next();
                if (null != this.matchKey) continue;
                traverser.setStepId(this.parent.getId());
                this.parent.getMatchAlgorithm().recordEnd((Traverser.Admin<Object>)traverser, this.getTraversal());
                return this.retractUnnecessaryLabels((Traverser.Admin)traverser);
            } while ((path = traverser.path()).hasLabel(this.matchKey) && !traverser.get().equals(path.get(Pop.last, this.matchKey)));
            traverser.setStepId(this.parent.getId());
            traverser.addLabels(this.matchKeyCollection);
            this.parent.getMatchAlgorithm().recordEnd((Traverser.Admin<Object>)traverser, this.getTraversal());
            return this.retractUnnecessaryLabels((Traverser.Admin)traverser);
        }

        public Optional<String> getMatchKey() {
            return Optional.ofNullable(this.matchKey);
        }

        @Override
        public String toString() {
            return StringFactory.stepString(this, this.matchKey);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            if (null != this.matchKey) {
                result ^= this.matchKey.hashCode();
            }
            return result;
        }

        @Override
        public Set<String> getScopeKeys() {
            return this.matchKeyCollection;
        }
    }

    public static final class MatchStartStep
    extends AbstractStep<Object, Object>
    implements Scoping {
        private final String selectKey;
        private Set<String> scopeKeys;
        private MatchStep<?, ?> parent;

        public MatchStartStep(Traversal.Admin traversal, String selectKey) {
            super(traversal);
            this.selectKey = selectKey;
        }

        @Override
        protected Traverser.Admin<Object> processNextStart() throws NoSuchElementException {
            if (null == this.parent) {
                this.parent = (MatchStep)this.getTraversal().getParent();
            }
            Traverser.Admin<Object> traverser = this.starts.next();
            this.parent.getMatchAlgorithm().recordStart(traverser, this.getTraversal());
            return null == this.selectKey ? traverser : traverser.split(traverser.path().get(Pop.last, this.selectKey), this);
        }

        @Override
        public String toString() {
            return StringFactory.stepString(this, this.selectKey);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            if (null != this.selectKey) {
                result ^= this.selectKey.hashCode();
            }
            return result;
        }

        public Optional<String> getSelectKey() {
            return Optional.ofNullable(this.selectKey);
        }

        @Override
        public Set<String> getScopeKeys() {
            if (null == this.scopeKeys) {
                this.scopeKeys = new HashSet<String>();
                if (null != this.selectKey) {
                    this.scopeKeys.add(this.selectKey);
                }
                Set<String> endLabels = ((MatchStep)this.getTraversal().getParent()).getMatchEndLabels();
                TraversalHelper.anyStepRecursively(step -> {
                    if (step instanceof WherePredicateStep || step instanceof WhereTraversalStep) {
                        for (String key : ((Scoping)((Object)step)).getScopeKeys()) {
                            if (!endLabels.contains(key)) continue;
                            this.scopeKeys.add(key);
                        }
                    }
                    return false;
                }, this.getTraversal());
                this.scopeKeys = Collections.unmodifiableSet(this.scopeKeys);
            }
            return this.scopeKeys;
        }
    }

    public static enum TraversalType {
        WHERE_PREDICATE,
        WHERE_TRAVERSAL,
        MATCH_TRAVERSAL;

    }
}

