/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import org.quartz.impl.jdbcjobstore.Constants;

public interface StdJDBCConstants
extends Constants {
    public static final String TABLE_PREFIX_SUBST = "{0}";
    public static final String UPDATE_TRIGGER_STATES_FROM_OTHER_STATES = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_STATE = ? OR TRIGGER_STATE = ?";
    public static final String UPDATE_TRIGGER_STATE_FROM_OTHER_STATES_BEFORE_TIME = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE (TRIGGER_STATE = ? OR TRIGGER_STATE = ?) AND NEXT_FIRE_TIME < ?";
    public static final String SELECT_MISFIRED_TRIGGERS = "SELECT * FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ?";
    public static final String SELECT_TRIGGERS_IN_STATE = "SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE TRIGGER_STATE = ?";
    public static final String SELECT_MISFIRED_TRIGGERS_IN_STATE = "SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ?";
    public static final String SELECT_MISFIRED_TRIGGERS_IN_GROUP_IN_STATE = "SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ?";
    public static final String SELECT_VOLATILE_TRIGGERS = "SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE IS_VOLATILE = ?";
    public static final String DELETE_FIRED_TRIGGERS = "DELETE FROM {0}FIRED_TRIGGERS";
    public static final String INSERT_JOB_DETAIL = "INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_JOB_DETAIL = "UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_TRIGGERS_FOR_JOB = "SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_TRIGGERS_FOR_CALENDAR = "SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE CALENDAR_NAME = ?";
    public static final String SELECT_STATEFUL_JOBS_OF_TRIGGER_GROUP = "SELECT DISTINCT J.JOB_NAME, J.JOB_GROUP FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP AND J.IS_STATEFUL = ?";
    public static final String DELETE_JOB_LISTENERS = "DELETE FROM {0}JOB_LISTENERS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String DELETE_JOB_DETAIL = "DELETE FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_JOB_STATEFUL = "SELECT IS_STATEFUL FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_JOB_EXISTENCE = "SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String UPDATE_JOB_DATA = "UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String INSERT_JOB_LISTENER = "INSERT INTO {0}JOB_LISTENERS (JOB_NAME, JOB_GROUP, JOB_LISTENER) VALUES(?, ?, ?)";
    public static final String SELECT_JOB_LISTENERS = "SELECT JOB_LISTENER FROM {0}JOB_LISTENERS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_JOB_DETAIL = "SELECT * FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_NUM_JOBS = "SELECT COUNT(JOB_NAME)  FROM {0}JOB_DETAILS";
    public static final String SELECT_JOB_GROUPS = "SELECT DISTINCT(JOB_GROUP) FROM {0}JOB_DETAILS";
    public static final String SELECT_JOBS_IN_GROUP = "SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE JOB_GROUP = ?";
    public static final String SELECT_VOLATILE_JOBS = "SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE IS_VOLATILE = ?";
    public static final String INSERT_TRIGGER = "INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String INSERT_SIMPLE_TRIGGER = "INSERT INTO {0}SIMPLE_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED)  VALUES(?, ?, ?, ?, ?)";
    public static final String INSERT_CRON_TRIGGER = "INSERT INTO {0}CRON_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)  VALUES(?, ?, ?, ?)";
    public static final String INSERT_BLOB_TRIGGER = "INSERT INTO {0}BLOB_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA)  VALUES(?, ?, ?)";
    public static final String UPDATE_TRIGGER = "UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String UPDATE_SIMPLE_TRIGGER = "UPDATE {0}SIMPLE_TRIGGERS SET REPEAT_COUNT = ?, REPEAT_INTERVAL = ?, TIMES_TRIGGERED = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String UPDATE_CRON_TRIGGER = "UPDATE {0}CRON_TRIGGERS SET CRON_EXPRESSION = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String UPDATE_BLOB_TRIGGER = "UPDATE {0}BLOB_TRIGGERS SET BLOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_TRIGGER_EXISTENCE = "SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String UPDATE_TRIGGER_STATE = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String UPDATE_TRIGGER_STATE_FROM_STATE = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ?";
    public static final String UPDATE_TRIGGER_GROUP_STATE = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ?";
    public static final String UPDATE_TRIGGER_GROUP_STATE_FROM_STATE = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_GROUP = ? AND TRIGGER_STATE = ?";
    public static final String UPDATE_TRIGGER_STATE_FROM_STATES = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)";
    public static final String UPDATE_TRIGGER_GROUP_STATE_FROM_STATES = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)";
    public static final String UPDATE_JOB_TRIGGER_STATES = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String UPDATE_JOB_TRIGGER_STATES_FROM_OTHER_STATE = "UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE JOB_NAME = ? AND JOB_GROUP = ? AND TRIGGER_STATE = ?";
    public static final String DELETE_TRIGGER_LISTENERS = "DELETE FROM {0}TRIGGER_LISTENERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String INSERT_TRIGGER_LISTENER = "INSERT INTO {0}TRIGGER_LISTENERS (TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER) VALUES(?, ?, ?)";
    public static final String SELECT_TRIGGER_LISTENERS = "SELECT TRIGGER_LISTENER FROM {0}TRIGGER_LISTENERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String DELETE_SIMPLE_TRIGGER = "DELETE FROM {0}SIMPLE_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String DELETE_CRON_TRIGGER = "DELETE FROM {0}CRON_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String DELETE_BLOB_TRIGGER = "DELETE FROM {0}BLOB_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String DELETE_TRIGGER = "DELETE FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_NUM_TRIGGERS_FOR_JOB = "SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_JOB_FOR_TRIGGER = "SELECT J.JOB_NAME, J.JOB_GROUP, J.IS_DURABLE, J.JOB_CLASS_NAME, J.REQUESTS_RECOVERY FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.TRIGGER_NAME = ? AND T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP";
    public static final String SELECT_TRIGGER = "SELECT * FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_TRIGGER_STATE = "SELECT TRIGGER_STATE FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_TRIGGER_STATUS = "SELECT TRIGGER_STATE, NEXT_FIRE_TIME, JOB_NAME, JOB_GROUP FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_SIMPLE_TRIGGER = "SELECT * FROM {0}SIMPLE_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_CRON_TRIGGER = "SELECT * FROM {0}CRON_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_BLOB_TRIGGER = "SELECT * FROM {0}BLOB_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_NUM_TRIGGERS = "SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS";
    public static final String SELECT_NUM_TRIGGERS_IN_GROUP = "SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS WHERE TRIGGER_GROUP = ?";
    public static final String SELECT_TRIGGER_GROUPS = "SELECT DISTINCT(TRIGGER_GROUP) FROM {0}TRIGGERS";
    public static final String SELECT_TRIGGERS_IN_GROUP = "SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE TRIGGER_GROUP = ?";
    public static final String INSERT_CALENDAR = "INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)";
    public static final String UPDATE_CALENDAR = "UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?";
    public static final String SELECT_CALENDAR_EXISTENCE = "SELECT CALENDAR_NAME FROM {0}CALENDARS WHERE CALENDAR_NAME = ?";
    public static final String SELECT_CALENDAR = "SELECT * FROM {0}CALENDARS WHERE CALENDAR_NAME = ?";
    public static final String SELECT_REFERENCED_CALENDAR = "SELECT CALENDAR_NAME FROM {0}TRIGGERS WHERE CALENDAR_NAME = ?";
    public static final String DELETE_CALENDAR = "DELETE FROM {0}CALENDARS WHERE CALENDAR_NAME = ?";
    public static final String SELECT_NUM_CALENDARS = "SELECT COUNT(CALENDAR_NAME)  FROM {0}CALENDARS";
    public static final String SELECT_CALENDARS = "SELECT CALENDAR_NAME FROM {0}CALENDARS";
    public static final String SELECT_NEXT_FIRE_TIME = "SELECT MIN(NEXT_FIRE_TIME) AS ALIAS_NXT_FR_TM FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME >= 0";
    public static final String SELECT_TRIGGER_FOR_FIRE_TIME = "SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME = ?";
    public static final String INSERT_FIRED_TRIGGER = "INSERT INTO {0}FIRED_TRIGGERS (ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, IS_VOLATILE, INSTANCE_NAME, FIRED_TIME, STATE, JOB_NAME, JOB_GROUP, IS_STATEFUL, REQUESTS_RECOVERY) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_INSTANCES_FIRED_TRIGGER_STATE = "UPDATE {0}FIRED_TRIGGERS SET STATE = ? AND FIRED_TIME = ? WHERE INSTANCE_NAME = ?";
    public static final String SELECT_INSTANCES_FIRED_TRIGGERS = "SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ?";
    public static final String SELECT_INSTANCES_RECOVERABLE_FIRED_TRIGGERS = "SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ? AND REQUESTS_RECOVERY = ?";
    public static final String SELECT_JOB_EXECUTION_COUNT = "SELECT COUNT(TRIGGER_NAME) FROM {0}FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_FIRED_TRIGGERS = "SELECT * FROM {0}FIRED_TRIGGERS";
    public static final String SELECT_FIRED_TRIGGER = "SELECT * FROM {0}FIRED_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_FIRED_TRIGGER_GROUP = "SELECT * FROM {0}FIRED_TRIGGERS WHERE TRIGGER_GROUP = ?";
    public static final String SELECT_FIRED_TRIGGERS_OF_JOB = "SELECT * FROM {0}FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_FIRED_TRIGGERS_OF_JOB_GROUP = "SELECT * FROM {0}FIRED_TRIGGERS WHERE JOB_GROUP = ?";
    public static final String DELETE_FIRED_TRIGGER = "DELETE FROM {0}FIRED_TRIGGERS WHERE ENTRY_ID = ?";
    public static final String DELETE_INSTANCES_FIRED_TRIGGERS = "DELETE FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ?";
    public static final String DELETE_VOLATILE_FIRED_TRIGGERS = "DELETE FROM {0}FIRED_TRIGGERS WHERE IS_VOLATILE = ?";
    public static final String DELETE_NO_RECOVERY_FIRED_TRIGGERS = "DELETE FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ?REQUESTS_RECOVERY = ?";
    public static final String INSERT_SCHEDULER_STATE = "INSERT INTO {0}SCHEDULER_STATE (INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL, RECOVERER) VALUES(?, ?, ?, ?)";
    public static final String SELECT_SCHEDULER_STATE = "SELECT * FROM {0}SCHEDULER_STATE WHERE INSTANCE_NAME = ?";
    public static final String SELECT_SCHEDULER_STATES = "SELECT * FROM {0}SCHEDULER_STATE";
    public static final String DELETE_SCHEDULER_STATE = "DELETE FROM {0}SCHEDULER_STATE WHERE INSTANCE_NAME = ?";
    public static final String INSERT_PAUSED_TRIGGER_GROUP = "INSERT INTO {0}PAUSED_TRIGGER_GRPS (TRIGGER_GROUP) VALUES(?)";
    public static final String SELECT_PAUSED_TRIGGER_GROUP = "SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS WHERE TRIGGER_GROUP = ?";
    public static final String SELECT_PAUSED_TRIGGER_GROUPS = "SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS";
    public static final String DELETE_PAUSED_TRIGGER_GROUP = "DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE TRIGGER_GROUP = ?";
    public static final String DELETE_PAUSED_TRIGGER_GROUPS = "DELETE FROM {0}PAUSED_TRIGGER_GRPS";
}

