/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.odmg;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import ojb.odmg.locking.LockManager;
import ojb.odmg.locking.LockManagerFactory;
import org.odmg.Database;
import test.ojb.odmg.Article;

public class LockingTest
extends TestCase {
    private static Class CLASS = class$test$ojb$odmg$LockingTest == null ? (class$test$ojb$odmg$LockingTest = LockingTest.class$("test.ojb.odmg.LockingTest")) : class$test$ojb$odmg$LockingTest;
    private String databaseName;
    static /* synthetic */ Class class$test$ojb$odmg$LockingTest;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public LockingTest(String name) {
        super(name);
    }

    public void setUp() {
        this.databaseName = "repository.xml";
    }

    public void tearDown() {
        try {
            OJB.getInstance().currentTransaction().abort();
            OJB.getInstance().getDatabase(null).close();
            this.databaseName = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testLockBasics() {
        try {
            OJB odmg = OJB.getInstance();
            Database db = odmg.newDatabase();
            db.open(this.databaseName, 2);
            TransactionImpl tx1 = (TransactionImpl)odmg.newTransaction();
            TransactionImpl tx2 = (TransactionImpl)odmg.newTransaction();
            Article a = new Article();
            a.setArticleId(333);
            LockManager lm = LockManagerFactory.getLockManager();
            boolean success1 = lm.writeLock(tx1, a);
            boolean success2 = lm.writeLock(tx2, a);
            boolean success3 = lm.releaseLock(tx1, a);
            Assert.assertTrue((String)"1st lock should succeed", (boolean)success1);
            Assert.assertTrue((String)"2nd lock should not succeed", (!success2 ? 1 : 0) != 0);
            Assert.assertTrue((String)"release should succeed", (boolean)success3);
        }
        catch (Throwable ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

