/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.impl;

import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentException;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentableException;
import org.apache.excalibur.instrument.manager.impl.InstrumentProxy;
import org.apache.excalibur.instrument.manager.impl.InstrumentableProxy;

public class InstrumentableDescriptorImpl
implements InstrumentableDescriptor {
    private InstrumentableProxy m_instrumentableProxy;

    InstrumentableDescriptorImpl(InstrumentableProxy instrumentableProxy) {
        this.m_instrumentableProxy = instrumentableProxy;
    }

    public boolean isConfigured() {
        return this.m_instrumentableProxy.isConfigured();
    }

    public boolean isRegistered() {
        return this.m_instrumentableProxy.isRegistered();
    }

    public String getName() {
        return this.m_instrumentableProxy.getName();
    }

    public String getDescription() {
        return this.m_instrumentableProxy.getDescription();
    }

    public InstrumentableDescriptor getParentInstrumentableDescriptor() {
        InstrumentableProxy parent = this.m_instrumentableProxy.getParentInstrumentableProxy();
        if (parent == null) {
            return null;
        }
        return parent.getDescriptor();
    }

    public InstrumentableDescriptor getChildInstrumentableDescriptor(String childInstrumentableName) throws NoSuchInstrumentableException {
        InstrumentableProxy instrumentableProxy = this.m_instrumentableProxy.getChildInstrumentableProxy(childInstrumentableName);
        if (instrumentableProxy == null) {
            throw new NoSuchInstrumentableException("No child instrumentable can be found using name: " + childInstrumentableName);
        }
        return instrumentableProxy.getDescriptor();
    }

    public InstrumentableDescriptor[] getChildInstrumentableDescriptors() {
        return this.m_instrumentableProxy.getChildInstrumentableDescriptors();
    }

    public InstrumentDescriptor getInstrumentDescriptor(String instrumentName) throws NoSuchInstrumentException {
        InstrumentProxy instrumentProxy = this.m_instrumentableProxy.getInstrumentProxy(instrumentName);
        if (instrumentProxy == null) {
            throw new NoSuchInstrumentException("No instrument can be found using name: " + instrumentName);
        }
        return instrumentProxy.getDescriptor();
    }

    public InstrumentDescriptor[] getInstrumentDescriptors() {
        return this.m_instrumentableProxy.getInstrumentDescriptors();
    }

    public int getStateVersion() {
        return this.m_instrumentableProxy.getStateVersion();
    }
}

