/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.criteria;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.torque.Column;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.criteria.JoinType;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;

public class Join
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Criterion joinCondition = null;
    private PreparedStatementPart leftTable = null;
    private PreparedStatementPart rightTable = null;
    private JoinType joinType = null;

    public Join(Column leftColumn, Column rightColumn, SqlEnum comparison, JoinType joinType) {
        if (leftColumn == null) {
            throw new NullPointerException("leftColumn is null");
        }
        if (rightColumn == null) {
            throw new NullPointerException("rightColumn is null");
        }
        if (comparison == null) {
            throw new NullPointerException("comparison is null");
        }
        if (comparison == SqlEnum.CUSTOM) {
            throw new IllegalArgumentException("The comparison SqlEnum.CUSTOM is not supported for Joins.");
        }
        this.joinCondition = new Criterion(leftColumn, rightColumn, comparison);
        this.joinType = joinType;
    }

    public Join(PreparedStatementPart leftTable, PreparedStatementPart rightTable, Criterion joinCondition, JoinType joinType) {
        if (joinCondition == null) {
            throw new NullPointerException("joinCondition is null");
        }
        this.leftTable = leftTable;
        this.rightTable = rightTable;
        this.joinCondition = joinCondition;
        this.joinType = joinType;
    }

    public final Criterion getJoinCondition() {
        return this.joinCondition;
    }

    public final JoinType getJoinType() {
        return this.joinType;
    }

    public final PreparedStatementPart getLeftTable() {
        return this.leftTable;
    }

    public final PreparedStatementPart getRightTable() {
        return this.rightTable;
    }

    public String toString() {
        return (Object)((Object)this.joinType) + "(" + this.leftTable + ", " + this.rightTable + "): " + this.joinCondition.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Join)) {
            return false;
        }
        Join join = (Join)obj;
        return new EqualsBuilder().append((Object)this.leftTable, (Object)join.leftTable).append((Object)this.rightTable, (Object)join.rightTable).append((Object)this.joinCondition, (Object)join.joinCondition).append((Object)this.joinType, (Object)join.getJoinType()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftTable).append((Object)this.rightTable).append((Object)this.joinCondition).append((Object)this.joinType).toHashCode();
    }
}

