/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.torque.Column;
import org.apache.torque.criteria.CriteriaInterface;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.criteria.Join;
import org.apache.torque.criteria.JoinType;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.sql.OrderBy;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.UniqueColumnList;
import org.apache.torque.util.UniqueList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Criteria
implements Serializable,
Cloneable,
CriteriaInterface<Criteria> {
    private static final long serialVersionUID = -9001666575933085601L;
    public static final SqlEnum EQUAL = SqlEnum.EQUAL;
    public static final SqlEnum NOT_EQUAL = SqlEnum.NOT_EQUAL;
    public static final SqlEnum ALT_NOT_EQUAL = SqlEnum.ALT_NOT_EQUAL;
    public static final SqlEnum GREATER_THAN = SqlEnum.GREATER_THAN;
    public static final SqlEnum LESS_THAN = SqlEnum.LESS_THAN;
    public static final SqlEnum GREATER_EQUAL = SqlEnum.GREATER_EQUAL;
    public static final SqlEnum LESS_EQUAL = SqlEnum.LESS_EQUAL;
    public static final SqlEnum LIKE = SqlEnum.LIKE;
    public static final SqlEnum NOT_LIKE = SqlEnum.NOT_LIKE;
    public static final SqlEnum ILIKE = SqlEnum.ILIKE;
    public static final SqlEnum NOT_ILIKE = SqlEnum.NOT_ILIKE;
    public static final SqlEnum DISTINCT = SqlEnum.DISTINCT;
    public static final SqlEnum IN = SqlEnum.IN;
    public static final SqlEnum NOT_IN = SqlEnum.NOT_IN;
    public static final SqlEnum ALL = SqlEnum.ALL;
    public static final SqlEnum JOIN = SqlEnum.JOIN;
    public static final SqlEnum ISNULL = SqlEnum.ISNULL;
    public static final SqlEnum ISNOTNULL = SqlEnum.ISNOTNULL;
    public static final SqlEnum CURRENT_DATE = SqlEnum.CURRENT_DATE;
    public static final SqlEnum CURRENT_TIME = SqlEnum.CURRENT_TIME;
    public static final SqlEnum CURRENT_TIMESTAMP = SqlEnum.CURRENT_TIMESTAMP;
    public static final JoinType LEFT_JOIN = JoinType.LEFT_JOIN;
    public static final JoinType RIGHT_JOIN = JoinType.RIGHT_JOIN;
    public static final JoinType INNER_JOIN = JoinType.INNER_JOIN;
    private boolean ignoreCase = false;
    private boolean singleRecord = false;
    private final UniqueList<String> selectModifiers;
    private final UniqueColumnList selectColumns;
    private final UniqueList<OrderBy> orderByColumns;
    private final UniqueColumnList groupByColumns;
    private final UniqueList<FromElement> fromElements;
    private Criterion having = null;
    private boolean forUpdate = false;
    private Criterion topLevelCriterion;
    private final Map<String, Column> asColumns;
    private final List<Join> joins;
    private String dbName;
    private int limit = -1;
    private long offset = 0L;
    private final Map<String, Object> aliases;
    private Integer fetchSize;

    public Criteria() {
        this.selectModifiers = new UniqueList();
        this.selectColumns = new UniqueColumnList();
        this.orderByColumns = new UniqueList();
        this.groupByColumns = new UniqueColumnList();
        this.fromElements = new UniqueList();
        this.asColumns = new LinkedHashMap<String, Column>();
        this.joins = new ArrayList<Join>();
        this.aliases = new HashMap<String, Object>();
    }

    public Criteria(String dbName) {
        this();
        this.dbName = dbName;
    }

    public Criteria(Criteria toCopy) {
        this.ignoreCase = toCopy.ignoreCase;
        this.singleRecord = toCopy.singleRecord;
        this.selectModifiers = new UniqueList<String>(toCopy.selectModifiers);
        this.selectColumns = new UniqueColumnList(toCopy.selectColumns);
        this.orderByColumns = new UniqueList<OrderBy>(toCopy.orderByColumns);
        this.groupByColumns = new UniqueColumnList(toCopy.groupByColumns);
        this.fromElements = new UniqueList<FromElement>(toCopy.fromElements);
        if (toCopy.having != null) {
            this.having = new Criterion(toCopy.having);
        }
        this.forUpdate = toCopy.forUpdate;
        if (toCopy.topLevelCriterion != null) {
            this.topLevelCriterion = new Criterion(toCopy.topLevelCriterion);
        }
        this.asColumns = new HashMap<String, Column>(toCopy.asColumns);
        this.joins = new ArrayList<Join>(toCopy.joins);
        this.dbName = toCopy.dbName;
        this.limit = toCopy.limit;
        this.offset = toCopy.offset;
        this.aliases = new HashMap<String, Object>(toCopy.aliases);
        this.fetchSize = toCopy.fetchSize;
    }

    public Criteria addAsColumn(String name, Column clause) {
        this.asColumns.put(name, clause);
        return this;
    }

    @Override
    public Map<String, Column> getAsColumns() {
        return this.asColumns;
    }

    @Override
    public Map<String, Object> getAliases() {
        return this.aliases;
    }

    @Override
    public Criteria addAlias(String alias, String table) {
        this.aliases.put(alias, table);
        return this;
    }

    public Criteria addAlias(String alias, Criteria subselect) {
        this.aliases.put(alias, subselect);
        return this;
    }

    @Override
    public String getTableForAlias(String alias) {
        Object aliasResolved = this.aliases.get(alias);
        if (aliasResolved == null) {
            return null;
        }
        if (aliasResolved instanceof String) {
            return (String)aliasResolved;
        }
        throw new IllegalArgumentException("The alias " + alias + " is not associated to a table but to an object of type " + alias.getClass().getName());
    }

    public Criteria getSubselectForAlias(String alias) {
        Object aliasResolved = this.aliases.get(alias);
        if (aliasResolved == null) {
            return null;
        }
        if (aliasResolved instanceof Criteria) {
            return (Criteria)aliasResolved;
        }
        throw new IllegalArgumentException("The alias " + alias + " is not associated to a subselect but to an object of type " + alias.getClass().getName());
    }

    public Criterion getTopLevelCriterion() {
        return this.topLevelCriterion;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public Criteria addHaving(Criterion having) {
        this.having = having;
        return this;
    }

    public Criterion getHaving() {
        return this.having;
    }

    public Criteria forUpdate() {
        this.forUpdate = true;
        return this;
    }

    public Criteria setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public Criteria addJoin(Column left, Column right) {
        return this.addJoin(left, right, null);
    }

    public Criteria addJoin(Column left, Column right, JoinType joinType) {
        this.joins.add(new Join(left, right, EQUAL, joinType));
        return this;
    }

    public Criteria addJoin(Column left, Column right, SqlEnum comparison, JoinType joinType) {
        this.joins.add(new Join(left, right, comparison, joinType));
        return this;
    }

    public Criteria addJoin(String leftTable, String rightTable, Criterion joinCondition, JoinType joinType) {
        this.joins.add(new Join(new PreparedStatementPart(leftTable, new Object[0]), new PreparedStatementPart(rightTable, new Object[0]), joinCondition, joinType));
        return this;
    }

    public Criteria addJoin(PreparedStatementPart leftTable, PreparedStatementPart rightTable, Criterion joinCondition, JoinType joinType) {
        this.joins.add(new Join(leftTable, rightTable, joinCondition, joinType));
        return this;
    }

    @Override
    public List<Join> getJoins() {
        return this.joins;
    }

    @Override
    public void setAll() {
        this.selectModifiers.add(ALL.toString());
    }

    @Override
    public void setDistinct() {
        this.selectModifiers.add(DISTINCT.toString());
    }

    public Criteria setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Criteria setSingleRecord(boolean b) {
        this.singleRecord = b;
        return this;
    }

    @Override
    public boolean isSingleRecord() {
        return this.singleRecord;
    }

    @Override
    public Criteria setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public Criteria setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public Criteria addSelectColumn(Column column) {
        this.selectColumns.add(column);
        return this;
    }

    @Override
    public UniqueColumnList getSelectColumns() {
        return this.selectColumns;
    }

    @Override
    public UniqueList<String> getSelectModifiers() {
        return this.selectModifiers;
    }

    public Criteria addGroupByColumn(Column groupBy) {
        this.groupByColumns.add(groupBy);
        return this;
    }

    @Override
    public UniqueColumnList getGroupByColumns() {
        return this.groupByColumns;
    }

    public Criteria addAscendingOrderByColumn(Column column) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.ASC, false));
        return this;
    }

    public Criteria addAscendingOrderByColumn(Column column, boolean ignoreCase) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.ASC, ignoreCase));
        return this;
    }

    public Criteria addDescendingOrderByColumn(Column column) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.DESC, false));
        return this;
    }

    public Criteria addDescendingOrderByColumn(Column column, boolean ignoreCase) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.DESC, ignoreCase));
        return this;
    }

    @Override
    public UniqueList<OrderBy> getOrderByColumns() {
        return this.orderByColumns;
    }

    public UniqueList<FromElement> getFromElements() {
        return this.fromElements;
    }

    public Criteria addFrom(String tableName) {
        this.fromElements.add(new FromElement(tableName));
        return this;
    }

    public Criteria addFrom(FromElement fromElement) {
        this.fromElements.add(fromElement);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Criteria: ");
        try {
            Query query = SqlBuilder.buildQuery(this);
            sb.append("Current Query SQL (may not be complete or applicable): ").append(query.getDisplayString());
        }
        catch (Exception exc) {
            sb.append("Error" + exc.getMessage());
        }
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Criteria criteria = (Criteria)object;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)criteria.topLevelCriterion, (Object)this.topLevelCriterion);
        equalsBuilder.append(criteria.offset, this.offset);
        equalsBuilder.append(criteria.limit, this.limit);
        equalsBuilder.append(criteria.ignoreCase, this.ignoreCase);
        equalsBuilder.append(criteria.singleRecord, this.singleRecord);
        equalsBuilder.append((Object)criteria.dbName, (Object)this.dbName);
        equalsBuilder.append(criteria.selectModifiers, this.selectModifiers);
        equalsBuilder.append((Object)criteria.selectColumns, (Object)this.selectColumns);
        equalsBuilder.append(criteria.orderByColumns, this.orderByColumns);
        equalsBuilder.append(criteria.fromElements, this.fromElements);
        equalsBuilder.append(criteria.aliases, this.aliases);
        equalsBuilder.append(criteria.asColumns, this.asColumns);
        equalsBuilder.append(criteria.joins, this.joins);
        equalsBuilder.append((Object)criteria.fetchSize, (Object)this.fetchSize);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.topLevelCriterion);
        hashCodeBuilder.append(this.offset);
        hashCodeBuilder.append(this.limit);
        hashCodeBuilder.append(this.ignoreCase);
        hashCodeBuilder.append(this.singleRecord);
        hashCodeBuilder.append((Object)this.dbName);
        hashCodeBuilder.append(this.selectModifiers);
        hashCodeBuilder.append((Object)this.selectColumns);
        hashCodeBuilder.append(this.orderByColumns);
        hashCodeBuilder.append(this.fromElements);
        hashCodeBuilder.append(this.aliases);
        hashCodeBuilder.append(this.asColumns);
        hashCodeBuilder.append(this.joins);
        hashCodeBuilder.append((Object)this.fetchSize);
        return hashCodeBuilder.toHashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Criteria and(Criterion criterion) {
        if (this.topLevelCriterion == null) {
            this.topLevelCriterion = new Criterion(criterion);
        } else {
            this.topLevelCriterion.and(new Criterion(criterion));
        }
        return this;
    }

    public Criteria and(Object lValue, Object rValue) {
        SqlEnum sqlEnum;
        if (rValue instanceof SqlEnum && (sqlEnum = (SqlEnum)rValue).getNumberOfCompareOperands() == 1) {
            return this.and(lValue, null, sqlEnum);
        }
        return this.and(lValue, rValue, EQUAL);
    }

    public Criteria and(Object lValue, Object rValue, SqlEnum comparison) {
        Criterion newCriterion = comparison == SqlEnum.CUSTOM ? new Criterion(lValue, null, null, (String)rValue, null) : new Criterion(lValue, rValue, comparison);
        if (this.topLevelCriterion == null) {
            this.topLevelCriterion = newCriterion;
        } else {
            this.topLevelCriterion.and(newCriterion);
        }
        return this;
    }

    public Criteria andDate(Object lValue, int year, int month, int day) {
        return this.and(lValue, new GregorianCalendar(year, month, day).getTime(), EQUAL);
    }

    public Criteria andDate(Object lValue, int year, int month, int day, SqlEnum comparison) {
        return this.and(lValue, new GregorianCalendar(year, month, day).getTime(), comparison);
    }

    public Criteria andIn(Object lValue, Object[] rValues) {
        return this.and(lValue, rValues, IN);
    }

    public Criteria andIn(Object lValue, Collection<?> rValues) {
        return this.and(lValue, rValues, IN);
    }

    public Criteria andNotIn(Object lValue, Object[] rValues) {
        return this.and(lValue, rValues, NOT_IN);
    }

    public Criteria andNotIn(Object lValue, Collection<?> rValues) {
        return this.and(lValue, rValues, NOT_IN);
    }

    public Criteria andVerbatimSql(String sql, Object[] replacements) {
        Criterion criterion = new Criterion(null, null, null, sql, replacements);
        this.and(criterion);
        return this;
    }

    public Criteria andVerbatimSql(String sql, Object[] replacements, Column toAddToFromClause1, Column toAddToFromClause2) {
        Criterion criterion = new Criterion(toAddToFromClause1, toAddToFromClause2, null, sql, replacements);
        this.and(criterion);
        return this;
    }

    public Criteria or(Criterion criterion) {
        if (this.topLevelCriterion == null) {
            this.topLevelCriterion = new Criterion(criterion);
        } else {
            this.topLevelCriterion.or(new Criterion(criterion));
        }
        return this;
    }

    public Criteria or(Object lValue, Object rValue) {
        SqlEnum sqlEnum;
        if (rValue instanceof SqlEnum && (sqlEnum = (SqlEnum)rValue).getNumberOfCompareOperands() == 1) {
            return this.or(lValue, null, sqlEnum);
        }
        return this.or(lValue, rValue, EQUAL);
    }

    public Criteria or(Object lValue, Object rValue, SqlEnum comparison) {
        Criterion newCriterion = comparison == SqlEnum.CUSTOM ? new Criterion(lValue, null, null, (String)rValue, null) : new Criterion(lValue, rValue, comparison);
        if (this.topLevelCriterion == null) {
            this.topLevelCriterion = newCriterion;
        } else {
            this.topLevelCriterion.or(newCriterion);
        }
        return this;
    }

    public Criteria orDate(Object lValue, int year, int month, int day) {
        return this.or(lValue, new GregorianCalendar(year, month, day).getTime(), EQUAL);
    }

    public Criteria orDate(Object lValue, int year, int month, int day, SqlEnum comparison) {
        return this.or(lValue, new GregorianCalendar(year, month, day).getTime(), comparison);
    }

    public Criteria orIn(Object lValue, Object[] rValues) {
        return this.or(lValue, rValues, IN);
    }

    public Criteria orIn(Object lValue, Collection<?> rValues) {
        return this.or(lValue, rValues, IN);
    }

    public Criteria orNotIn(Object lValue, Object[] rValues) {
        return this.or(lValue, rValues, NOT_IN);
    }

    public Criteria orNotIn(Object lValue, Collection<?> rValues) {
        return this.or(lValue, rValues, NOT_IN);
    }

    public Criteria orVerbatimSql(String sql, Object[] replacements) {
        Criterion criterion = new Criterion(null, null, null, sql, replacements);
        this.or(criterion);
        return this;
    }

    public Criteria orVerbatimSql(String sql, Object[] replacements, Column toAddToFromClause1, Column toAddToFromClause2) {
        Criterion criterion = new Criterion(toAddToFromClause1, toAddToFromClause2, null, sql, replacements);
        this.or(criterion);
        return this;
    }

    public Criteria where(Criterion criterion) {
        return this.and(criterion);
    }

    public Criteria where(Object lValue, Object rValue) {
        return this.and(lValue, rValue);
    }

    public Criteria where(Object lValue, Object rValue, SqlEnum comparison) {
        return this.and(lValue, rValue, comparison);
    }

    public Criteria whereDate(Object lValue, int year, int month, int day) {
        return this.andDate(lValue, year, month, day);
    }

    public Criteria whereDate(Object lValue, int year, int month, int day, SqlEnum comparison) {
        return this.andDate(lValue, year, month, day, comparison);
    }

    public Criteria whereIn(Object lValue, Object[] rValues) {
        return this.andIn(lValue, rValues);
    }

    public Criteria whereIn(Object lValue, Collection<?> rValues) {
        return this.andIn(lValue, rValues);
    }

    public Criteria whereNotIn(Object lValue, Object[] rValues) {
        return this.andNotIn(lValue, rValues);
    }

    public Criteria whereNotIn(Object lValue, Collection<?> rValues) {
        return this.andNotIn(lValue, rValues);
    }

    public Criteria whereVerbatimSql(String sql, Object[] replacements) {
        Criterion criterion = new Criterion(null, null, null, sql, replacements);
        this.and(criterion);
        return this;
    }

    public Criteria whereVerbatimSql(String sql, Object[] replacements, Column toAddToFromClause1, Column toAddToFromClause2) {
        Criterion criterion = new Criterion(toAddToFromClause1, toAddToFromClause2, null, sql, replacements);
        this.and(criterion);
        return this;
    }
}

