/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.oid;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.om.mapper.BigDecimalMapper;
import org.apache.torque.om.mapper.IntegerMapper;
import org.apache.torque.om.mapper.LongMapper;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.StringMapper;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.BasePeerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdGenerator
implements IdGenerator {
    protected Adapter adapter;
    protected String databaseName = null;

    public AbstractIdGenerator(Adapter adapter, String databaseName) {
        this.adapter = adapter;
        this.databaseName = databaseName;
    }

    @Override
    public int getIdAsInt(Connection connection, Object keyInfo) throws TorqueException {
        return this.getId(connection, keyInfo, new IntegerMapper());
    }

    @Override
    public long getIdAsLong(Connection connection, Object keyInfo) throws TorqueException {
        return this.getId(connection, keyInfo, new LongMapper());
    }

    @Override
    public BigDecimal getIdAsBigDecimal(Connection connection, Object keyInfo) throws TorqueException {
        return this.getId(connection, keyInfo, new BigDecimalMapper());
    }

    @Override
    public String getIdAsString(Connection connection, Object keyInfo) throws TorqueException {
        return this.getId(connection, keyInfo, new StringMapper());
    }

    @Override
    public abstract boolean isPriorToInsert();

    @Override
    public abstract boolean isPostInsert();

    @Override
    public abstract boolean isConnectionRequired();

    protected <T> T getId(Connection connection, Object keyInfo, RecordMapper<T> mapper) throws TorqueException {
        String tableName = SqlBuilder.getFullTableName(String.valueOf(keyInfo), this.databaseName);
        String idSql = this.adapter.getIDMethodSQL(tableName);
        BasePeerImpl<T> peer = new BasePeerImpl<T>(mapper, null, this.databaseName);
        List<T> result = peer.doSelect(idSql, connection);
        return result.get(0);
    }
}

