/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.spi;

import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.spi.AbstractEntityManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractPermissionManager
extends AbstractEntityManager
implements PermissionManager {
    protected abstract <T extends Permission> T persistNewPermission(T var1) throws DataBackendException;

    @Override
    public <T extends Permission> T getPermissionInstance() throws DataBackendException {
        try {
            Permission permission = (Permission)Class.forName(this.getClassName()).newInstance();
            return (T)permission;
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to instantiate a Permission implementation object", e);
        }
    }

    @Override
    public <T extends Permission> T getPermissionInstance(String permName) throws DataBackendException {
        T perm = this.getPermissionInstance();
        perm.setName(permName);
        return perm;
    }

    @Override
    public <T extends Permission> T getPermissionByName(String name) throws DataBackendException, UnknownEntityException {
        Permission permission = (Permission)this.getAllPermissions().getByName(name);
        if (permission == null) {
            throw new UnknownEntityException("The specified permission does not exist");
        }
        return (T)permission;
    }

    @Override
    public <T extends Permission> T getPermissionById(Object id) throws DataBackendException, UnknownEntityException {
        Permission permission = (Permission)this.getAllPermissions().getById(id);
        if (permission == null) {
            throw new UnknownEntityException("The specified permission does not exist");
        }
        return (T)permission;
    }

    @Override
    public synchronized <T extends Permission> T addPermission(T permission) throws DataBackendException, EntityExistsException {
        boolean permissionExists = false;
        if (StringUtils.isEmpty((CharSequence)permission.getName())) {
            throw new DataBackendException("Could not create a permission with empty name!");
        }
        if (permission.getId() != null) {
            throw new DataBackendException("Could not create a permission with an id of null!");
        }
        try {
            permissionExists = this.checkExists(permission);
            if (!permissionExists) {
                return this.persistNewPermission(permission);
            }
        }
        catch (Exception e) {
            throw new DataBackendException("addPermission(Permission) failed", e);
        }
        throw new EntityExistsException("Permission '" + permission + "' already exists");
    }

    @Override
    public boolean checkExists(Permission permission) throws DataBackendException {
        return this.checkExists(permission.getName());
    }
}

