/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.mimetype.MimeTypeService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;

public class LocaleUtils {
    private static final Logger log = LogManager.getLogger(LocaleUtils.class);
    private static Locale defaultLocale = null;
    private static String defaultCharSet = null;

    public static String getDefaultInputEncoding() {
        String inputEncoding = Turbine.getConfiguration().getString("input.encoding", "ISO-8859-1");
        log.debug("Input Encoding has been set to {}", (Object)inputEncoding);
        return inputEncoding;
    }

    public static Locale getDefaultLocale() {
        if (defaultLocale == null) {
            String lang = Turbine.getConfiguration().getString("locale.default.language", "en");
            String country = Turbine.getConfiguration().getString("locale.default.country", "US");
            defaultLocale = new Locale(lang, country);
        }
        return defaultLocale;
    }

    public static String getDefaultCharSet() {
        String charset;
        if (defaultCharSet == null) {
            defaultCharSet = Turbine.getConfiguration().getString("locale.default.charset", "ISO-8859-1");
            log.debug("defaultCharSet = {} (From Properties)", (Object)defaultCharSet);
        }
        if (StringUtils.isEmpty((CharSequence)(charset = defaultCharSet))) {
            log.debug("Default charset is empty!");
            Locale locale = LocaleUtils.getDefaultLocale();
            log.debug("Locale is {}", (Object)locale);
            if (!locale.equals(Locale.US)) {
                log.debug("We don't have US Locale!");
                ServiceManager serviceManager = TurbineServices.getInstance();
                MimeTypeService mimeTypeService = null;
                try {
                    mimeTypeService = (MimeTypeService)serviceManager.getService(MimeTypeService.ROLE);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                charset = mimeTypeService.getCharSet(locale);
                log.debug("Charset now {}", (Object)charset);
            }
        }
        log.debug("Returning default Charset of {}", (Object)charset);
        return charset;
    }

    public static String getOverrideCharSet() {
        return Turbine.getConfiguration().getString("locale.override.charset");
    }
}

