/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.MultiPartEmail;

public class HtmlEmail
extends MultiPartEmail {
    public static final int CID_LENGTH = 10;
    private static final String HTML_MESSAGE_START = "<html><body><pre>";
    private static final String HTML_MESSAGE_END = "</pre></body></html>";
    @Deprecated
    protected String text;
    @Deprecated
    protected String html;
    @Deprecated
    protected List<InlineImage> inlineImages;
    @Deprecated
    protected Map<String, InlineImage> inlineEmbeds = new HashMap<String, InlineImage>();

    private void build() throws MessagingException, EmailException {
        MimeMultipart rootContainer;
        MimeMultipart bodyEmbedsContainer = rootContainer = this.getContainer();
        MimeMultipart bodyContainer = rootContainer;
        MimeBodyPart msgHtml = null;
        MimeBodyPart msgText = null;
        rootContainer.setSubType("mixed");
        if (EmailUtils.isNotEmpty(this.html) && !EmailUtils.isEmpty(this.inlineEmbeds)) {
            bodyContainer = bodyEmbedsContainer = new MimeMultipart("related");
            this.addPart(bodyEmbedsContainer, 0);
            if (EmailUtils.isNotEmpty(this.text)) {
                bodyContainer = new MimeMultipart("alternative");
                BodyPart bodyPart = this.createBodyPart();
                try {
                    bodyPart.setContent((Multipart)bodyContainer);
                    bodyEmbedsContainer.addBodyPart(bodyPart, 0);
                }
                catch (MessagingException e) {
                    throw new EmailException(e);
                }
            }
        } else if (EmailUtils.isNotEmpty(this.text) && EmailUtils.isNotEmpty(this.html)) {
            if (!EmailUtils.isEmpty(this.inlineEmbeds) || this.isBoolHasAttachments()) {
                bodyContainer = new MimeMultipart("alternative");
                this.addPart(bodyContainer, 0);
            } else {
                rootContainer.setSubType("alternative");
            }
        }
        if (EmailUtils.isNotEmpty(this.html)) {
            msgHtml = new MimeBodyPart();
            bodyContainer.addBodyPart((BodyPart)msgHtml, 0);
            msgHtml.setText(this.html, this.getCharsetName(), "html");
            String contentType = msgHtml.getContentType();
            if (contentType == null || !contentType.equals("text/html")) {
                if (EmailUtils.isNotEmpty(this.getCharsetName())) {
                    msgHtml.setContent((Object)this.html, "text/html; charset=" + this.getCharsetName());
                } else {
                    msgHtml.setContent((Object)this.html, "text/html");
                }
            }
            for (InlineImage image : this.inlineEmbeds.values()) {
                bodyEmbedsContainer.addBodyPart((BodyPart)image.getMimeBodyPart());
            }
        }
        if (EmailUtils.isNotEmpty(this.text)) {
            msgText = new MimeBodyPart();
            bodyContainer.addBodyPart((BodyPart)msgText, 0);
            msgText.setText(this.text, this.getCharsetName());
        }
    }

    @Override
    public void buildMimeMessage() throws EmailException {
        try {
            this.build();
        }
        catch (MessagingException e) {
            throw new EmailException(e);
        }
        super.buildMimeMessage();
    }

    public String embed(DataSource dataSource, String name) throws EmailException {
        InlineImage inlineImage = this.inlineEmbeds.get(name);
        if (inlineImage != null) {
            if (dataSource.equals((Object)inlineImage.getDataSource())) {
                return inlineImage.getCid();
            }
            throw new EmailException("embedded DataSource '" + name + "' is already bound to name " + inlineImage.getDataSource().toString() + "; existing names cannot be rebound");
        }
        String cid = EmailUtils.toLower(EmailUtils.randomAlphabetic(10));
        return this.embed(dataSource, name, cid);
    }

    public String embed(DataSource dataSource, String name, String cid) throws EmailException {
        EmailException.checkNonEmpty(name, () -> "Name cannot be null or empty");
        MimeBodyPart mbp = new MimeBodyPart();
        try {
            String encodedCid = EmailUtils.encodeUrl(cid);
            mbp.setDataHandler(new DataHandler(dataSource));
            mbp.setFileName(name);
            mbp.setDisposition("inline");
            mbp.setContentID("<" + encodedCid + ">");
            this.inlineEmbeds.put(name, new InlineImage(encodedCid, dataSource, mbp));
            return encodedCid;
        }
        catch (MessagingException e) {
            throw new EmailException(e);
        }
    }

    public String embed(File file) throws EmailException {
        return this.embed(file, EmailUtils.toLower(EmailUtils.randomAlphabetic(10)));
    }

    public String embed(File file, String cid) throws EmailException {
        EmailException.checkNonEmpty(file.getName(), () -> "File name cannot be null or empty");
        String filePath = null;
        try {
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new EmailException("couldn't get canonical path for " + file.getName(), e);
        }
        InlineImage inlineImage = this.inlineEmbeds.get(file.getName());
        if (inlineImage != null) {
            FileDataSource fileDataSource = (FileDataSource)inlineImage.getDataSource();
            String existingFilePath = null;
            try {
                existingFilePath = fileDataSource.getFile().getCanonicalPath();
            }
            catch (IOException e) {
                throw new EmailException("couldn't get canonical path for file " + fileDataSource.getFile().getName() + "which has already been embedded", e);
            }
            if (filePath.equals(existingFilePath)) {
                return inlineImage.getCid();
            }
            throw new EmailException("embedded name '" + file.getName() + "' is already bound to file " + existingFilePath + "; existing names cannot be rebound");
        }
        if (!file.exists()) {
            throw new EmailException("file " + filePath + " doesn't exist");
        }
        if (!file.isFile()) {
            throw new EmailException("file " + filePath + " isn't a normal file");
        }
        if (!file.canRead()) {
            throw new EmailException("file " + filePath + " isn't readable");
        }
        return this.embed((DataSource)new FileDataSource(file), file.getName(), cid);
    }

    public String embed(String urlString, String name) throws EmailException {
        try {
            return this.embed(new URL(urlString), name);
        }
        catch (MalformedURLException e) {
            throw new EmailException("Invalid URL", e);
        }
    }

    public String embed(URL url, String name) throws EmailException {
        EmailException.checkNonEmpty(name, () -> "Name cannot be null or empty");
        InlineImage inlineImage = this.inlineEmbeds.get(name);
        if (inlineImage != null) {
            URLDataSource urlDataSource = (URLDataSource)inlineImage.getDataSource();
            if (url.toExternalForm().equals(urlDataSource.getURL().toExternalForm())) {
                return inlineImage.getCid();
            }
            throw new EmailException("embedded name '" + name + "' is already bound to URL " + urlDataSource.getURL() + "; existing names cannot be rebound");
        }
        try (InputStream inputStream = url.openStream();){
            inputStream.read();
        }
        catch (IOException e) {
            throw new EmailException("Invalid URL", e);
        }
        return this.embed((DataSource)new URLDataSource(url), name);
    }

    public String getHtml() {
        return this.html;
    }

    public String getText() {
        return this.text;
    }

    public HtmlEmail setHtmlMsg(String html) throws EmailException {
        this.html = EmailException.checkNonEmpty(html, () -> "Invalid message.");
        return this;
    }

    @Override
    public Email setMsg(String msg) throws EmailException {
        this.setTextMsg(msg);
        StringBuilder htmlMsgBuf = new StringBuilder(msg.length() + HTML_MESSAGE_START.length() + HTML_MESSAGE_END.length());
        htmlMsgBuf.append(HTML_MESSAGE_START).append(msg).append(HTML_MESSAGE_END);
        this.setHtmlMsg(htmlMsgBuf.toString());
        return this;
    }

    public HtmlEmail setTextMsg(String text) throws EmailException {
        this.text = EmailException.checkNonEmpty(text, () -> "Invalid message.");
        return this;
    }

    private static final class InlineImage {
        private final String cid;
        private final DataSource dataSource;
        private final MimeBodyPart mimeBodyPart;

        private InlineImage(String cid, DataSource dataSource, MimeBodyPart mimeBodyPart) {
            this.cid = Objects.requireNonNull(cid, "cid");
            this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
            this.mimeBodyPart = Objects.requireNonNull(mimeBodyPart, "mimeBodyPart");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InlineImage)) {
                return false;
            }
            InlineImage other = (InlineImage)obj;
            return Objects.equals(this.cid, other.cid);
        }

        private String getCid() {
            return this.cid;
        }

        private DataSource getDataSource() {
            return this.dataSource;
        }

        private MimeBodyPart getMimeBodyPart() {
            return this.mimeBodyPart;
        }

        public int hashCode() {
            return Objects.hash(this.cid);
        }
    }
}

