/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.lp2;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRulePattern;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.learner.lp2.BasicLP2;
import org.apache.uima.ruta.textruler.learner.lp2.LP2Rule;
import org.apache.uima.ruta.textruler.learner.lp2.LP2RuleItem;

public class NaiveLP2
extends BasicLP2 {
    public static final boolean SAVE_DEBUG_INFO_IN_TEMPFOLDER = false;

    public NaiveLP2(String inputDir, String prePropTMFile, String tmpDir, String[] slotNames, Set<String> filterSet, boolean skip, TextRulerLearnerDelegate delegate) {
        super(inputDir, prePropTMFile, tmpDir, slotNames, filterSet, skip, delegate);
    }

    @Override
    protected void induceRulesFromExample(TextRulerExample e, int roundNumber) {
        LP2Rule baseRule = this.createInitialRuleForPositiveExample(e);
        List<LP2Rule> genRules = this.generalizeRule(baseRule);
        if (this.shouldAbort()) {
            return;
        }
        ArrayList test = new ArrayList();
        this.sendStatusUpdateToDelegate("Round " + roundNumber + " - Testing " + genRules.size() + "generalizations... - uncovered examples: " + (this.examples.size() - this.coveredExamples.size()) + " / " + this.examples.size(), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        this.testRulesOnDocumentSet(new ArrayList<LP2Rule>(genRules), this.exampleDocuments);
        for (LP2Rule newRule : genRules) {
            this.checkAndHandleNewRule(newRule);
        }
    }

    protected void checkAndHandleNewRule(LP2Rule rule) {
        boolean isBestRule;
        boolean tooFewPositives = rule.getCoveringStatistics().getCoveredPositivesCount() < this.minCoveredPositives;
        boolean tooManyErrors = rule.getErrorRate() > this.maxErrorThreshold;
        boolean bl = isBestRule = !tooFewPositives && !tooManyErrors;
        if (isBestRule) {
            this.currentBestRules.add(rule);
            this.currentBestRules.removeSubsumedRules();
            this.currentBestRules.cutToMaxSize();
        } else if (!tooFewPositives) {
            boolean isGoodContextRule;
            rule = rule.copy();
            LP2RuleItem item = rule.getMarkingRuleItem();
            item.setContextConstraint(new LP2RuleItem.MLLP2ContextConstraint((Integer)this.slotMaximumTokenCountMap.get(rule.getTarget().getSingleSlotRawTypeName()), rule));
            rule.setIsContextualRule(true);
            rule.setNeedsCompile(true);
            this.testRuleOnDocumentSet(rule, this.exampleDocuments);
            boolean ctxTooFewPositives = rule.getCoveringStatistics().getCoveredPositivesCount() < this.minCoveredPositives;
            boolean ctxTooManyErrors = rule.getErrorRate() > this.maxErrorThreshold;
            boolean bl2 = isGoodContextRule = !ctxTooFewPositives && !ctxTooManyErrors;
            if (isGoodContextRule) {
                this.currentContextualRules.add(rule);
                this.currentContextualRules.removeSubsumedRules();
                this.currentContextualRules.cutToMaxSize();
            }
        }
    }

    protected List<LP2Rule> generalizeRule(LP2Rule baseRule) {
        ArrayList<LP2Rule> result = new ArrayList<LP2Rule>();
        TextRulerRulePattern rulePattern = new TextRulerRulePattern();
        TextRulerRulePattern prePattern = baseRule.getPreFillerPattern();
        for (int i = prePattern.size() - 1; i >= 0; --i) {
            rulePattern.add((TextRulerRuleItem)prePattern.get(i));
        }
        rulePattern.addAll(baseRule.getPostFillerPattern());
        this.recursiveGeneralizeRule(baseRule, rulePattern, new TextRulerRulePattern(), result);
        TextRulerToolkit.log("GENERALIZATIONS: " + result.size());
        for (LP2Rule r : result) {
            this.removeOutermostWildCardItemsFromRule(r);
        }
        return result;
    }

    protected LP2Rule createInitialRuleForPositiveExample(TextRulerExample example) {
        TextRulerTarget target = example.getTarget();
        LP2Rule rule = new LP2Rule(this, example.getTarget());
        CAS docCas = example.getDocumentCAS();
        TextRulerAnnotation exampleAnnotation = example.getAnnotation();
        TypeSystem ts = docCas.getTypeSystem();
        Type tokensRootType = ts.getType("org.apache.uima.ruta.type.ANY");
        int thePosition = target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY ? exampleAnnotation.getBegin() : exampleAnnotation.getEnd();
        List<AnnotationFS> leftContext = TextRulerToolkit.getAnnotationsBeforePosition(docCas, thePosition, this.windowSize, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
        List<AnnotationFS> rightContext = TextRulerToolkit.getAnnotationsAfterPosition(docCas, thePosition, this.windowSize, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
        for (int i = leftContext.size() - 1; i >= 0; --i) {
            TextRulerAnnotation annot = new TextRulerAnnotation(leftContext.get(i), example.getDocument());
            LP2RuleItem item = new LP2RuleItem();
            item.setWordConstraint(annot);
            if (item.getWordConstraint().isRegExpConstraint()) {
                item.addOtherConstraint(new LP2RuleItem.MLLP2OtherConstraint(annot, annot));
            }
            rule.addPreFillerItem(item);
        }
        for (AnnotationFS afs : rightContext) {
            TextRulerAnnotation annot = new TextRulerAnnotation(afs, example.getDocument());
            LP2RuleItem item = new LP2RuleItem();
            item.setWordConstraint(annot);
            if (item.getWordConstraint().isRegExpConstraint()) {
                item.addOtherConstraint(new LP2RuleItem.MLLP2OtherConstraint(annot, annot));
            }
            rule.addPostFillerItem(item);
        }
        TextRulerToolkit.log("INITIAL RULE: " + rule.getRuleString());
        return rule;
    }

    protected void recursiveGeneralizeRule(LP2Rule baseRule, TextRulerRulePattern allItems, TextRulerRulePattern currentPattern, List<LP2Rule> resultList) {
        if (currentPattern.size() == allItems.size()) {
            LP2Rule newRule = new LP2Rule(this, baseRule.getTarget());
            int preCount = baseRule.getPreFillerPattern().size();
            for (int i = 0; i < currentPattern.size(); ++i) {
                if (i < preCount) {
                    newRule.addPreFillerItem((TextRulerRuleItem)currentPattern.get(i));
                    continue;
                }
                newRule.addPostFillerItem((TextRulerRuleItem)currentPattern.get(i));
            }
            if (newRule.totalInnerConstraintCount() > 0) {
                resultList.add(newRule);
            }
        } else {
            int index = currentPattern.size();
            TextRulerRuleItem baseItem = (TextRulerRuleItem)allItems.get(index);
            List<TextRulerRuleItem> itemGeneralizations = this.generalizeRuleItem((LP2RuleItem)baseItem);
            for (TextRulerRuleItem newItem : itemGeneralizations) {
                currentPattern.add(newItem);
                this.recursiveGeneralizeRule(baseRule, allItems, currentPattern, resultList);
                currentPattern.remove(currentPattern.size() - 1);
            }
        }
    }

    protected void recursiveGeneralizeRuleItem(LP2RuleItem baseItem, List<LP2RuleItem.MLLP2OtherConstraint> otherConstraints, int currentConstraintIndex, List<LP2RuleItem.MLLP2OtherConstraint> currentConstraintTuple, List<TextRulerRuleItem> result) {
        if (currentConstraintIndex > otherConstraints.size() - 1) {
            LP2RuleItem newItem = new LP2RuleItem();
            for (LP2RuleItem.MLLP2OtherConstraint c : currentConstraintTuple) {
                newItem.addOtherConstraint(c.copy());
            }
            result.add(newItem);
        } else {
            LP2RuleItem.MLLP2OtherConstraint currentConstraint = otherConstraints.get(currentConstraintIndex);
            this.recursiveGeneralizeRuleItem(baseItem, otherConstraints, currentConstraintIndex + 1, currentConstraintTuple, result);
            currentConstraintTuple.add(currentConstraint);
            this.recursiveGeneralizeRuleItem(baseItem, otherConstraints, currentConstraintIndex + 1, currentConstraintTuple, result);
            currentConstraintTuple.remove(currentConstraintTuple.size() - 1);
        }
    }

    protected List<TextRulerRuleItem> generalizeRuleItem(LP2RuleItem baseItem) {
        ArrayList<TextRulerRuleItem> result = new ArrayList<TextRulerRuleItem>();
        if (baseItem.getWordConstraint() != null) {
            LP2RuleItem newItem = new LP2RuleItem();
            newItem.setWordConstraint(baseItem.getWordConstraint().copy());
            result.add(newItem);
        }
        List<LP2RuleItem.MLLP2OtherConstraint> constraints = baseItem.getOtherConstraints();
        this.recursiveGeneralizeRuleItem(baseItem, constraints, 0, new ArrayList<LP2RuleItem.MLLP2OtherConstraint>(), result);
        return result;
    }

    protected void removeOutermostWildCardItemsFromRule(LP2Rule rule) {
        LP2RuleItem item;
        while ((item = (LP2RuleItem)rule.getOutermostPreFillerItem()) != null && (rule.getTarget().type != TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY || rule.getPreFillerPattern().size() != 1) && item.totalConstraintCount() == 0) {
            rule.removeOutermostPreFillerItem();
        }
        while ((item = (LP2RuleItem)rule.getOutermostPostFillerItem()) != null && (rule.getTarget().type != TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY || rule.getPostFillerPattern().size() != 1) && item.totalConstraintCount() == 0) {
            rule.removeOutermostPostFillerItem();
        }
    }

    @Override
    public boolean collectNegativeCoveredInstancesWhenTesting() {
        return false;
    }
}

