/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class RutaWordRule
implements IPredicateRule {
    protected static final int UNDEFINED = -1;
    protected IWordDetector fDetector;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    protected Map fWords = new HashMap();
    private StringBuffer fBuffer = new StringBuffer();
    private String lastFound = "";

    public RutaWordRule(IWordDetector detector, IToken defaultToken, IToken classNameToken) {
        Assert.isNotNull((Object)detector);
        Assert.isNotNull((Object)defaultToken);
        this.fDetector = detector;
        this.fDefaultToken = defaultToken;
    }

    public void addWord(String word, IToken token) {
        Assert.isNotNull((Object)word);
        Assert.isNotNull((Object)token);
        this.fWords.put(word, token);
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        IToken token;
        String str;
        int c = scanner.read();
        this.fBuffer.setLength(0);
        if (c == 45) {
            this.fBuffer.append((char)c);
            c = scanner.read();
            if (c == 62) {
                this.fBuffer.append((char)c);
                str = this.fBuffer.toString();
                token = (IToken)this.fWords.get(str);
                if (token != null) {
                    this.lastFound = str;
                    return token;
                }
            } else {
                this.fBuffer.setLength(0);
            }
        }
        if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            str = this.fBuffer.toString();
            token = (IToken)this.fWords.get(str);
            if (token != null) {
                this.lastFound = str;
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        for (int i = this.fBuffer.length() - 1; i >= 0; --i) {
            scanner.unread();
        }
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken getSuccessToken() {
        return this.fDefaultToken;
    }
}

