/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.documentation;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.ui.editor.RutaEditor;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DescriptorDocumentationProvider
implements IScriptDocumentationProvider {
    public Reader getInfo(final String content) {
        final StringBuilder sb = new StringBuilder();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                RutaEditor re;
                IEditorInput ei;
                IWorkbenchPage page;
                IEditorPart activeEditor;
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win != null && (activeEditor = (page = win.getActivePage()).getActiveEditor()) != null && (ei = (re = (RutaEditor)activeEditor).getEditorInput()) instanceof FileEditorInput) {
                    FileEditorInput fei = (FileEditorInput)ei;
                    IProject project = fei.getFile().getProject();
                    try {
                        Collection classPath = RutaProjectUtils.getClassPath((IProject)project);
                        URL[] urls = new URL[classPath.size()];
                        int counter = 0;
                        for (String dep : classPath) {
                            urls[counter] = new File(dep).toURI().toURL();
                            ++counter;
                        }
                        URLClassLoader classloader = new URLClassLoader(urls);
                        Resource[] filesInClasspath = DescriptorDocumentationProvider.this.getFilesInClasspath(content, classloader);
                        if (filesInClasspath.length > 0) {
                            Resource r = filesInClasspath[0];
                            URL url = r.getURL();
                            XMLizable desc = UIMAFramework.getXMLParser().parse(new XMLInputSource(url));
                            if (desc instanceof AnalysisEngineDescription) {
                                ConfigurationParameter[] parameters;
                                AnalysisEngineDescription aed = (AnalysisEngineDescription)desc;
                                ConfigurationParameterDeclarations cpd = aed.getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
                                for (ConfigurationParameter each : parameters = cpd.getConfigurationParameters()) {
                                    sb.append("<b>");
                                    sb.append(each.getName());
                                    sb.append("</b>");
                                    sb.append("<li><b>type:</b> " + each.getType() + "</li>");
                                    sb.append("<li><b>mandatory:</b> " + each.isMandatory() + "</li>");
                                    sb.append("<li><b>multiValued:</b> " + each.isMultiValued() + "</li>");
                                    if (each.getDescription() != null && !each.getDescription().trim().isEmpty()) {
                                        sb.append("<p>");
                                        sb.append(each.getDescription());
                                        sb.append("</p>");
                                    }
                                    sb.append("<br/>");
                                }
                            } else if (desc instanceof TypeSystemDescription) {
                                TypeDescription[] types;
                                TypeSystemDescription tsd = (TypeSystemDescription)desc;
                                tsd.resolveImports();
                                for (TypeDescription each : types = tsd.getTypes()) {
                                    sb.append("<b>");
                                    sb.append(each.getName());
                                    sb.append("</b>");
                                    sb.append(" (" + each.getSupertypeName() + ")");
                                    if (each.getDescription() != null && !each.getDescription().trim().isEmpty()) {
                                        sb.append("<p>");
                                        sb.append(each.getDescription());
                                        sb.append("</p>");
                                    }
                                    for (FeatureDescription eachFeat : each.getFeatures()) {
                                        sb.append("<li><b>" + eachFeat.getName() + "</b> (" + eachFeat.getRangeTypeName() + ") </li>");
                                        if (eachFeat.getDescription() == null || eachFeat.getDescription().trim().isEmpty()) continue;
                                        sb.append("<p>");
                                        sb.append(eachFeat.getDescription());
                                        sb.append("</p>");
                                    }
                                    sb.append("<br/>");
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        RutaIdeUIPlugin.error(e);
                    }
                }
            }
        });
        return new StringReader(sb.toString());
    }

    private Resource[] getFilesInClasspath(String name, URLClassLoader classloader) throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ClassLoader)classloader);
        String p = "classpath*:";
        String suffix = "/**/" + name + ".xml";
        String pattern = p + suffix;
        Resource[] resources = resolver.getResources(pattern);
        return resources;
    }

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        return null;
    }
}

