/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.util.ArrayList;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;
import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRuleItem;

public class CorrectionRule
extends TrabalRule {
    public CorrectionRule(TrabalLearner parentAlgorithm, TextRulerTarget target, TrabalAnnotation annotation, TrabalAnnotation targetAnnotation) {
        super(parentAlgorithm, target);
        this.annotation = annotation;
        this.targetAnnotation = targetAnnotation;
        this.errorType = AnnotationErrorType.CORRECTION;
        this.addConditionTypes();
    }

    public CorrectionRule(CorrectionRule copyFrom) {
        super((TrabalLearner)copyFrom.algorithm, copyFrom.target);
        this.annotation = copyFrom.annotation;
        this.targetAnnotation = copyFrom.targetAnnotation;
        this.errorType = AnnotationErrorType.CORRECTION;
        this.conditions = new ArrayList();
        for (Condition c : copyFrom.conditions) {
            this.conditions.add(c.clone());
        }
        this.addConditionTypes();
    }

    private void addConditionTypes() {
        this.conditionTypes = new ArrayList();
        this.conditionTypes.add(ConditionType.BEFORE);
        this.conditionTypes.add(ConditionType.AFTER);
        this.conditionTypes.add(ConditionType.STARTSWITH);
        this.conditionTypes.add(ConditionType.ENDSWITH);
        this.conditionTypes.add(ConditionType.CONTAINS);
        this.conditionTypes.add(ConditionType.PARTOF);
    }

    @Override
    public void compileRuleString() {
        String conditions = this.parseConditions(this.conditionTypes);
        if (conditions.length() > 0) {
            conditions = conditions + " ";
        }
        this.ruleString = ((TrabalLearner)this.algorithm).getEnableFeatures() ? this.annotation.getType().getShortName() + "{" + conditions + "-> UNMARK(" + this.annotation.getType().getShortName() + ", true), CREATE(" + this.targetAnnotation.getType().getShortName() + this.parseFeatures() + ")};" : this.annotation.getType().getShortName() + "{" + conditions + "-> UNMARK(" + this.annotation.getType().getShortName() + ", true), MARK(" + this.targetAnnotation.getType().getShortName() + ")};";
        this.setNeedsCompile(false);
    }

    @Override
    public boolean contains(TrabalAnnotation target) {
        if (target == null) {
            return false;
        }
        if (this.annotation.getType().getShortName().equals(target.getType().getShortName())) {
            return true;
        }
        if (this.targetAnnotation.getType().getShortName().equals(target.getType().getShortName())) {
            return true;
        }
        for (Condition each : this.getConditions()) {
            if (!each.getItem().getName().equals(target.getType().getShortName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSameBasicRule(TrabalRule rule) {
        if (rule.getAnnotation() == null) {
            return false;
        }
        if (!rule.getAnnotation().getType().equals(this.annotation.getType())) {
            return false;
        }
        if (rule.getTargetAnnotation() == null) {
            return false;
        }
        return rule.getTargetAnnotation().getType().equals(this.targetAnnotation.getType());
    }

    @Override
    public TrabalRuleItem getFrontBoundary() {
        return new TrabalRuleItem(this.annotation);
    }

    @Override
    public TrabalRuleItem getRearBoundary() {
        return new TrabalRuleItem(this.annotation);
    }

    @Override
    public TrabalRule copy() {
        return new CorrectionRule(this);
    }
}

