/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.editor.CasDocumentProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;

class CasDocumentProviderFactory {
    private static final String CAS_EDITOR_EXTENSION = "org.apache.uima.caseditor.editor";
    private static CasDocumentProviderFactory instance;
    private Map<String, CasDocumentProvider> documentProviders = new HashMap<String, CasDocumentProvider>();

    CasDocumentProviderFactory() {
        IConfigurationElement[] config;
        for (IConfigurationElement element : config = Platform.getExtensionRegistry().getConfigurationElementsFor(CAS_EDITOR_EXTENSION)) {
            Object documentProviderObject;
            if (!"provider".equals(element.getName())) continue;
            String id = element.getAttribute("id");
            String inputType = element.getAttribute("inputType");
            try {
                documentProviderObject = element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                CasEditorPlugin.log("Failed to load doucment provider with id: " + id, e);
                documentProviderObject = null;
            }
            if (!(documentProviderObject instanceof CasDocumentProvider)) continue;
            this.documentProviders.put(inputType, (CasDocumentProvider)documentProviderObject);
        }
    }

    CasDocumentProvider getDocumentProvider(IEditorInput input) {
        ArrayList classList = new ArrayList();
        for (Class<?> inputClass = input.getClass(); inputClass != null; inputClass = inputClass.getSuperclass()) {
            classList.add(inputClass);
        }
        CasDocumentProvider provider = null;
        for (Class clazz : classList) {
            provider = this.documentProviders.get(clazz.getName());
            if (provider == null) continue;
            return provider;
        }
        if (provider == null) {
            for (Class clazz : classList) {
                for (Class<?> inputClassInterface : clazz.getInterfaces()) {
                    provider = this.documentProviders.get(inputClassInterface.getName());
                    if (provider == null) continue;
                    return provider;
                }
            }
        }
        return provider;
    }

    static CasDocumentProviderFactory instance() {
        if (instance == null) {
            instance = new CasDocumentProviderFactory();
        }
        return instance;
    }
}

