/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractMarkAction;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.resource.WordTableExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.resource.RutaTable;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MarkTableAction
extends AbstractMarkAction {
    private final ITypeExpression typeExpr;
    private final WordTableExpression tableExpr;
    private final Map<IStringExpression, INumberExpression> featureMap;
    private final INumberExpression indexExpr;
    private final IBooleanExpression ignoreCase;
    private final INumberExpression ignoreLength;
    private final IStringExpression ignoreChar;
    private final INumberExpression maxIgnoreChar;
    private IBooleanExpression ignoreWS;

    public MarkTableAction(ITypeExpression typeExpr, INumberExpression indexExpr, WordTableExpression tableExpr, Map<IStringExpression, INumberExpression> featureMap, IBooleanExpression ignoreCase, INumberExpression ignoreLength, IStringExpression ignoreChar, INumberExpression maxIgnoreChar) {
        super(typeExpr);
        this.typeExpr = typeExpr;
        this.indexExpr = indexExpr;
        this.tableExpr = tableExpr;
        this.featureMap = featureMap;
        this.ignoreCase = ignoreCase;
        this.ignoreLength = ignoreLength;
        this.ignoreChar = ignoreChar;
        this.maxIgnoreChar = maxIgnoreChar;
    }

    public void setIgnoreWS(IBooleanExpression ignoreWS) {
        this.ignoreWS = ignoreWS;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        element.getParent();
        RutaTable table = this.tableExpr.getTable(context, stream);
        if (table == null) {
            return;
        }
        int index = this.indexExpr.getIntegerValue(context, stream);
        Type type = this.typeExpr.getType(context, stream);
        if (type == null) {
            return;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (IStringExpression each : this.featureMap.keySet()) {
            map.put(each.getStringValue(context, stream), this.featureMap.get(each).getIntegerValue(context, stream));
        }
        boolean ignoreCaseValue = this.ignoreCase != null ? this.ignoreCase.getBooleanValue(context, stream) : false;
        int ignoreLengthValue = this.ignoreLength != null ? this.ignoreLength.getIntegerValue(context, stream) : 0;
        String ignoreCharValue = this.ignoreChar != null ? this.ignoreChar.getStringValue(context, stream) : "";
        int maxIgnoreCharValue = this.maxIgnoreChar != null ? this.maxIgnoreChar.getIntegerValue(context, stream) : 0;
        boolean ignoreWSValue = this.ignoreWS != null ? this.ignoreWS.getBooleanValue(context, stream) : this.getDictWSParamValue(context);
        RutaWordList wordList = table.getWordList(index, element.getParent());
        Collection<AnnotationFS> found = wordList.find(stream, ignoreCaseValue, ignoreLengthValue, ignoreCharValue.toCharArray(), maxIgnoreCharValue, ignoreWSValue);
        for (AnnotationFS annotationFS : found) {
            FeatureStructure newFS;
            List<String> rowWhere;
            String candidate = stream.getVisibleCoveredText(annotationFS);
            if (!StringUtils.isBlank((CharSequence)ignoreCharValue)) {
                for (int i = 0; i < maxIgnoreCharValue; ++i) {
                    candidate = candidate.replaceFirst("[" + ignoreCharValue + "]", "");
                }
            }
            if ((rowWhere = table.getRowWhere(index - 1, candidate, false)).isEmpty() && ignoreCaseValue && candidate.length() > ignoreLengthValue) {
                rowWhere = table.getRowWhere(index - 1, candidate, true);
            }
            if ((newFS = stream.getCas().createFS(type)) instanceof Annotation) {
                Annotation a = (Annotation)newFS;
                a.setBegin(annotationFS.getBegin());
                a.setEnd(annotationFS.getEnd());
                stream.addAnnotation((AnnotationFS)a, match);
            }
            TOP newStructure = null;
            if (!(newFS instanceof TOP)) continue;
            newStructure = (TOP)newFS;
            this.fillFeatures(newStructure, map, annotationFS, element, rowWhere, stream);
            newStructure.addToIndexes();
        }
    }

    private void fillFeatures(TOP structure, Map<String, Integer> map, AnnotationFS annotationFS, RuleElement element, List<String> row, RutaStream stream) {
        List featuresList = structure.getType().getFeatures();
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        for (int i = 0; i < featuresList.size(); ++i) {
            Number d;
            Feature targetFeature = (Feature)featuresList.get(i);
            String name = targetFeature.getName();
            String shortFName = name.substring(name.indexOf(":") + 1, name.length());
            Integer entryIndex = map.get(shortFName);
            Type range = targetFeature.getRange();
            if (entryIndex == null || row.size() < entryIndex) continue;
            String value = row.get(entryIndex - 1);
            if (typeSystem.subsumes(typeSystem.getType("uima.cas.String"), range)) {
                structure.setStringValue(targetFeature, value);
                continue;
            }
            if (range.getName().equals("uima.cas.Integer")) {
                Integer integer = Integer.parseInt(value);
                structure.setIntValue(targetFeature, integer.intValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Double")) {
                d = Double.parseDouble(value);
                structure.setDoubleValue(targetFeature, ((Double)d).doubleValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Float")) {
                d = Float.valueOf(Float.parseFloat(value));
                structure.setFloatValue(targetFeature, ((Float)d).floatValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Byte")) {
                d = Byte.parseByte(value);
                structure.setByteValue(targetFeature, ((Byte)d).byteValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Short")) {
                d = Short.parseShort(value);
                structure.setShortValue(targetFeature, ((Short)d).shortValue());
                continue;
            }
            if (range.getName().equals("uima.cas.Long")) {
                d = Long.parseLong(value);
                structure.setLongValue(targetFeature, ((Long)d).longValue());
                continue;
            }
            if (!range.getName().equals("uima.cas.Boolean")) continue;
            Boolean b = Boolean.parseBoolean(value);
            structure.setBooleanValue(targetFeature, b.booleanValue());
        }
    }

    public ITypeExpression getTypeExpr() {
        return this.typeExpr;
    }

    public WordTableExpression getTableExpr() {
        return this.tableExpr;
    }

    public Map<IStringExpression, INumberExpression> getFeatureMap() {
        return this.featureMap;
    }

    public INumberExpression getIndexExpr() {
        return this.indexExpr;
    }

    public IBooleanExpression getIgnoreCase() {
        return this.ignoreCase;
    }

    public INumberExpression getIgnoreLength() {
        return this.ignoreLength;
    }

    public IStringExpression getIgnoreChar() {
        return this.ignoreChar;
    }

    public INumberExpression getMaxIgnoreChar() {
        return this.maxIgnoreChar;
    }
}

