/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class Literal
extends Expression {
    private Value value;

    public Literal(Value value) {
        this.value = value;
    }

    public static Literal makeLiteral(Value value) {
        if (value instanceof StringValue) {
            return new StringLiteral((StringValue)value);
        }
        return new Literal(value);
    }

    public Value getValue() {
        return this.value;
    }

    public final Expression simplify(StaticContext staticContext) {
        try {
            this.value = this.value.reduce();
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    public final Expression typeCheck(StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public final Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.value.getItemType(typeHierarchy);
    }

    public int computeCardinality() {
        if (this.value instanceof EmptySequence) {
            return 8192;
        }
        if (this.value instanceof AtomicValue) {
            return 16384;
        }
        try {
            SequenceIterator sequenceIterator = this.value.iterate();
            Item item = sequenceIterator.next();
            if (item == null) {
                return 8192;
            }
            if (sequenceIterator.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException xPathException) {
            return 57344;
        }
    }

    public int computeSpecialProperties() {
        return 0x400000;
    }

    public final int getDependencies() {
        return 0;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return this.value.iterate();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.value instanceof AtomicValue) {
            return (AtomicValue)this.value;
        }
        return this.value.iterate().next();
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.value.iterate();
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        while ((item = sequenceIterator.next()) != null) {
            sequenceReceiver.append(item, 0, 2);
        }
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return "";
        }
        return atomicValue.getStringValue();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.value.effectiveBooleanValue();
    }

    public boolean equals(Object object) {
        return object instanceof Literal && this.value.equals(((Literal)object).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (this.value instanceof EmptySequence) {
            printStream.println(ExpressionTool.indent(n) + "()");
        } else if (this.value instanceof AtomicValue) {
            printStream.println(ExpressionTool.indent(n) + this.value.toString());
        } else {
            try {
                Item item;
                printStream.println(ExpressionTool.indent(n) + "sequence of " + this.getItemType(typeHierarchy).toString() + " (");
                SequenceIterator sequenceIterator = this.iterate(null);
                while ((item = sequenceIterator.next()) != null) {
                    if (item instanceof NodeInfo) {
                        printStream.println(ExpressionTool.indent(n + 1) + "node " + Navigator.getPath((NodeInfo)item));
                        continue;
                    }
                    printStream.println(ExpressionTool.indent(n + 1) + item.toString());
                }
                printStream.println(ExpressionTool.indent(n) + ')');
            }
            catch (XPathException xPathException) {
                printStream.println(ExpressionTool.indent(n) + "(*error*)");
            }
        }
    }

    public static boolean isAtomic(Expression expression) {
        return expression instanceof Literal && ((Literal)expression).getValue() instanceof AtomicValue;
    }

    public static boolean isEmptySequence(Expression expression) {
        return expression instanceof Literal && ((Literal)expression).getValue() instanceof EmptySequence;
    }

    public static boolean isConstantBoolean(Expression expression, boolean bl) {
        if (expression instanceof Literal) {
            Value value = ((Literal)expression).getValue();
            return value instanceof BooleanValue && ((BooleanValue)value).getBooleanValue() == bl;
        }
        return false;
    }

    public static boolean isConstantOne(Expression expression) {
        if (expression instanceof Literal) {
            Value value = ((Literal)expression).getValue();
            return value instanceof Int64Value && ((Int64Value)value).longValue() == 1L;
        }
        return false;
    }
}

