/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class NumericPromoter
extends UnaryExpression {
    private BuiltInAtomicType requiredType;

    public NumericPromoter(Expression expression, BuiltInAtomicType builtInAtomicType) {
        super(expression);
        this.requiredType = builtInAtomicType;
        ExpressionTool.copyLocationInfo(expression, this);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof Literal) {
            if (((Literal)this.operand).getValue() instanceof AtomicValue) {
                return Literal.makeLiteral(this.promote((AtomicValue)((Literal)this.operand).getValue(), null));
            }
            return Literal.makeLiteral(((Value)SequenceExtent.makeSequenceExtent(this.iterate(staticContext.makeEarlyEvaluationContext()))).reduce());
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        return this;
    }

    public SequenceIterator iterate(final XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

            public Item map(Item item) throws XPathException {
                return NumericPromoter.this.promote((AtomicValue)item, xPathContext);
            }
        };
        return new ItemMappingIterator(sequenceIterator, itemMappingFunction);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        return this.promote((AtomicValue)item, xPathContext);
    }

    private AtomicValue promote(AtomicValue atomicValue, XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue2 = atomicValue;
        if (!(atomicValue2 instanceof NumericValue) && !(atomicValue2 instanceof UntypedAtomicValue)) {
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            DynamicError dynamicError = new DynamicError("Cannot promote non-numeric value to " + this.getItemType(typeHierarchy).toString(), "XPTY0004", xPathContext);
            dynamicError.setLocator(this);
            throw dynamicError;
        }
        return atomicValue2.convert(this.requiredType, xPathContext);
    }

    public int getRequiredType() {
        return this.requiredType.getFingerprint();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.requiredType.equals(BuiltInAtomicType.DOUBLE)) {
            return BuiltInAtomicType.DOUBLE;
        }
        return BuiltInAtomicType.FLOAT;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredType == ((NumericPromoter)object).requiredType;
    }

    protected String displayOperator(Configuration configuration) {
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        return "promote items to " + this.getItemType(typeHierarchy).toString(configuration.getNamePool());
    }
}

