/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ReverseArrayIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public final class SequenceExtent
extends Value {
    private Item[] value;
    private int start = 0;
    private int end;
    private ItemType itemType = null;

    public SequenceExtent(Item[] itemArray) {
        this.value = itemArray;
        this.end = itemArray.length;
    }

    public SequenceExtent(Item[] itemArray, int n, int n2) {
        this.value = itemArray;
        this.start = n;
        this.end = this.start + n2;
    }

    public SequenceExtent(SequenceExtent sequenceExtent, int n, int n2) {
        this.value = sequenceExtent.value;
        this.start = sequenceExtent.start + n;
        this.end = this.start + n2;
    }

    public SequenceExtent(List list) {
        Item[] itemArray = new Item[list.size()];
        this.value = list.toArray(itemArray);
        this.end = this.value.length;
    }

    public SequenceExtent(SequenceIterator sequenceIterator) throws XPathException {
        if ((sequenceIterator.getProperties() & 2) == 0) {
            Item[] itemArray;
            ArrayList<Item[]> arrayList = new ArrayList<Item[]>(20);
            while ((itemArray = sequenceIterator.next()) != null) {
                arrayList.add(itemArray);
            }
            itemArray = new Item[arrayList.size()];
            this.value = arrayList.toArray(itemArray);
            this.end = this.value.length;
        } else {
            Item item;
            this.end = ((LastPositionFinder)sequenceIterator).getLastPosition();
            this.value = new Item[this.end];
            int n = 0;
            while ((item = sequenceIterator.next()) != null) {
                this.value[n++] = item;
            }
        }
    }

    public static ValueRepresentation makeSequenceExtent(SequenceIterator sequenceIterator) throws XPathException {
        if ((sequenceIterator.getProperties() & 1) != 0) {
            return ((GroundedIterator)sequenceIterator).materialize();
        }
        SequenceExtent sequenceExtent = new SequenceExtent(sequenceIterator);
        int n = ((Value)sequenceExtent).getLength();
        if (n == 0) {
            return EmptySequence.getInstance();
        }
        if (n == 1) {
            return ((Value)sequenceExtent).itemAt(0);
        }
        return sequenceExtent;
    }

    public boolean isMultiValued() {
        return this.getLength() > 1;
    }

    public Value simplify() {
        int n = this.getLength();
        if (n == 0) {
            return EmptySequence.getInstance();
        }
        if (n == 1) {
            return Value.asValue(this.itemAt(0));
        }
        return this;
    }

    public Value reduce() {
        return this.simplify();
    }

    public int getLength() {
        return this.end - this.start;
    }

    public int getCardinality() {
        switch (this.end - this.start) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.itemType != null) {
            return this.itemType;
        }
        if (this.end == this.start) {
            this.itemType = AnyItemType.getInstance();
        } else {
            this.itemType = Type.getItemType(this.value[this.start], typeHierarchy);
            for (int i = this.start + 1; i < this.end; ++i) {
                if (this.itemType == AnyItemType.getInstance()) {
                    return this.itemType;
                }
                this.itemType = Type.getCommonSuperType(this.itemType, Type.getItemType(this.value[i], typeHierarchy), typeHierarchy);
            }
        }
        return this.itemType;
    }

    public Item itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return this.value[this.start + n];
    }

    public void swap(int n, int n2) {
        Item item = this.value[this.start + n];
        this.value[this.start + n] = this.value[this.start + n2];
        this.value[this.start + n2] = item;
    }

    public SequenceIterator iterate() {
        return new ArrayIterator(this.value, this.start, this.end);
    }

    public UnfailingIterator reverseIterate() {
        return new ReverseArrayIterator(this.value, this.start, this.end);
    }

    public boolean effectiveBooleanValue() throws XPathException {
        int n = this.getLength();
        if (n == 0) {
            return false;
        }
        if (this.value[0] instanceof NodeInfo) {
            return true;
        }
        if (n > 1) {
            return ExpressionTool.effectiveBooleanValue(this.iterate());
        }
        return ((AtomicValue)this.value[0]).effectiveBooleanValue();
    }
}

