/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.AbstractCas_ImplBase;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CasOwner;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.ComponentInfo;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FeatureValuePath;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.SofaID;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.cas.admin.CASFactory;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.FSIndexRepositoryMgr;
import org.apache.uima.cas.admin.TypeSystemMgr;
import org.apache.uima.cas.impl.AllFSs;
import org.apache.uima.cas.impl.BinaryCasSerDes;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.CasState;
import org.apache.uima.cas.impl.CasTypeSystemMapper;
import org.apache.uima.cas.impl.CommonSerDesSequential;
import org.apache.uima.cas.impl.DebugFSLogicalStructure;
import org.apache.uima.cas.impl.DebugNameValuePair;
import org.apache.uima.cas.impl.FSClassRegistry;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FSsTobeAddedback;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeaturePathImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FeatureValuePathImpl;
import org.apache.uima.cas.impl.FilteredIterator;
import org.apache.uima.cas.impl.FsGenerator3;
import org.apache.uima.cas.impl.FsIndex_singletype;
import org.apache.uima.cas.impl.Id2FS;
import org.apache.uima.cas.impl.LongSet;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelException;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.StringSet;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeImpl_array;
import org.apache.uima.cas.impl.TypeImpl_string;
import org.apache.uima.cas.impl.TypeSystemConstants;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.cas.text.Language;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.internal.util.UIMAClassLoader;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.AnnotationBase;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.EmptyFloatList;
import org.apache.uima.jcas.cas.EmptyIntegerList;
import org.apache.uima.jcas.cas.EmptyList;
import org.apache.uima.jcas.cas.EmptyStringList;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.impl.JCasHashMap;
import org.apache.uima.jcas.impl.JCasImpl;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.util.AutoCloseableNoException;
import org.apache.uima.util.Level;

public class CASImpl
extends AbstractCas_ImplBase
implements CAS,
CASMgr,
LowLevelCAS,
TypeSystemConstants {
    private static final String DISABLE_SUBTYPE_FSARRAY_CREATION = "uima.disable_subtype_fsarray_creation";
    static final boolean IS_DISABLE_SUBTYPE_FSARRAY_CREATION = Misc.getNoValueSystemProperty("uima.disable_subtype_fsarray_creation");
    private static final String TRACE_FSS = "uima.trace_fs_creation_and_updating";
    private static final boolean trace = false;
    public static final boolean traceFSs = Misc.getNoValueSystemProperty("uima.trace_fs_creation_and_updating");
    public static final boolean traceCow = false;
    private static final String traceFile = "traceFSs.log.txt";
    private static final PrintStream traceOut;
    private static final boolean MEASURE_SETINT = false;
    static final AtomicInteger casIdProvider;
    public static final int NULL = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int DEFAULT_INITIAL_HEAP_SIZE = 500000;
    public static final int DEFAULT_RESET_HEAP_SIZE = 5000000;
    public static final String THROW_EXCEPTION_FS_UPDATES_CORRUPTS = "uima.exception_when_fs_update_corrupts_index";
    public static boolean IS_THROW_EXCEPTION_CORRUPT_INDEX;
    public static final String REPORT_FS_UPDATES_CORRUPTS = "uima.report_fs_update_corrupts_index";
    private static final boolean IS_REPORT_FS_UPDATE_CORRUPTS_INDEX;
    public static final String DISABLE_PROTECT_INDEXES = "uima.disable_auto_protect_indexes";
    private static final boolean IS_DISABLED_PROTECT_INDEXES;
    public static final String ALWAYS_HOLD_ONTO_FSS = "uima.default_v2_id_references";
    static final boolean IS_ALWAYS_HOLD_ONTO_FSS;
    private static final ThreadLocal<Boolean> defaultV2IdRefs;
    final SharedViewData svd;
    FSIndexRepositoryImpl indexRepository;
    private Sofa mySofaRef = null;
    JCasImpl jcas = null;
    private TypeSystemImpl tsi_local;
    FeatureStructureImplC pearBaseFs = null;
    private volatile FSIterator<Annotation> docAnnotIter = null;
    private volatile Annotation deserialized_doc_annot_not_indexed = null;
    private static final AtomicInteger strictTypeSourceCheckMessageCount;
    private FeatureImpl prevFi;
    private static final Map<MeasureSwitchType, MeasureSwitchType> measureSwitches;

    public static ThreadLocal<Boolean> getDefaultV2IdRefs() {
        return defaultV2IdRefs;
    }

    public boolean setCasState(CasState state) {
        return this.setCasState(state, null);
    }

    public boolean setCasState(CasState state, Thread thread) {
        return this.svd.setCasState(state, thread);
    }

    public boolean containsCasState(CasState state) {
        return this.svd.casState.contains((Object)state);
    }

    public boolean clearCasState(CasState state) {
        return this.svd.clearCasState(state);
    }

    boolean is_updatable() {
        try {
            return this.svd.is_updatable.invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    boolean is_readable() {
        try {
            return this.svd.is_readable.invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCasLocked() {
        return !this.svd.flushEnabled;
    }

    public CASImpl(TypeSystemImpl typeSystem, int initialHeapSize) {
        boolean externalTypeSystem = typeSystem != null;
        TypeSystemImpl ts = externalTypeSystem ? typeSystem : (TypeSystemImpl)CASFactory.createTypeSystem();
        this.svd = new SharedViewData(this, initialHeapSize, ts);
        if (externalTypeSystem) {
            this.commitTypeSystem();
        }
        this.svd.sofa2indexMap = new ArrayList();
        this.svd.sofaNbr2ViewMap = new ArrayList();
        this.svd.sofaNameSet = new HashSet();
        this.svd.initialSofaCreated = false;
        this.svd.viewCount = 0;
        this.svd.clearTrackingMarks();
    }

    public CASImpl() {
        this((TypeSystemImpl)null, 500000);
    }

    public CASImpl(CASMgrSerializer ser) {
        this(ser.getTypeSystem(), 500000);
        this.checkInternalCodes(ser);
        this.indexRepository = ser.getIndexRepository(this);
    }

    CASImpl(CASImpl cas, SofaFS aSofa) {
        this.svd = cas.svd;
        this.mySofaRef = (Sofa)aSofa;
        FSIndexRepositoryImpl fSIndexRepositoryImpl = this.indexRepository = this.mySofaRef == null ? cas.getSofaIndexRepository(1) : (FSIndexRepositoryImpl)cas.getSofaIndexRepository(aSofa);
        if (null == this.indexRepository) {
            FSIndexRepositoryImpl baseIndexRepo = (FSIndexRepositoryImpl)cas.getBaseIndexRepository();
            this.indexRepository = new FSIndexRepositoryImpl(this, baseIndexRepo);
            baseIndexRepo.name2indexMap.keySet().stream().forEach(key -> this.indexRepository.createIndex(baseIndexRepo, (String)key));
            this.indexRepository.commit();
            if (this.mySofaRef == null) {
                cas.setSofaIndexRepository(1, this.indexRepository);
            } else {
                cas.setSofaIndexRepository(aSofa, this.indexRepository);
            }
        }
    }

    void refreshView(CAS cas, SofaFS aSofa) {
        this.mySofaRef = aSofa != null ? (Sofa)aSofa : null;
        this.jcas = null;
        FSIndexRepositoryImpl baseIndexRepo = (FSIndexRepositoryImpl)((CASImpl)cas).getBaseIndexRepository();
        this.indexRepository = new FSIndexRepositoryImpl(this, baseIndexRepo);
        baseIndexRepo.name2indexMap.keySet().stream().forEach(key -> this.indexRepository.createIndex(baseIndexRepo, (String)key));
        this.indexRepository.commit();
        if (this.mySofaRef == null) {
            ((CASImpl)cas).setSofaIndexRepository(1, this.indexRepository);
        } else {
            ((CASImpl)cas).setSofaIndexRepository(aSofa, this.indexRepository);
        }
    }

    private void checkInternalCodes(CASMgrSerializer ser) throws CASAdminException {
        if (ser.topTypeCode > 0 && ser.topTypeCode != 1) {
            throw new CASAdminException("DESERIALIZATION_ERROR", new Object[0]);
        }
        if (ser.featureOffsets == null) {
            return;
        }
        TypeSystemImpl tsi = this.getTypeSystemImpl();
        for (int i = 1; i < ser.featureOffsets.length; ++i) {
            int adjOffset;
            FeatureImpl fi = tsi.getFeatureForCode_checked(i);
            int n = adjOffset = fi.isInInt ? 0 : fi.getRangeImpl().nbrOfUsedIntDataSlots;
            if (ser.featureOffsets[i] == fi.getOffset() + adjOffset) continue;
            throw new CASAdminException("DESERIALIZATION_ERROR", new Object[0]);
        }
    }

    public boolean isId2Fs() {
        return this.svd.isId2Fs;
    }

    Id2FS getId2FSs() {
        return this.svd.id2fs;
    }

    void set_id2fs(TOP fs) {
        this.svd.id2fs.put(fs);
    }

    void set_reuseId(int id) {
        this.svd.reuseId = id;
    }

    void setLastUsedFsId(int id) {
        this.svd.fsIdGenerator = id;
    }

    void setLastFsV2Size(int size) {
        this.svd.lastFsV2Size = size;
    }

    void addSofaViewName(String id) {
        this.svd.sofaNameSet.add(id);
    }

    void setViewCount(int n) {
        this.svd.viewCount = n;
    }

    void addbackSingle(TOP fs) {
        if (!this.svd.fsTobeAddedbackSingleInUse) {
            Misc.internalError();
        }
        this.svd.fsTobeAddedbackSingle.addback(fs);
        this.svd.fsTobeAddedbackSingleInUse = false;
    }

    void addbackSingleIfWasRemoved(boolean wasRemoved, TOP fs) {
        if (wasRemoved) {
            this.addbackSingle(fs);
        }
        this.svd.fsTobeAddedbackSingleInUse = false;
    }

    private FSsTobeAddedback getAddback(int size) {
        if (this.svd.fsTobeAddedbackSingleInUse) {
            Misc.internalError();
        }
        return (FSsTobeAddedback)this.svd.fssTobeAddedback.get(size - 1);
    }

    FSsTobeAddedback.FSsTobeAddedbackSingle getAddbackSingle() {
        if (this.svd.fsTobeAddedbackSingleInUse) {
            Misc.internalError();
        }
        this.svd.fsTobeAddedbackSingleInUse = true;
        this.svd.fsTobeAddedbackSingle.clear();
        return this.svd.fsTobeAddedbackSingle;
    }

    void featureCodes_inIndexKeysAdd(int featCode) {
        this.svd.featureCodesInIndexKeys.set(featCode);
    }

    @Override
    public void enableReset(boolean flag) {
        this.svd.flushEnabled = flag;
    }

    @Override
    public final TypeSystem getTypeSystem() {
        return this.getTypeSystemImpl();
    }

    public final TypeSystemImpl getTypeSystemImpl() {
        if (this.tsi_local == null) {
            this.tsi_local = this.svd.tsi;
        }
        return this.tsi_local;
    }

    void installTypeSystemInAllViews(TypeSystemImpl ts) {
        this.svd.tsi = ts;
        ArrayList<CASImpl> sn2v = this.svd.sofaNbr2ViewMap;
        if (sn2v.size() > 0) {
            for (CASImpl view : sn2v.subList(1, sn2v.size())) {
                view.tsi_local = ts;
            }
        }
        this.getBaseCAS().tsi_local = ts;
    }

    @Override
    public ConstraintFactory getConstraintFactory() {
        return ConstraintFactory.instance();
    }

    @Override
    public <T extends FeatureStructure> T createFS(Type type) {
        TypeImpl ti = (TypeImpl)type;
        if (!ti.isCreatableAndNotBuiltinArray()) {
            throw new CASRuntimeException("NON_CREATABLE_TYPE", type.getName(), "CAS.createFS()");
        }
        return this.createFSAnnotCheck(ti);
    }

    private <T extends FeatureStructureImplC> T createFSAnnotCheck(TypeImpl ti) {
        if (ti.isAnnotationBaseType()) {
            this.getSofaRef();
        }
        this.assertTypeBelongsToCasTypesystem(ti);
        FsGenerator3 g = this.svd.generators[ti.getCode()];
        return (T)(g != null ? g.createFS(ti, this) : this.createFsFromGenerator(this.svd.baseGenerators, ti));
    }

    private void assertTypeBelongsToCasTypesystem(TypeImpl ti) {
        if (this.tsi_local != null && ti.getTypeSystem() != this.tsi_local) {
            String message = String.format("Creating a feature structure of type [%s](%d) from type system [%s] in CAS with different type system [%s] is not supported.", ti.getName(), ti.getCode(), String.format("<%,d>", System.identityHashCode(ti.getTypeSystem())), String.format("<%,d>", System.identityHashCode(this.tsi_local)));
            if (TypeSystemImpl.IS_ENABLE_STRICT_TYPE_SOURCE_CHECK) {
                throw new IllegalArgumentException(message);
            }
            Misc.decreasingWithTrace(strictTypeSourceCheckMessageCount, message, UIMAFramework.getLogger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean maybeMakeBaseVersionForPear(FeatureStructureImplC fs, TypeImpl ti) {
        TOP baseFs;
        if (!this.inPearContext()) {
            return false;
        }
        FsGenerator3 g = this.svd.generators[ti.getCode()];
        if (g == null) {
            return false;
        }
        try {
            this.suspendPearContext();
            this.assertTypeBelongsToCasTypesystem(ti);
            this.svd.reuseId = fs._id;
            baseFs = this.createFsFromGenerator(this.svd.baseGenerators, ti);
        }
        finally {
            this.restorePearContext();
            this.svd.reuseId = 0;
        }
        this.svd.id2base.put(baseFs);
        this.svd.id2tramp.put(baseFs._id, (TOP)fs);
        this.pearBaseFs = baseFs;
        return true;
    }

    private TOP createFsFromGenerator(FsGenerator3[] gs, TypeImpl ti) {
        return gs[ti.getCode()].createFS(ti, this);
    }

    public TOP createArray(TypeImpl array_type, int arrayLength) {
        TypeImpl_array tia = (TypeImpl_array)array_type;
        TypeImpl componentType = tia.getComponentType();
        if (componentType.isPrimitive()) {
            this.checkArrayPreconditions(arrayLength);
            switch (componentType.getCode()) {
                case 2: {
                    return new IntegerArray(array_type, this, arrayLength);
                }
                case 3: {
                    return new FloatArray(array_type, this, arrayLength);
                }
                case 23: {
                    return new BooleanArray(array_type, this, arrayLength);
                }
                case 24: {
                    return new ByteArray(array_type, this, arrayLength);
                }
                case 25: {
                    return new ShortArray(array_type, this, arrayLength);
                }
                case 26: {
                    return new LongArray(array_type, this, arrayLength);
                }
                case 27: {
                    return new DoubleArray(array_type, this, arrayLength);
                }
                case 4: {
                    return new StringArray(array_type, this, arrayLength);
                }
            }
            throw Misc.internalError();
        }
        if (IS_DISABLE_SUBTYPE_FSARRAY_CREATION) {
            return (TOP)((Object)this.createArrayFS(arrayLength));
        }
        return (TOP)((Object)this.createArrayFS(array_type, arrayLength));
    }

    @Override
    public ArrayFS createArrayFS(int length) {
        return this.createArrayFS(this.getTypeSystemImpl().fsArrayType, length);
    }

    private ArrayFS createArrayFS(TypeImpl type, int length) {
        this.checkArrayPreconditions(length);
        return new FSArray(type, this, length);
    }

    @Override
    public IntArrayFS createIntArrayFS(int length) {
        this.checkArrayPreconditions(length);
        return new IntegerArray(this.getTypeSystemImpl().intArrayType, this, length);
    }

    @Override
    public FloatArrayFS createFloatArrayFS(int length) {
        this.checkArrayPreconditions(length);
        return new FloatArray(this.getTypeSystemImpl().floatArrayType, this, length);
    }

    @Override
    public StringArrayFS createStringArrayFS(int length) {
        this.checkArrayPreconditions(length);
        return new StringArray(this.getTypeSystemImpl().stringArrayType, this, length);
    }

    public boolean isBackwardCompatibleCas() {
        if (this.svd.viewCount != 1) {
            return false;
        }
        if (!this.svd.initialSofaCreated) {
            return false;
        }
        Sofa sofa = this.getInitialView().getSofa();
        String sofaMime = sofa.getMimeType();
        if (!"text".equals(sofaMime)) {
            return false;
        }
        String sofaUri = sofa.getSofaURI();
        if (sofaUri != null) {
            return false;
        }
        TOP sofaArray = sofa.getSofaArray();
        if (sofaArray != null) {
            return false;
        }
        String sofaname = sofa.getSofaID();
        return "_InitialView".equals(sofaname);
    }

    int getViewCount() {
        return this.svd.viewCount;
    }

    FSIndexRepository getSofaIndexRepository(SofaFS aSofa) {
        return this.getSofaIndexRepository(aSofa.getSofaRef());
    }

    FSIndexRepositoryImpl getSofaIndexRepository(int aSofaRef) {
        if (aSofaRef >= this.svd.sofa2indexMap.size()) {
            return null;
        }
        return this.svd.sofa2indexMap.get(aSofaRef);
    }

    void setSofaIndexRepository(SofaFS aSofa, FSIndexRepositoryImpl indxRepos) {
        this.setSofaIndexRepository(aSofa.getSofaRef(), indxRepos);
    }

    void setSofaIndexRepository(int aSofaRef, FSIndexRepositoryImpl indxRepos) {
        Misc.setWithExpand(this.svd.sofa2indexMap, aSofaRef, indxRepos);
    }

    @Override
    @Deprecated
    public SofaFS createSofa(SofaID sofaID, String mimeType) {
        Sofa aSofa = this.createSofa(sofaID.getSofaID(), mimeType);
        this.getView(aSofa);
        return aSofa;
    }

    Sofa createSofa(String sofaName, String mimeType) {
        return this.createSofa(++this.svd.viewCount, sofaName, mimeType);
    }

    Sofa createSofa(int sofaNum, String sofaName, String mimeType) {
        boolean viewAlreadyExists;
        if (this.svd.sofaNameSet.contains(sofaName)) {
            throw new CASRuntimeException("SOFANAME_ALREADY_EXISTS", sofaName);
        }
        boolean bl = viewAlreadyExists = sofaNum == this.svd.viewCount;
        if (!viewAlreadyExists) {
            if (sofaNum == 1) {
                if (this.svd.viewCount == 0) {
                    this.svd.viewCount = 1;
                }
            } else {
                assert (sofaNum == this.svd.viewCount + 1);
                this.svd.viewCount = sofaNum;
            }
        }
        Sofa sofa = new Sofa(this.getTypeSystemImpl().sofaType, this.getBaseCAS(), sofaNum, sofaName, mimeType);
        this.getBaseIndexRepository().addFS(sofa);
        this.svd.sofaNameSet.add(sofaName);
        if (!viewAlreadyExists) {
            this.getView(sofa);
        }
        return sofa;
    }

    boolean hasView(String name) {
        return this.svd.sofaNameSet.contains(name);
    }

    Sofa createInitialSofa(String mimeType) {
        Sofa sofa = this.createSofa(1, "_InitialView", mimeType);
        this.registerInitialSofa();
        this.mySofaRef = sofa;
        return sofa;
    }

    void registerInitialSofa() {
        this.svd.initialSofaCreated = true;
    }

    boolean isInitialSofaCreated() {
        return this.svd.initialSofaCreated;
    }

    @Override
    @Deprecated
    public SofaFS getSofa(SofaID sofaID) {
        return this.getSofa(sofaID.getSofaID());
    }

    private SofaFS getSofa(String sofaName) {
        FSIterator iterator = this.svd.baseCAS.getSofaIterator();
        while (iterator.hasNext()) {
            SofaFS sofa = (SofaFS)iterator.next();
            if (!sofaName.equals(sofa.getSofaID())) continue;
            return sofa;
        }
        throw new CASRuntimeException("SOFANAME_NOT_FOUND", sofaName);
    }

    SofaFS getSofa(int sofaRef) {
        SofaFS aSofa = (SofaFS)this.ll_getFSForRef(sofaRef);
        if (aSofa == null) {
            CASRuntimeException e = new CASRuntimeException("SOFAREF_NOT_FOUND", new Object[0]);
            throw e;
        }
        return aSofa;
    }

    public int ll_getSofaNum(int sofaRef) {
        return ((Sofa)this.getFsFromId_checked(sofaRef)).getSofaNum();
    }

    public String ll_getSofaID(int sofaRef) {
        return ((Sofa)this.getFsFromId_checked(sofaRef)).getSofaID();
    }

    public String ll_getSofaDataString(int sofaAddr) {
        return ((Sofa)this.getFsFromId_checked(sofaAddr)).getSofaString();
    }

    public CASImpl getBaseCAS() {
        return this.svd.baseCAS;
    }

    @Override
    public <T extends SofaFS> FSIterator<T> getSofaIterator() {
        FSIndex sofaIndex = ((SharedViewData)this.svd).baseCAS.indexRepository.getIndex("SofaIndex");
        return sofaIndex.iterator();
    }

    public Sofa getSofaRef() {
        if (this.mySofaRef == null) {
            this.mySofaRef = this.createInitialSofa(null);
        }
        return this.mySofaRef;
    }

    public InputStream getSofaDataStream(SofaFS aSofa) {
        Sofa sofa = (Sofa)aSofa;
        String sd = sofa.getLocalStringData();
        if (null != sd) {
            ByteArrayInputStream bis = new ByteArrayInputStream(sd.getBytes(StandardCharsets.UTF_8));
            return bis;
        }
        if (null != aSofa.getLocalFSData()) {
            TOP fs = (TOP)sofa.getLocalFSData();
            ByteBuffer buf = null;
            switch (fs._getTypeCode()) {
                case 9: {
                    StringBuilder sb = new StringBuilder();
                    String[] theArray = ((StringArray)fs)._getTheArray();
                    for (int i = 0; i < theArray.length; ++i) {
                        if (i != 0) {
                            sb.append('\n');
                        }
                        sb.append(theArray[i]);
                    }
                    return new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
                }
                case 8: {
                    Object[] theArray = ((IntegerArray)fs)._getTheArray();
                    buf = ByteBuffer.allocate(theArray.length * 4);
                    buf.asIntBuffer().put((int[])theArray, 0, theArray.length);
                    break;
                }
                case 7: {
                    Object[] theArray = ((FloatArray)fs)._getTheArray();
                    buf = ByteBuffer.allocate(theArray.length * 4);
                    buf.asFloatBuffer().put((float[])theArray, 0, theArray.length);
                    break;
                }
                case 29: {
                    Object[] theArray = ((ByteArray)fs)._getTheArray();
                    buf = ByteBuffer.wrap((byte[])theArray);
                    break;
                }
                case 30: {
                    Object[] theArray = ((ShortArray)fs)._getTheArray();
                    buf = ByteBuffer.allocate(theArray.length * 2);
                    buf.asShortBuffer().put((short[])theArray, 0, theArray.length);
                    break;
                }
                case 31: {
                    Object[] theArray = ((LongArray)fs)._getTheArray();
                    buf = ByteBuffer.allocate(theArray.length * 8);
                    buf.asLongBuffer().put((long[])theArray, 0, theArray.length);
                    break;
                }
                case 32: {
                    Object[] theArray = ((DoubleArray)fs)._getTheArray();
                    buf = ByteBuffer.allocate(theArray.length * 8);
                    buf.asDoubleBuffer().put((double[])theArray, 0, theArray.length);
                    break;
                }
                default: {
                    throw Misc.internalError();
                }
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(buf.array());
            return bis;
        }
        if (null != aSofa.getSofaURI()) {
            try {
                URL url = new URL(aSofa.getSofaURI());
                return url.openStream();
            }
            catch (IOException exc) {
                throw new CASRuntimeException("SOFADATASTREAM_ERROR", exc.getMessage());
            }
        }
        return null;
    }

    @Override
    public <T extends FeatureStructure> FSIterator<T> createFilteredIterator(FSIterator<T> it, FSMatchConstraint cons) {
        return new FilteredIterator<T>(it, cons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeSystemImpl commitTypeSystem(boolean skip_loading_user_jcas) {
        TypeSystemImpl ts = this.getTypeSystemImpl();
        ClassLoader cl = this.getJCasClassLoader();
        TypeSystemImpl typeSystemImpl = ts;
        synchronized (typeSystemImpl) {
            if (!ts.isCommitted()) {
                ts.set_skip_loading_user_jcas(skip_loading_user_jcas);
                TypeSystemImpl tsc = ts.commit(cl);
                if (tsc != ts) {
                    this.installTypeSystemInAllViews(tsc);
                    ts = tsc;
                }
            }
        }
        SharedViewData.access$2202(this.svd, SharedViewData.access$2102(this.svd, ts.getGeneratorsForClassLoader(cl, false)));
        this.createIndexRepository();
        return ts;
    }

    public TypeSystemImpl commitTypeSystem() {
        return this.commitTypeSystem(false);
    }

    private void createIndexRepository() {
        if (!this.getTypeSystemMgr().isCommitted()) {
            throw new CASAdminException("MUST_COMMIT_TYPE_SYSTEM", new Object[0]);
        }
        if (this.indexRepository == null) {
            this.indexRepository = new FSIndexRepositoryImpl(this);
        }
    }

    @Override
    public FSIndexRepositoryMgr getIndexRepositoryMgr() {
        return this.indexRepository;
    }

    @Deprecated
    public void commitFS(FeatureStructure fs) {
        this.getIndexRepository().addFS(fs);
    }

    @Override
    public FeaturePath createFeaturePath() {
        return new FeaturePathImpl();
    }

    @Override
    public TypeSystemMgr getTypeSystemMgr() {
        return this.getTypeSystemImpl();
    }

    @Override
    public void reset() {
        if (this.isCasLocked()) {
            throw new CASAdminException("FLUSH_DISABLED", new Object[0]);
        }
        if (this == this.svd.baseCAS) {
            this.resetNoQuestions();
            return;
        }
        this.svd.baseCAS.resetNoQuestions();
    }

    public void resetNoQuestions() {
        this.svd.resetNoQuestions(true);
    }

    @Override
    @Deprecated
    public void flush() {
        this.reset();
    }

    @Override
    public FSIndexRepository getIndexRepository() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        if (this.indexRepository.isCommitted()) {
            return this.indexRepository;
        }
        return null;
    }

    FSIndexRepository getBaseIndexRepository() {
        if (((SharedViewData)this.svd).baseCAS.indexRepository.isCommitted()) {
            return ((SharedViewData)this.svd).baseCAS.indexRepository;
        }
        return null;
    }

    FSIndexRepositoryImpl getBaseIndexRepositoryImpl() {
        return ((SharedViewData)this.svd).baseCAS.indexRepository;
    }

    void addSofaFsToIndex(SofaFS sofa) {
        this.svd.baseCAS.getBaseIndexRepository().addFS(sofa);
    }

    void registerView(Sofa aSofa) {
        this.mySofaRef = aSofa;
    }

    @Override
    public <T extends FeatureStructure> ListIterator<T> fs2listIterator(FSIterator<T> it) {
        return it;
    }

    @Override
    public CAS getCAS() {
        if (this.indexRepository.isCommitted()) {
            return this;
        }
        throw new CASAdminException("MUST_COMMIT_INDEX_REPOSITORY", new Object[0]);
    }

    public FSClassRegistry getFSClassRegistry() {
        return null;
    }

    private void logFSUpdate(TOP fs, FeatureImpl fi, int arrayIndexStart, int nbrOfConsecutive) {
        Map changes = this.svd.modifiedPreexistingFSs;
        FsChange change = changes.computeIfAbsent(fs, key -> new FsChange((TOP)key));
        if (fi == null) {
            Misc.assertUie(arrayIndexStart >= 0);
            change.addArrayData(arrayIndexStart, nbrOfConsecutive);
        } else {
            change.addFeatData(fi.getOffset());
        }
    }

    private void logFSUpdate(TOP fs, PositiveIntSet indexesPlus1) {
        Map changes = this.svd.modifiedPreexistingFSs;
        FsChange change = changes.computeIfAbsent(fs, key -> new FsChange((TOP)key));
        change.addArrayData(indexesPlus1);
    }

    private void logFSUpdate(TOP fs, FeatureImpl fi) {
        this.logFSUpdate(fs, fi, -1, -1);
    }

    public <T extends TOP> T createFS(int id) {
        return this.getFsFromId_checked(id);
    }

    public int getArraySize(CommonArrayFS fs) {
        return fs.size();
    }

    @Override
    public int ll_getArraySize(int id) {
        return this.getArraySize((CommonArrayFS)this.getFsFromId_checked(id));
    }

    final void setWithCheckAndJournal(TOP fs, FeatureImpl fi, Runnable setter) {
        if (fs._inSetSortedIndex()) {
            boolean wasRemoved = this.checkForInvalidFeatureSetting(fs, fi.getCode());
            setter.run();
            if (wasRemoved) {
                this.maybeAddback(fs);
            }
        } else {
            setter.run();
        }
        this.maybeLogUpdate((FeatureStructureImplC)fs, fi);
    }

    public final void setWithCheckAndJournal(TOP fs, int featCode, Runnable setter) {
        if (fs._inSetSortedIndex()) {
            boolean wasRemoved = this.checkForInvalidFeatureSetting(fs, featCode);
            setter.run();
            if (wasRemoved) {
                this.maybeAddback(fs);
            }
        } else {
            setter.run();
        }
        this.maybeLogUpdate((FeatureStructureImplC)fs, featCode);
    }

    public final void setWithJournal(FeatureStructureImplC fs, FeatureImpl fi, Runnable setter) {
        setter.run();
        this.maybeLogUpdate(fs, fi);
    }

    public final boolean isLoggingNeeded(FeatureStructureImplC fs) {
        return this.svd.trackingMark != null && !this.svd.trackingMark.isNew(fs._id);
    }

    public final void maybeLogArrayUpdate(FeatureStructureImplC fs, FeatureImpl feat, int i) {
        if (this.isLoggingNeeded(fs)) {
            this.logFSUpdate((TOP)fs, feat, i, 1);
        }
    }

    public final void maybeLogArrayUpdates(FeatureStructureImplC fs, PositiveIntSet indexesPlus1) {
        if (this.isLoggingNeeded(fs)) {
            this.logFSUpdate((TOP)fs, indexesPlus1);
        }
    }

    public final void maybeLogArrayUpdates(FeatureStructureImplC fs, int startingIndex, int length) {
        if (this.isLoggingNeeded(fs)) {
            this.logFSUpdate((TOP)fs, null, startingIndex, length);
        }
    }

    public final void maybeLogUpdate(FeatureStructureImplC fs, FeatureImpl feat) {
        if (this.isLoggingNeeded(fs)) {
            this.logFSUpdate((TOP)fs, feat);
        }
    }

    public final void maybeLogUpdate(FeatureStructureImplC fs, int featCode) {
        if (this.isLoggingNeeded(fs)) {
            this.logFSUpdate((TOP)fs, this.getFeatFromCode_checked(featCode));
        }
    }

    public final boolean isLogging() {
        return this.svd.trackingMark != null;
    }

    public void setLongValue(FeatureStructureImplC fsIn, FeatureImpl feat, long v) {
        TOP fs = (TOP)fsIn;
        if (fs._inSetSortedIndex()) {
            boolean wasRemoved = this.checkForInvalidFeatureSetting(fs, feat.getCode());
            fs._setLongValueNcNj(feat, v);
            if (wasRemoved) {
                this.maybeAddback(fs);
            }
        } else {
            fs._setLongValueNcNj(feat, v);
        }
        this.maybeLogUpdate((FeatureStructureImplC)fs, feat);
    }

    void setFeatureValue(int fsRef, int featureCode, TOP value) {
        ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).setFeatureValue(this.getFeatFromCode_checked(featureCode), value);
    }

    public static void setFeatureValueMaybeSofa(TOP fs, FeatureImpl feat, TOP value) {
        if (fs instanceof Sofa) {
            assert (feat.getCode() == 12);
            ((Sofa)fs).setLocalSofaData(value);
        } else {
            fs.setFeatureValue(feat, value);
        }
    }

    public static void setFeatureValueFromStringNoDocAnnotUpdate(FeatureStructureImplC fs, FeatureImpl feat, String s) {
        if (fs instanceof Sofa && feat.getCode() == 13) {
            ((Sofa)fs).setLocalSofaDataNoDocAnnotUpdate(s);
        } else {
            CASImpl.setFeatureValueFromString(fs, feat, s);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setFeatureValueFromString(FeatureStructureImplC fs, FeatureImpl feat, String s) {
        TypeImpl range = feat.getRangeImpl();
        if (fs instanceof Sofa) {
            Sofa sofa = (Sofa)fs;
            switch (feat.getCode()) {
                case 11: {
                    sofa.setMimeType(s);
                    return;
                }
                case 13: {
                    sofa.setLocalSofaData(s);
                    return;
                }
                case 14: {
                    sofa.setRemoteSofaURI(s);
                    return;
                }
            }
            return;
        }
        if (feat.isInInt) {
            switch (range.getCode()) {
                case 3: {
                    fs.setFloatValue(feat, s == null ? 0.0f : Float.parseFloat(s));
                    return;
                }
                case 23: {
                    fs.setBooleanValue(feat, s == null ? false : Boolean.parseBoolean(s));
                    return;
                }
                case 26: {
                    fs.setLongValue(feat, s == null ? 0L : Long.parseLong(s));
                    return;
                }
                case 27: {
                    fs.setDoubleValue(feat, s == null ? 0.0 : Double.parseDouble(s));
                    return;
                }
                case 24: {
                    fs.setByteValue(feat, s == null ? (byte)0 : Byte.parseByte(s));
                    return;
                }
                case 25: {
                    fs.setShortValue(feat, s == null ? (short)0 : Short.parseShort(s));
                    return;
                }
                case 2: {
                    fs.setIntValue(feat, s == null ? 0 : Integer.parseInt(s));
                    return;
                }
                default: {
                    fs.setIntValue(feat, s == null ? 0 : Integer.parseInt(s));
                    return;
                }
            }
        } else if (range.isRefType) {
            if (s != null) throw new CASRuntimeException("SET_REF_FROM_STRING_NOT_SUPPORTED", feat.getName());
            fs.setFeatureValue(feat, null);
            return;
        } else if (range.isStringOrStringSubtype()) {
            fs.setStringValue(feat, s == null ? null : s);
            return;
        } else {
            Misc.internalError();
        }
    }

    public static final float int2float(int i) {
        return Float.intBitsToFloat(i);
    }

    public static final int float2int(float f) {
        return Float.floatToIntBits(f);
    }

    public static final double long2double(long l) {
        return Double.longBitsToDouble(l);
    }

    public static final long double2long(double d) {
        return Double.doubleToLongBits(d);
    }

    public final boolean isStringType(Type type) {
        return type instanceof TypeImpl_string;
    }

    public final boolean isAbstractArrayType(Type type) {
        return this.isArrayType(type);
    }

    public final boolean isArrayType(Type type) {
        return ((TypeImpl)type).isArray();
    }

    public final boolean isPrimitiveArrayType(Type type) {
        return type instanceof TypeImpl_array && !type.getComponentType().isPrimitive();
    }

    public final boolean isIntArrayType(Type type) {
        return type == this.getTypeSystemImpl().intArrayType;
    }

    public final boolean isFloatArrayType(Type type) {
        return ((TypeImpl)type).getCode() == 7;
    }

    public final boolean isStringArrayType(Type type) {
        return ((TypeImpl)type).getCode() == 9;
    }

    public final boolean isBooleanArrayType(Type type) {
        return ((TypeImpl)type).getCode() == 28;
    }

    public final boolean isByteArrayType(Type type) {
        return ((TypeImpl)type).getCode() == 29;
    }

    public final boolean isShortArrayType(Type type) {
        return ((TypeImpl)type).getCode() == 29;
    }

    public final boolean isLongArrayType(Type type) {
        return ((TypeImpl)type).getCode() == 31;
    }

    public final boolean isDoubleArrayType(Type type) {
        return ((TypeImpl)type).getCode() == 32;
    }

    public final boolean isFSArrayType(Type type) {
        return ((TypeImpl)type).getCode() == 6;
    }

    public final boolean isIntType(Type type) {
        return ((TypeImpl)type).getCode() == 2;
    }

    public final boolean isFloatType(Type type) {
        return ((TypeImpl)type).getCode() == 3;
    }

    public final boolean isByteType(Type type) {
        return ((TypeImpl)type).getCode() == 24;
    }

    public final boolean isBooleanType(Type type) {
        return ((TypeImpl)type).getCode() == 3;
    }

    public final boolean isShortType(Type type) {
        return ((TypeImpl)type).getCode() == 25;
    }

    public final boolean isLongType(Type type) {
        return ((TypeImpl)type).getCode() == 26;
    }

    public final boolean isDoubleType(Type type) {
        return ((TypeImpl)type).getCode() == 27;
    }

    @Override
    public void initCASIndexes() throws CASException {
        TypeSystemImpl ts = this.getTypeSystemImpl();
        if (!ts.isCommitted()) {
            throw new CASException("MUST_COMMIT_TYPE_SYSTEM", new Object[0]);
        }
        FSIndexComparator comp = this.indexRepository.createComparator();
        comp.setType(ts.sofaType);
        comp.addKey(ts.sofaNum, 0);
        this.indexRepository.createIndex(comp, "SofaIndex", 2);
        comp = this.indexRepository.createComparator();
        comp.setType(ts.annotType);
        comp.addKey(ts.startFeat, 0);
        comp.addKey(ts.endFeat, 1);
        comp.addKey(this.indexRepository.getDefaultTypeOrder(), 0);
        this.indexRepository.createIndex(comp, "AnnotationIndex");
    }

    public CAS getView(int sofaNum) {
        return this.svd.getViewFromSofaNbr(sofaNum);
    }

    @Override
    public CAS getCurrentView() {
        return this.getView("_InitialView");
    }

    @Override
    public JCas getJCas() {
        if (this.jcas == null) {
            this.jcas = JCasImpl.getJCas(this);
        }
        return this.jcas;
    }

    @Override
    public JCasImpl getJCasImpl() {
        if (this.jcas == null) {
            this.jcas = JCasImpl.getJCas(this);
        }
        return this.jcas;
    }

    @Override
    public JCas getJCas(SofaFS aSofa) throws CASException {
        this.svd.baseCAS.getJCas();
        return this.getView(aSofa).getJCas();
    }

    @Override
    @Deprecated
    public JCas getJCas(SofaID aSofaID) throws CASException {
        SofaFS sofa = this.getSofa(aSofaID);
        return this.getJCas(sofa);
    }

    CASImpl getInitialView() {
        return this.svd.getInitialView();
    }

    @Override
    public CAS createView(String aSofaID) {
        String absoluteSofaName = null;
        if (this.getCurrentComponentInfo() != null) {
            absoluteSofaName = this.getCurrentComponentInfo().mapToSofaID(aSofaID);
        }
        if (absoluteSofaName == null) {
            absoluteSofaName = aSofaID;
        }
        if ("_InitialView".equals(absoluteSofaName)) {
            throw new CASRuntimeException("SOFANAME_ALREADY_EXISTS", aSofaID);
        }
        Sofa newSofa = this.createSofa(absoluteSofaName, null);
        CASImpl newView = this.getView(newSofa);
        newView.registerView(newSofa);
        return newView;
    }

    @Override
    public CAS getView(String aSofaID) {
        String absoluteSofaName = null;
        if (this.getCurrentComponentInfo() != null) {
            absoluteSofaName = this.getCurrentComponentInfo().mapToSofaID(aSofaID);
        }
        if (absoluteSofaName == null) {
            absoluteSofaName = aSofaID;
        }
        if ("_InitialView".equals(absoluteSofaName)) {
            return this.getInitialView();
        }
        SofaFS sofa = this.getSofa(absoluteSofaName);
        return this.getView(sofa);
    }

    @Override
    public CASImpl getView(SofaFS aSofa) {
        Sofa sofa = (Sofa)aSofa;
        int sofaNbr = sofa.getSofaRef();
        CASImpl aView = this.svd.getViewFromSofaNbr(sofaNbr);
        if (null == aView) {
            aView = new CASImpl(this.svd.baseCAS, sofa);
            this.svd.setViewForSofaNbr(sofaNbr, aView);
            this.verifySofaNameUniqueIfDeserializedViewAdded(sofaNbr, sofa);
            return aView;
        }
        if (null == aView.mySofaRef) {
            aView.mySofaRef = sofa;
        }
        this.verifySofaNameUniqueIfDeserializedViewAdded(sofaNbr, aSofa);
        return aView;
    }

    private void verifySofaNameUniqueIfDeserializedViewAdded(int sofaNbr, SofaFS aSofa) {
        int curViewCount = this.svd.viewCount;
        if (curViewCount < sofaNbr) {
            assert (sofaNbr == curViewCount + 1);
            this.svd.viewCount = sofaNbr;
            String id = aSofa.getSofaID();
            Misc.assertUie(this.svd.sofaNameSet.contains(id));
        }
    }

    @Override
    public LowLevelTypeSystem ll_getTypeSystem() {
        return this.getTypeSystemImpl().getLowLevelTypeSystem();
    }

    @Override
    public LowLevelIndexRepository ll_getIndexRepository() {
        return this.indexRepository;
    }

    private final void checkLowLevelParams(TOP fs, TypeImpl domType, int featCode) {
        this.checkFeature(featCode);
        this.checkTypeHasFeature(domType, featCode);
    }

    private final void checkTypeHasFeature(TypeImpl domainType, int featureCode) {
        this.checkTypeHasFeature(domainType, this.getFeatFromCode_checked(featureCode));
    }

    private final void checkTypeHasFeature(TypeImpl domainType, FeatureImpl feature) {
        if (!domainType.isAppropriateFeature(feature)) {
            throw new LowLevelException("FEAT_DOM_ERROR", domainType.getCode(), domainType.getName(), feature.getCode(), feature.getName());
        }
    }

    public final void checkTypingConditions(Type domType, Type ranType, Feature feat) {
        TypeImpl domainTi = (TypeImpl)domType;
        FeatureImpl fi = (FeatureImpl)feat;
        this.checkTypeHasFeature(domainTi, fi);
        if (!((TypeImpl)fi.getRange()).subsumes((TypeImpl)ranType)) {
            throw new LowLevelException("FEAT_RAN_ERROR", fi.getCode(), feat.getName(), ((TypeImpl)ranType).getCode(), ranType.getName());
        }
    }

    private final void checkFsRan(FeatureImpl fi) throws LowLevelException {
        if (!fi.getRangeImpl().isRefType) {
            throw new LowLevelException("FS_RAN_TYPE_ERROR", fi.getCode(), fi.getName(), fi.getRange().getName());
        }
    }

    private final void checkFeature(int featureCode) {
        if (!this.getTypeSystemImpl().isFeature(featureCode)) {
            throw new LowLevelException("INVALID_FEATURE_CODE", featureCode);
        }
    }

    private TypeImpl getTypeFromCode(int typeCode) {
        return this.getTypeSystemImpl().getTypeForCode(typeCode);
    }

    private TypeImpl getTypeFromCode_checked(int typeCode) {
        return this.getTypeSystemImpl().getTypeForCode_checked(typeCode);
    }

    private FeatureImpl getFeatFromCode_checked(int featureCode) {
        return this.getTypeSystemImpl().getFeatureForCode_checked(featureCode);
    }

    public final <T extends TOP> T getFsFromId_checked(int fsRef) {
        T r = this.getFsFromId(fsRef);
        if (r == null) {
            if (fsRef == 0) {
                return null;
            }
            LowLevelException e = new LowLevelException("INVALID_FS_REF", fsRef);
            throw e;
        }
        return r;
    }

    @Override
    public final boolean ll_isRefType(int typeCode) {
        return this.getTypeFromCode((int)typeCode).isRefType;
    }

    @Override
    public final int ll_getTypeClass(int typeCode) {
        return TypeSystemImpl.getTypeClass(this.getTypeFromCode(typeCode));
    }

    @Override
    public final int ll_createFS(int typeCode) {
        return this.ll_createFS(typeCode, true);
    }

    @Override
    public final int ll_createFS(int typeCode, boolean doCheck) {
        TypeImpl ti = (TypeImpl)this.getTypeSystemImpl().ll_getTypeForCode(typeCode);
        if (doCheck && (ti == null || !ti.isCreatableAndNotBuiltinArray())) {
            throw new LowLevelException("CREATE_FS_OF_TYPE_ERROR", typeCode);
        }
        TOP fs = (TOP)this.createFS(ti);
        if (!fs._isPearTrampoline()) {
            this.setId2FsMaybeUnconditionally(fs);
        }
        return fs._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TOP createFsWithExistingId(TypeImpl ti, int id) {
        this.svd.reuseId = id;
        try {
            TOP fs = (TOP)this.createFS(ti);
            this.svd.id2fs.putChange(id, fs);
            TOP tOP = fs;
            return tOP;
        }
        finally {
            this.svd.reuseId = 0;
        }
    }

    @Override
    public int ll_createArray(int typeCode, int arrayLength) {
        TOP fs = this.createArray(this.getTypeFromCode_checked(typeCode), arrayLength);
        this.setId2FsMaybeUnconditionally(fs);
        return fs._id;
    }

    public int createTempArray(int type, int len) {
        return this.ll_createArray(type, len);
    }

    @Override
    public int ll_createByteArray(int arrayLength) {
        TOP fs = this.createArray(this.getTypeSystemImpl().byteArrayType, arrayLength);
        this.set_id2fs(fs);
        return fs._id;
    }

    @Override
    public int ll_createBooleanArray(int arrayLength) {
        TOP fs = this.createArray(this.getTypeSystemImpl().booleanArrayType, arrayLength);
        this.set_id2fs(fs);
        return fs._id;
    }

    @Override
    public int ll_createShortArray(int arrayLength) {
        TOP fs = this.createArray(this.getTypeSystemImpl().shortArrayType, arrayLength);
        this.set_id2fs(fs);
        return fs._id;
    }

    @Override
    public int ll_createLongArray(int arrayLength) {
        TOP fs = this.createArray(this.getTypeSystemImpl().longArrayType, arrayLength);
        this.set_id2fs(fs);
        return fs._id;
    }

    @Override
    public int ll_createDoubleArray(int arrayLength) {
        TOP fs = this.createArray(this.getTypeSystemImpl().doubleArrayType, arrayLength);
        this.set_id2fs(fs);
        return fs._id;
    }

    @Override
    public int ll_createArray(int typeCode, int arrayLength, boolean doChecks) {
        TypeImpl ti = this.getTypeFromCode_checked(typeCode);
        if (doChecks) {
            if (!ti.isArray()) {
                throw new LowLevelException("CREATE_ARRAY_OF_TYPE_ERROR", typeCode, ti.getName());
            }
            if (arrayLength < 0) {
                throw new LowLevelException("ILLEGAL_ARRAY_LENGTH", arrayLength);
            }
        }
        TOP fs = this.createArray(ti, arrayLength);
        this.set_id2fs(fs);
        return fs._id;
    }

    public void validateArraySize(int length) {
        if (length < 0) {
            throw new CASRuntimeException("ILLEGAL_ARRAY_SIZE", new Object[0]);
        }
    }

    @Override
    public final int ll_getFSRef(FeatureStructure fs) {
        if (null == fs) {
            return 0;
        }
        TOP fst = (TOP)fs;
        if (fst._isPearTrampoline()) {
            return fst._id;
        }
        this.svd.id2fs.putUnconditionally(fst);
        return ((FeatureStructureImplC)fs)._id;
    }

    @Override
    public <T extends TOP> T ll_getFSForRef(int id) {
        return this.getFsFromId_checked(id);
    }

    @Override
    public final int ll_getIntValue(int fsRef, int featureCode) {
        Object fs = this.getFsFromId_checked(fsRef);
        if (featureCode == 0) {
            return ((FeatureStructureImplC)fs)._getTypeImpl().getCode();
        }
        FeatureImpl fi = this.getFeatFromCode_checked(featureCode);
        SlotKinds.SlotKind kind = fi.getSlotKind();
        switch (kind) {
            case Slot_HeapRef: {
                return ((FeatureStructureImplC)fs).getFeatureValue((Feature)fi)._id;
            }
            case Slot_Boolean: 
            case Slot_Byte: 
            case Slot_Short: 
            case Slot_Int: 
            case Slot_Float: {
                return ((FeatureStructureImplC)fs)._getIntValueNc(fi);
            }
            case Slot_StrRef: {
                return this.getCodeForString(((FeatureStructureImplC)fs)._getStringValueNc(fi));
            }
            case Slot_LongRef: {
                return this.getCodeForLong(((FeatureStructureImplC)fs)._getLongValueNc(fi));
            }
            case Slot_DoubleRef: {
                return this.getCodeForLong(CASImpl.double2long(((FeatureStructureImplC)fs)._getDoubleValueNc(fi)));
            }
        }
        throw new CASRuntimeException("INAPPROP_RANGE", fi.getName(), "int", fi.getRange().getName());
    }

    @Override
    public final float ll_getFloatValue(int fsRef, int featureCode) {
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).getFloatValue(this.getFeatFromCode_checked(featureCode));
    }

    @Override
    public final String ll_getStringValue(int fsRef, int featureCode) {
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).getStringValue(this.getFeatFromCode_checked(featureCode));
    }

    @Override
    public final int ll_getRefValue(int fsRef, int featureCode) {
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).getFeatureValue(this.getFeatFromCode_checked(featureCode))._id();
    }

    @Override
    public final int ll_getIntValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        return this.ll_getIntValue(fsRef, featureCode);
    }

    @Override
    public final float ll_getFloatValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        return this.ll_getFloatValue(fsRef, featureCode);
    }

    @Override
    public final String ll_getStringValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        return this.ll_getStringValue(fsRef, featureCode);
    }

    @Override
    public final int ll_getRefValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkFsRefConditions(fsRef, featureCode);
        }
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).getFeatureValue(this.getFeatFromCode_checked(featureCode))._id();
    }

    private boolean checkForInvalidFeatureSetting(TOP fs, int featCode) {
        if (this.doInvalidFeatSettingCheck(fs)) {
            if (!this.svd.featureCodesInIndexKeys.get(featCode)) {
                return false;
            }
            boolean wasRemoved = this.checkForInvalidFeatureSetting2(fs);
            if (wasRemoved && this.doCorruptReport()) {
                this.featModWhileInIndexReport((FeatureStructure)fs, featCode);
            }
            return wasRemoved;
        }
        return false;
    }

    boolean checkForInvalidFeatureSetting(TOP fs, int featCode, FSsTobeAddedback toBeAdded) {
        if (this.doInvalidFeatSettingCheck(fs)) {
            if (!this.svd.featureCodesInIndexKeys.get(featCode)) {
                return false;
            }
            boolean wasRemoved = this.removeFromCorruptableIndexAnyView(fs, toBeAdded);
            return wasRemoved;
        }
        return false;
    }

    boolean checkForInvalidFeatureSetting(TOP fs, FSsTobeAddedback toBeAdded) {
        if (this.doInvalidFeatSettingCheck(fs)) {
            boolean wasRemoved = this.removeFromCorruptableIndexAnyView(fs, toBeAdded);
            return wasRemoved;
        }
        return false;
    }

    private boolean checkForInvalidFeatureSetting2(TOP fs) {
        int ssz = this.svd.fssTobeAddedback.size();
        boolean wasRemoved = this.removeFromCorruptableIndexAnyView(fs, ssz > 0 ? this.getAddback(ssz) : this.getAddbackSingle());
        if (!wasRemoved && this.svd.fsTobeAddedbackSingleInUse) {
            this.svd.fsTobeAddedbackSingleInUse = false;
        }
        return wasRemoved;
    }

    private boolean doCorruptReport() {
        return IS_REPORT_FS_UPDATE_CORRUPTS_INDEX && this.svd.fssTobeAddedback.size() == 0;
    }

    private boolean doInvalidFeatSettingCheck(TOP fs) {
        if (!fs._inSetSortedIndex()) {
            return false;
        }
        int ssz = this.svd.fssTobeAddedback.size();
        return !IS_DISABLED_PROTECT_INDEXES || ssz != 0;
    }

    private void featModWhileInIndexReport(FeatureStructure fs, int featCode) {
        this.featModWhileInIndexReport(fs, this.getFeatFromCode_checked(featCode));
    }

    private void featModWhileInIndexReport(FeatureStructure fs, FeatureImpl fi) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new Throwable().printStackTrace(pw);
        pw.close();
        String msg = String.format("While FS was in the index, the feature \"%s\", which is used as a key in one or more indexes, was modified\n FS = \"%s\"\n%s%n", fi == null ? "for-all-features" : fi.getName(), fs.toString(), sw.toString());
        UIMAFramework.getLogger().log(Level.WARNING, msg);
        if (IS_THROW_EXCEPTION_CORRUPT_INDEX) {
            throw new UIMARuntimeException("illegal_update_indexed_fs", new Object[0]);
        }
    }

    public void maybeAddback(TOP fs) {
        if (this.svd.fssTobeAddedback.size() == 0) {
            assert (this.svd.fsTobeAddedbackSingleInUse);
            this.svd.fsTobeAddedbackSingle.addback(fs);
            this.svd.fsTobeAddedbackSingleInUse = false;
        }
    }

    boolean removeFromCorruptableIndexAnyView(TOP fs, FSsTobeAddedback toBeAdded) {
        return this.removeFromIndexAnyView(fs, toBeAdded, true);
    }

    boolean removeFromIndexAnyView(TOP fs, FSsTobeAddedback toBeAdded, boolean isSkipBagIndexes) {
        TypeImpl ti = fs._getTypeImpl();
        if (ti.isAnnotationBaseType()) {
            boolean r = this.removeAndRecord(fs, (FSIndexRepositoryImpl)fs._casView.getIndexRepository(), toBeAdded, isSkipBagIndexes);
            fs._resetInSetSortedIndex();
            return r;
        }
        Iterator viewIterator = this.getViewIterator();
        boolean wasRemoved = false;
        while (viewIterator.hasNext()) {
            wasRemoved |= this.removeAndRecord(fs, (FSIndexRepositoryImpl)((CAS)viewIterator.next()).getIndexRepository(), toBeAdded, isSkipBagIndexes);
        }
        fs._resetInSetSortedIndex();
        return wasRemoved;
    }

    private boolean removeAndRecord(TOP fs, FSIndexRepositoryImpl ir, FSsTobeAddedback toBeAdded, boolean isSkipBagIndex) {
        boolean wasRemoved = ir.removeFS_ret(fs, isSkipBagIndex);
        if (wasRemoved) {
            toBeAdded.recordRemove(fs, ir, 1);
        }
        return wasRemoved;
    }

    @Override
    public final void ll_setIntValue(int fsRef, int featureCode, int value) {
        Object fs = this.getFsFromId_checked(fsRef);
        if (featureCode == 0) {
            this.switchFsType((TOP)fs, value);
            return;
        }
        FeatureImpl fi = this.getFeatFromCode_checked(featureCode);
        if (((FeatureStructureImplC)fs)._getTypeImpl().isArray()) {
            throw new UnsupportedOperationException("ll_setIntValue not permitted to set a feature of an array");
        }
        SlotKinds.SlotKind kind = fi.getSlotKind();
        switch (kind) {
            case Slot_HeapRef: {
                if (fi.getCode() == 15) {
                    TOP sofa = ((FeatureStructureImplC)fs).getFeatureValue(fi);
                    if (sofa._id != value) {
                        throw new UnsupportedOperationException("ll_setIntValue not permitted to change a sofaRef feature");
                    }
                    return;
                }
                Object ref = ((TOP)fs)._casView.getFsFromId_checked(value);
                ((FeatureStructureImplC)fs).setFeatureValue(fi, (FeatureStructure)ref);
                return;
            }
            case Slot_Boolean: 
            case Slot_Byte: 
            case Slot_Short: 
            case Slot_Int: 
            case Slot_Float: {
                ((FeatureStructureImplC)fs)._setIntValueCJ(fi, value);
                break;
            }
            case Slot_StrRef: {
                String s = this.getStringForCode(value);
                if (s == null && value != 0) {
                    Misc.internalError(new Exception("ll_setIntValue got null string for non-0 handle: " + value));
                }
                ((FeatureStructureImplC)fs)._setRefValueNfcCJ(fi, this.getStringForCode(value));
                break;
            }
            case Slot_LongRef: 
            case Slot_DoubleRef: {
                Long lng = this.getLongForCode(value);
                if (lng == null) {
                    Misc.internalError(new Exception("ll_setIntValue got null Long/Double for handle: " + value));
                }
                ((FeatureStructureImplC)fs)._setLongValueNfcCJ(fi, lng);
                break;
            }
            default: {
                CASRuntimeException e = new CASRuntimeException("INAPPROP_RANGE", fi.getName(), "int", fi.getRange().getName());
                throw e;
            }
        }
    }

    private String getStringForCode(int i) {
        if (null == this.svd.llstringSet) {
            return null;
        }
        return this.svd.llstringSet.getStringForCode(i);
    }

    private int getCodeForString(String s) {
        if (null == this.svd.llstringSet) {
            this.svd.llstringSet = new StringSet();
        }
        return this.svd.llstringSet.getCodeForString(s);
    }

    private Long getLongForCode(int i) {
        if (null == this.svd.lllongSet) {
            return null;
        }
        return this.svd.lllongSet.getLongForCode(i);
    }

    private int getCodeForLong(long s) {
        if (null == this.svd.lllongSet) {
            this.svd.lllongSet = new LongSet();
        }
        return this.svd.lllongSet.getCodeForLong(s);
    }

    private void switchFsType(TOP fs, int value) {
        boolean wasRemoved = this.removeFromIndexAnyView(fs, this.getAddbackSingle(), false);
        if (!wasRemoved) {
            this.svd.fsTobeAddedbackSingleInUse = false;
        }
        TypeImpl newType = this.getTypeFromCode_checked(value);
        Class<?> newClass = newType.getJavaClass();
        if (fs instanceof UimaSerializable || UimaSerializable.class.isAssignableFrom(newClass)) {
            throw new UnsupportedOperationException("can't switch type to/from UimaSerializable");
        }
        Object mst = null;
        if (newClass == fs._getTypeImpl().getJavaClass() || newType.subsumes(fs._getTypeImpl())) {
            fs._setTypeImpl(newType);
            return;
        }
        boolean isOkToCopyFeatures = fs._getTypeImpl().subsumes(newType) || newType.subsumes(fs._getTypeImpl());
        TOP newFs = this.createFsWithExistingId(newType, fs._id);
        if (isOkToCopyFeatures) {
            newFs._copyIntAndRefArraysFrom(fs);
        }
        long st = System.nanoTime();
        this.walkReachablePlusFSsSorted(fsItem -> {
            if (fsItem._getTypeImpl().hasRefFeature) {
                if (fsItem instanceof FSArray) {
                    TOP[] a = ((FSArray)fsItem)._getTheArray();
                    for (int i = 0; i < a.length; ++i) {
                        if (fs != a[i]) continue;
                        a[i] = newFs;
                    }
                    return;
                }
                int sz = fsItem._getTypeImpl().nbrOfUsedRefDataSlots;
                for (int i = 0; i < sz; ++i) {
                    Object o = fsItem._getRefValueCommon(i);
                    if (o != fs) continue;
                    fsItem._setRefValueCommon(i, newFs);
                }
            }
        }, null, null, null);
    }

    @Override
    public final void ll_setFloatValue(int fsRef, int featureCode, float value) {
        ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).setFloatValue(this.getFeatFromCode_checked(featureCode), value);
    }

    @Override
    public final void ll_setStringValue(int fsRef, int featureCode, String value) {
        ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).setStringValue(this.getFeatFromCode_checked(featureCode), value);
    }

    @Override
    public final void ll_setRefValue(int fsRef, int featureCode, int value) {
        this.setFeatureValue(fsRef, featureCode, (TOP)this.getFsFromId_checked(value));
    }

    @Override
    public final void ll_setIntValue(int fsRef, int featureCode, int value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        this.ll_setIntValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setFloatValue(int fsRef, int featureCode, float value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        this.ll_setFloatValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setStringValue(int fsRef, int featureCode, String value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        this.ll_setStringValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setCharBufferValue(int fsRef, int featureCode, char[] buffer, int start, int length, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        this.ll_setCharBufferValue(fsRef, featureCode, buffer, start, length);
    }

    @Override
    public final void ll_setCharBufferValue(int fsRef, int featureCode, char[] buffer, int start, int length) {
        this.ll_setStringValue(fsRef, featureCode, new String(buffer, start, length));
    }

    @Override
    public int ll_copyCharBufferValue(int fsRef, int featureCode, char[] buffer, int start) {
        String str = this.ll_getStringValue(fsRef, featureCode);
        if (str == null) {
            return -1;
        }
        int len = str.length();
        int requestedMax = start + len;
        int max = buffer.length < requestedMax ? buffer.length - start : len;
        for (int i = 0; i < max; ++i) {
            buffer[start + i] = str.charAt(i);
        }
        return len;
    }

    @Override
    public int ll_getCharBufferValueSize(int fsRef, int featureCode) {
        String str = this.ll_getStringValue(fsRef, featureCode);
        return str.length();
    }

    @Override
    public final void ll_setRefValue(int fsRef, int featureCode, int value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkFsRefConditions(fsRef, featureCode);
        }
        this.ll_setRefValue(fsRef, featureCode, value);
    }

    public final int getIntArrayValue(IntegerArray array, int i) {
        return array.get(i);
    }

    public final float getFloatArrayValue(FloatArray array, int i) {
        return array.get(i);
    }

    public final String getStringArrayValue(StringArray array, int i) {
        return array.get(i);
    }

    public final FeatureStructure getRefArrayValue(FSArray array, int i) {
        return array.get(i);
    }

    @Override
    public final int ll_getIntArrayValue(int fsRef, int position) {
        return this.getIntArrayValue((IntegerArray)this.getFsFromId_checked(fsRef), position);
    }

    @Override
    public final float ll_getFloatArrayValue(int fsRef, int position) {
        return this.getFloatArrayValue((FloatArray)this.getFsFromId_checked(fsRef), position);
    }

    @Override
    public final String ll_getStringArrayValue(int fsRef, int position) {
        return this.getStringArrayValue((StringArray)this.getFsFromId_checked(fsRef), position);
    }

    @Override
    public final int ll_getRefArrayValue(int fsRef, int position) {
        return ((TOP)this.getRefArrayValue((FSArray)this.getFsFromId_checked(fsRef), position))._id();
    }

    private void throwAccessTypeError(int fsRef, int typeCode) {
        throw new LowLevelException("ACCESS_TYPE_ERROR", fsRef, typeCode, this.getTypeSystemImpl().ll_getTypeForCode(typeCode).getName(), this.getTypeSystemImpl().ll_getTypeForCode(this.ll_getFSRefType(fsRef)).getName());
    }

    public final void checkArrayBounds(int fsRef, int pos) {
        int arrayLength = this.ll_getArraySize(fsRef);
        if (pos < 0 || pos >= arrayLength) {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
    }

    public final void checkArrayBounds(int arrayLength, int pos, int length) {
        if (pos < 0 || length < 0 || pos + length > arrayLength) {
            throw new LowLevelException("ARRAY_INDEX_LENGTH_OUT_OF_RANGE", Integer.toString(pos), Integer.toString(length));
        }
    }

    private final void checkNonArrayConditions(int fsRef, int featureCode) {
        Object fs = this.getFsFromId_checked(fsRef);
        TypeImpl domainType = (TypeImpl)((FeatureStructureImplC)fs).getType();
        this.checkFeature(featureCode);
        TypeSystemImpl tsi = this.getTypeSystemImpl();
        FeatureImpl fi = tsi.getFeatureForCode_checked(featureCode);
        this.checkTypeHasFeature(domainType, fi);
    }

    private final void checkFsRefConditions(int fsRef, int featureCode) {
        Object fs = this.getFsFromId_checked(fsRef);
        this.checkLowLevelParams((TOP)fs, ((FeatureStructureImplC)fs)._getTypeImpl(), featureCode);
        TypeSystemImpl tsi = this.getTypeSystemImpl();
        FeatureImpl fi = tsi.getFeatureForCode_checked(featureCode);
        this.checkFsRan(fi);
    }

    private final void checkPrimitiveArrayConditions(int fsRef, int typeCode, int position) {
        if (typeCode != this.ll_getFSRefType(fsRef)) {
            this.throwAccessTypeError(fsRef, typeCode);
        }
        this.checkArrayBounds(fsRef, position);
    }

    @Override
    public final int ll_getIntArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 8, position);
        }
        return this.ll_getIntArrayValue(fsRef, position);
    }

    @Override
    public float ll_getFloatArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 7, position);
        }
        return this.ll_getFloatArrayValue(fsRef, position);
    }

    @Override
    public String ll_getStringArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 9, position);
        }
        return this.ll_getStringArrayValue(fsRef, position);
    }

    @Override
    public int ll_getRefArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 6, position);
        }
        return this.ll_getRefArrayValue(fsRef, position);
    }

    @Override
    public void ll_setIntArrayValue(int fsRef, int position, int value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 8, position);
        }
        this.ll_setIntArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setFloatArrayValue(int fsRef, int position, float value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 7, position);
        }
        this.ll_setFloatArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setStringArrayValue(int fsRef, int position, String value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 9, position);
        }
        this.ll_setStringArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setRefArrayValue(int fsRef, int position, int value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 6, position);
        }
        this.ll_setRefArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setIntArrayValue(int fsRef, int position, int value) {
        IntegerArray array = (IntegerArray)this.getFsFromId_checked(fsRef);
        array.set(position, value);
    }

    @Override
    public void ll_setFloatArrayValue(int fsRef, int position, float value) {
        FloatArray array = (FloatArray)this.getFsFromId_checked(fsRef);
        array.set(position, value);
    }

    @Override
    public void ll_setStringArrayValue(int fsRef, int position, String value) {
        StringArray array = (StringArray)this.getFsFromId_checked(fsRef);
        array.set(position, value);
    }

    @Override
    public void ll_setRefArrayValue(int fsRef, int position, int value) {
        FSArray array = (FSArray)this.getFsFromId_checked(fsRef);
        array.set(position, this.getFsFromId_checked(value));
    }

    @Override
    public int ll_getFSRefType(int fsRef) {
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef))._getTypeCode();
    }

    @Override
    public int ll_getFSRefType(int fsRef, boolean doChecks) {
        return this.ll_getFSRefType(fsRef);
    }

    @Override
    public LowLevelCAS getLowLevelCAS() {
        return this;
    }

    @Override
    public int size() {
        throw new UIMARuntimeException("INTERNAL_ERROR", new Object[0]);
    }

    @Override
    public ClassLoader getJCasClassLoader() {
        return this.svd.jcasClassLoader;
    }

    @Override
    public void setJCasClassLoader(ClassLoader classLoader) {
        this.svd.jcasClassLoader = classLoader;
    }

    public void switchClassLoader(ClassLoader newClassLoader, boolean wasLocked) {
        this.svd.switchClassLoader(newClassLoader, wasLocked);
    }

    public void switchClassLoaderLockCas(Object userCode) {
        this.switchClassLoaderLockCasCL(userCode.getClass().getClassLoader());
    }

    public void switchClassLoaderLockCasCL(ClassLoader newClassLoader) {
        boolean wasLocked = this.isCasLocked();
        this.enableReset(false);
        this.svd.switchClassLoader(newClassLoader, wasLocked);
    }

    public void restoreClassLoaderUnlockCas() {
        SwitchControl switchControlInstance;
        boolean empty_switchControl = this.svd.switchControl.isEmpty();
        SwitchControl switchControl = switchControlInstance = empty_switchControl ? null : (SwitchControl)this.svd.switchControl.pop();
        if (empty_switchControl || !switchControlInstance.wasLocked) {
            this.enableReset(true);
        }
        this.svd.restoreClassLoader(empty_switchControl, switchControlInstance);
    }

    @Override
    public FeatureValuePath createFeatureValuePath(String featureValuePath) throws CASRuntimeException {
        return FeatureValuePathImpl.getFeaturePath(featureValuePath);
    }

    @Override
    public void setOwner(CasOwner aCasOwner) {
        CASImpl baseCas = this.getBaseCAS();
        if (baseCas != this) {
            baseCas.setOwner(aCasOwner);
        } else {
            super.setOwner(aCasOwner);
        }
    }

    @Override
    public void release() {
        CASImpl baseCas = this.getBaseCAS();
        if (baseCas != this) {
            baseCas.release();
        } else {
            super.release();
        }
    }

    @Override
    public ByteArrayFS createByteArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return new ByteArray(this.getJCas(), length);
    }

    @Override
    public BooleanArrayFS createBooleanArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return new BooleanArray(this.getJCas(), length);
    }

    @Override
    public ShortArrayFS createShortArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return new ShortArray(this.getJCas(), length);
    }

    @Override
    public LongArrayFS createLongArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return new LongArray(this.getJCas(), length);
    }

    @Override
    public DoubleArrayFS createDoubleArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return new DoubleArray(this.getJCas(), length);
    }

    @Override
    public byte ll_getByteValue(int fsRef, int featureCode) {
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).getByteValue(this.getFeatFromCode_checked(featureCode));
    }

    @Override
    public byte ll_getByteValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        return this.ll_getByteValue(fsRef, featureCode);
    }

    @Override
    public boolean ll_getBooleanValue(int fsRef, int featureCode) {
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).getBooleanValue(this.getFeatFromCode_checked(featureCode));
    }

    @Override
    public boolean ll_getBooleanValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        return this.ll_getBooleanValue(fsRef, featureCode);
    }

    @Override
    public short ll_getShortValue(int fsRef, int featureCode) {
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).getShortValue(this.getFeatFromCode_checked(featureCode));
    }

    @Override
    public short ll_getShortValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        return this.ll_getShortValue(fsRef, featureCode);
    }

    @Override
    public long ll_getLongValue(int fsRef, int featureCode) {
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).getLongValue(this.getFeatFromCode_checked(featureCode));
    }

    @Override
    public long ll_getLongValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        return this.ll_getLongValue(fsRef, featureCode);
    }

    @Override
    public double ll_getDoubleValue(int fsRef, int featureCode) {
        return ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).getDoubleValue(this.getFeatFromCode_checked(featureCode));
    }

    @Override
    public double ll_getDoubleValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        return this.ll_getDoubleValue(fsRef, featureCode);
    }

    @Override
    public void ll_setBooleanValue(int fsRef, int featureCode, boolean value) {
        ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).setBooleanValue(this.getFeatFromCode_checked(featureCode), value);
    }

    @Override
    public void ll_setBooleanValue(int fsRef, int featureCode, boolean value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        this.ll_setBooleanValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setByteValue(int fsRef, int featureCode, byte value) {
        ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).setByteValue(this.getFeatFromCode_checked(featureCode), value);
    }

    @Override
    public void ll_setByteValue(int fsRef, int featureCode, byte value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        this.ll_setByteValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setShortValue(int fsRef, int featureCode, short value) {
        ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).setShortValue(this.getFeatFromCode_checked(featureCode), value);
    }

    @Override
    public void ll_setShortValue(int fsRef, int featureCode, short value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        this.ll_setShortValue(fsRef, featureCode, value);
    }

    @Override
    public void ll_setLongValue(int fsRef, int featureCode, long value) {
        ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).setLongValue(this.getFeatFromCode_checked(featureCode), value);
    }

    @Override
    public void ll_setLongValue(int fsRef, int featureCode, long value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        this.ll_setLongValue(fsRef, featureCode, value);
    }

    @Override
    public void ll_setDoubleValue(int fsRef, int featureCode, double value) {
        ((FeatureStructureImplC)this.getFsFromId_checked(fsRef)).setDoubleValue(this.getFeatFromCode_checked(featureCode), value);
    }

    @Override
    public void ll_setDoubleValue(int fsRef, int featureCode, double value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, featureCode);
        }
        this.ll_setDoubleValue(fsRef, featureCode, value);
    }

    @Override
    public byte ll_getByteArrayValue(int fsRef, int position) {
        return ((ByteArray)this.getFsFromId_checked(fsRef)).get(position);
    }

    @Override
    public byte ll_getByteArrayValue(int fsRef, int position, boolean doTypeChecks) {
        return this.ll_getByteArrayValue(fsRef, position);
    }

    @Override
    public boolean ll_getBooleanArrayValue(int fsRef, int position) {
        return ((BooleanArray)this.getFsFromId_checked(fsRef)).get(position);
    }

    @Override
    public boolean ll_getBooleanArrayValue(int fsRef, int position, boolean doTypeChecks) {
        return this.ll_getBooleanArrayValue(fsRef, position);
    }

    @Override
    public short ll_getShortArrayValue(int fsRef, int position) {
        return ((ShortArray)this.getFsFromId_checked(fsRef)).get(position);
    }

    @Override
    public short ll_getShortArrayValue(int fsRef, int position, boolean doTypeChecks) {
        return this.ll_getShortArrayValue(fsRef, position);
    }

    @Override
    public long ll_getLongArrayValue(int fsRef, int position) {
        return ((LongArray)this.getFsFromId_checked(fsRef)).get(position);
    }

    @Override
    public long ll_getLongArrayValue(int fsRef, int position, boolean doTypeChecks) {
        return this.ll_getLongArrayValue(fsRef, position);
    }

    @Override
    public double ll_getDoubleArrayValue(int fsRef, int position) {
        return ((DoubleArray)this.getFsFromId_checked(fsRef)).get(position);
    }

    @Override
    public double ll_getDoubleArrayValue(int fsRef, int position, boolean doTypeChecks) {
        return this.ll_getDoubleArrayValue(fsRef, position);
    }

    @Override
    public void ll_setByteArrayValue(int fsRef, int position, byte value) {
        ((ByteArray)this.getFsFromId_checked(fsRef)).set(position, value);
    }

    @Override
    public void ll_setByteArrayValue(int fsRef, int position, byte value, boolean doTypeChecks) {
        this.ll_setByteArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setBooleanArrayValue(int fsRef, int position, boolean b) {
        ((BooleanArray)this.getFsFromId_checked(fsRef)).set(position, b);
    }

    @Override
    public void ll_setBooleanArrayValue(int fsRef, int position, boolean value, boolean doTypeChecks) {
        this.ll_setBooleanArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setShortArrayValue(int fsRef, int position, short value) {
        ((ShortArray)this.getFsFromId_checked(fsRef)).set(position, value);
    }

    @Override
    public void ll_setShortArrayValue(int fsRef, int position, short value, boolean doTypeChecks) {
        this.ll_setShortArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setLongArrayValue(int fsRef, int position, long value) {
        ((LongArray)this.getFsFromId_checked(fsRef)).set(position, value);
    }

    @Override
    public void ll_setLongArrayValue(int fsRef, int position, long value, boolean doTypeChecks) {
        this.ll_setLongArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setDoubleArrayValue(int fsRef, int position, double d) {
        ((DoubleArray)this.getFsFromId_checked(fsRef)).set(position, d);
    }

    @Override
    public void ll_setDoubleArrayValue(int fsRef, int position, double value, boolean doTypeChecks) {
        this.ll_setDoubleArrayValue(fsRef, position, value);
    }

    public boolean isAnnotationType(Type t) {
        return ((TypeImpl)t).isAnnotationType();
    }

    public boolean isSubtypeOfAnnotationBaseType(int t) {
        TypeImpl ti = this.getTypeFromCode(t);
        return ti == null ? false : ti.isAnnotationBaseType();
    }

    public boolean isBaseCas() {
        return this == this.getBaseCAS();
    }

    @Override
    public Annotation createAnnotation(Type type, int begin, int end) {
        Annotation fs = (Annotation)this.createFS(type);
        fs.setBegin(begin);
        fs.setEnd(end);
        return fs;
    }

    public int ll_createAnnotation(int typeCode, int begin, int end) {
        Annotation fs = this.createAnnotation(this.getTypeFromCode(typeCode), begin, end);
        this.set_id2fs(fs);
        return fs._id();
    }

    @Override
    public <T extends AnnotationFS> AnnotationIndex<T> getAnnotationIndex() {
        return this.indexRepository.getAnnotationIndex(this.getTypeSystemImpl().annotType);
    }

    @Override
    public <T extends AnnotationFS> AnnotationIndex<T> getAnnotationIndex(Type type) throws CASRuntimeException {
        return this.indexRepository.getAnnotationIndex((TypeImpl)type);
    }

    @Override
    public Type getAnnotationType() {
        return this.getTypeSystemImpl().annotType;
    }

    @Override
    public Feature getEndFeature() {
        return this.getTypeSystemImpl().endFeat;
    }

    @Override
    public Feature getBeginFeature() {
        return this.getTypeSystemImpl().startFeat;
    }

    private <T extends AnnotationFS> T createDocumentAnnotation(int length) {
        TypeSystemImpl ts = this.getTypeSystemImpl();
        Iterator it = this.getAnnotationIndex(ts.docType).iterator();
        ArrayList list = new ArrayList();
        while (it.isValid()) {
            list.add(it.get());
            it.moveToNext();
        }
        for (int i = 0; i < list.size(); ++i) {
            this.getIndexRepository().removeFS((FeatureStructure)list.get(i));
        }
        return this.createDocumentAnnotationNoRemove(length);
    }

    private <T extends Annotation> T createDocumentAnnotationNoRemove(int length) {
        T docAnnot = this.createDocumentAnnotationNoRemoveNoIndex(length);
        this.addFsToIndexes((FeatureStructure)docAnnot);
        return docAnnot;
    }

    public <T extends Annotation> T createDocumentAnnotationNoRemoveNoIndex(int length) {
        TypeSystemImpl ts = this.getTypeSystemImpl();
        Annotation docAnnot = this.createAnnotation(ts.docType, 0, length);
        docAnnot.setStringValue(ts.langFeat, "x-unspecified");
        return (T)docAnnot;
    }

    public int ll_createDocumentAnnotation(int length) {
        int fsRef = this.ll_createDocumentAnnotationNoIndex(0, length);
        this.ll_getIndexRepository().ll_addFS(fsRef);
        return fsRef;
    }

    public int ll_createDocumentAnnotationNoIndex(int begin, int end) {
        TypeSystemImpl ts = this.getTypeSystemImpl();
        int fsRef = this.ll_createAnnotation(ts.docType.getCode(), begin, end);
        this.ll_setStringValue(fsRef, ts.langFeat.getCode(), "x-unspecified");
        return fsRef;
    }

    public void updateDocumentAnnotation() {
        if (!this.mySofaIsValid() || this == this.svd.baseCAS) {
            return;
        }
        String newDoc = this.mySofaRef.getLocalStringData();
        if (null != newDoc) {
            Annotation docAnnot = (Annotation)this.getDocumentAnnotationNoCreate();
            if (docAnnot != null) {
                FSsTobeAddedback tobeAddedback = FSsTobeAddedback.createSingle();
                boolean wasRemoved = this.checkForInvalidFeatureSetting(docAnnot, this.getTypeSystemImpl().endFeat.getCode(), tobeAddedback);
                docAnnot._setIntValueNfc(endFeatAdjOffset, newDoc.length());
                if (wasRemoved) {
                    tobeAddedback.addback(docAnnot);
                }
            } else if (this.deserialized_doc_annot_not_indexed != null) {
                this.deserialized_doc_annot_not_indexed._setIntValueNfc(endFeatAdjOffset, newDoc.length());
            } else {
                this.createDocumentAnnotation(newDoc.length());
            }
        }
    }

    @Override
    public <T extends AnnotationFS> T getDocumentAnnotation() {
        T docAnnot = this.getDocumentAnnotationNoCreate();
        if (null == docAnnot) {
            return this.createDocumentAnnotationNoRemove(0);
        }
        return docAnnot;
    }

    public <T extends AnnotationFS> T getDocumentAnnotationNoCreate() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        FSIterator<Annotation> it = this.getDocAnnotIter();
        it.moveToFirst();
        if (it.isValid()) {
            Annotation r = it.get();
            return (T)(this.inPearContext() ? CASImpl.pearConvert(r) : r);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSIterator<Annotation> getDocAnnotIter() {
        if (this.docAnnotIter != null) {
            return this.docAnnotIter;
        }
        CASImpl cASImpl = this;
        synchronized (cASImpl) {
            if (this.docAnnotIter == null) {
                this.docAnnotIter = this.getAnnotationIndex(this.getTypeSystemImpl().docType).iterator();
            }
            return this.docAnnotIter;
        }
    }

    public int ll_getDocumentAnnotation() {
        Object r = this.getDocumentAnnotationNoCreate();
        return r == null ? 0 : r._id();
    }

    @Override
    public String getDocumentLanguage() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        return this.getDocumentAnnotation().getStringValue(this.getTypeSystemImpl().langFeat);
    }

    @Override
    public String getDocumentText() {
        return this.getSofaDataString();
    }

    @Override
    public String getSofaDataString() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        return this.mySofaIsValid() ? this.mySofaRef.getLocalStringData() : null;
    }

    @Override
    public FeatureStructure getSofaDataArray() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        return this.mySofaIsValid() ? this.mySofaRef.getLocalFSData() : null;
    }

    @Override
    public String getSofaDataURI() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        return this.mySofaIsValid() ? this.mySofaRef.getSofaURI() : null;
    }

    @Override
    public InputStream getSofaDataStream() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        return this.mySofaIsValid() ? this.getSofaDataStream(this.mySofaRef) : null;
    }

    @Override
    public String getSofaMimeType() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        return this.mySofaIsValid() ? this.mySofaRef.getSofaMime() : null;
    }

    @Override
    public Sofa getSofa() {
        return this.mySofaRef;
    }

    @Override
    public int ll_getSofa() {
        return this.mySofaIsValid() ? this.mySofaRef._id() : 0;
    }

    @Override
    public String getViewName() {
        return this == this.svd.getViewFromSofaNbr(1) ? "_InitialView" : (this.mySofaIsValid() ? this.mySofaRef.getSofaID() : null);
    }

    private boolean mySofaIsValid() {
        return this.mySofaRef != null;
    }

    void setDocTextFromDeserializtion(String text) {
        if (this.mySofaIsValid()) {
            Sofa sofa = this.getSofaRef();
            sofa.setLocalSofaDataNoDocAnnotUpdate(text);
        }
    }

    @Override
    public void setDocumentLanguage(String languageCode) {
        if (this == this.svd.baseCAS) {
            throw new CASRuntimeException("INVALID_BASE_CAS_METHOD", "setDocumentLanguage(String)");
        }
        Annotation docAnnot = (Annotation)this.getDocumentAnnotation();
        FeatureImpl languageFeature = this.getTypeSystemImpl().langFeat;
        languageCode = Language.normalize(languageCode);
        boolean wasRemoved = this.checkForInvalidFeatureSetting(docAnnot, languageFeature.getCode(), this.getAddbackSingle());
        docAnnot.setStringValue(this.getTypeSystemImpl().langFeat, languageCode);
        this.addbackSingleIfWasRemoved(wasRemoved, docAnnot);
    }

    private void setSofaThingsMime(Consumer<Sofa> c, String msg) {
        if (this == this.svd.baseCAS) {
            throw new CASRuntimeException("INVALID_BASE_CAS_METHOD", msg);
        }
        Sofa sofa = this.getSofaRef();
        c.accept(sofa);
    }

    @Override
    public void setDocumentText(String text) {
        this.setSofaDataString(text, "text");
    }

    @Override
    public void setSofaDataString(String text, String mime) throws CASRuntimeException {
        this.setSofaThingsMime(sofa -> sofa.setLocalSofaData(text, mime), "setSofaDataString(text, mime)");
    }

    @Override
    public void setSofaDataArray(FeatureStructure array, String mime) {
        this.setSofaThingsMime(sofa -> sofa.setLocalSofaData(array, mime), "setSofaDataArray(FeatureStructure, mime)");
    }

    @Override
    public void setSofaDataURI(String uri, String mime) throws CASRuntimeException {
        this.setSofaThingsMime(sofa -> sofa.setRemoteSofaURI(uri, mime), "setSofaDataURI(String, String)");
    }

    @Override
    public void setCurrentComponentInfo(ComponentInfo info) {
        this.svd.componentInfo = info;
    }

    ComponentInfo getCurrentComponentInfo() {
        return this.svd.componentInfo;
    }

    @Override
    public void addFsToIndexes(FeatureStructure fs) {
        this.indexRepository.addFS(fs);
    }

    @Override
    public void removeFsFromIndexes(FeatureStructure fs) {
        this.indexRepository.removeFS(fs);
    }

    public CASImpl getSofaCasView(AnnotationBase fs) {
        return fs._casView;
    }

    @Override
    public CASImpl ll_getSofaCasView(int id) {
        return this.getSofaCasView((AnnotationBase)this.getFsFromId_checked(id));
    }

    public int getNumberOfViews() {
        CASImpl initialView = this.getInitialView();
        int nbrSofas = ((SharedViewData)this.svd).baseCAS.indexRepository.getIndex("SofaIndex").size();
        return initialView.mySofaIsValid() ? nbrSofas : 1 + nbrSofas;
    }

    public int getNumberOfSofas() {
        return ((SharedViewData)this.svd).baseCAS.indexRepository.getIndex("SofaIndex").size();
    }

    @Override
    public <T extends CAS> Iterator<T> getViewIterator() {
        return new Iterator<T>(){
            final CASImpl initialView;
            boolean isInitialView_but_noSofa;
            final FSIterator<Sofa> sofaIter;
            {
                this.initialView = CASImpl.this.getInitialView();
                this.isInitialView_but_noSofa = !this.initialView.mySofaIsValid();
                this.sofaIter = CASImpl.this.getSofaIterator();
            }

            @Override
            public boolean hasNext() {
                if (this.isInitialView_but_noSofa) {
                    return true;
                }
                return this.sofaIter.hasNext();
            }

            @Override
            public T next() {
                if (this.isInitialView_but_noSofa) {
                    this.isInitialView_but_noSofa = false;
                    return this.initialView;
                }
                return CASImpl.this.getView((SofaFS)this.sofaIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<CASImpl> getViewImplIterator() {
        return new Iterator<CASImpl>(){
            final CASImpl initialView;
            boolean isInitialView_but_noSofa;
            final FSIterator<Sofa> sofaIter;
            {
                this.initialView = CASImpl.this.getInitialView();
                this.isInitialView_but_noSofa = !this.initialView.mySofaIsValid();
                this.sofaIter = CASImpl.this.getSofaIterator();
            }

            @Override
            public boolean hasNext() {
                if (this.isInitialView_but_noSofa) {
                    return true;
                }
                return this.sofaIter.hasNext();
            }

            @Override
            public CASImpl next() {
                if (this.isInitialView_but_noSofa) {
                    this.isInitialView_but_noSofa = false;
                    return this.initialView;
                }
                return CASImpl.this.getView((SofaFS)this.sofaIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void forAllViews(Consumer<CASImpl> processViews) {
        int numViews = this.getNumberOfViews();
        for (int viewNbr = 1; viewNbr <= numViews; ++viewNbr) {
            CASImpl view = viewNbr == 1 ? this.getInitialView() : (CASImpl)this.getView(viewNbr);
            processViews.accept(view);
        }
    }

    void forAllSofas(Consumer<Sofa> processSofa) {
        FSIterator it = this.getSofaIterator();
        while (it.hasNext()) {
            processSofa.accept((Sofa)it.nextNvc());
        }
    }

    void forAllIndexRepos(Consumer<FSIndexRepositoryImpl> processIr) {
        int numViews = this.getViewCount();
        for (int viewNum = 1; viewNum <= numViews; ++viewNum) {
            processIr.accept(this.getSofaIndexRepository(viewNum));
        }
    }

    @Override
    public Iterator<CAS> getViewIterator(String localViewNamePrefix) {
        String absolutePrefix = null;
        if (this.getCurrentComponentInfo() != null) {
            absolutePrefix = this.getCurrentComponentInfo().mapToSofaID(localViewNamePrefix);
        }
        if (absolutePrefix == null) {
            absolutePrefix = localViewNamePrefix;
        }
        ArrayList<CASImpl> viewList = new ArrayList<CASImpl>();
        FSIterator sofaIter = this.getSofaIterator();
        while (sofaIter.hasNext()) {
            SofaFS sofa = (SofaFS)sofaIter.next();
            String sofaId = sofa.getSofaID();
            if (!sofaId.startsWith(absolutePrefix) || sofaId.length() != absolutePrefix.length() && sofaId.charAt(absolutePrefix.length()) != '.') continue;
            viewList.add(this.getView(sofa));
        }
        return viewList.iterator();
    }

    @Override
    public AutoCloseableNoException protectIndexes() {
        FSsTobeAddedback r = FSsTobeAddedback.createMultiple(this);
        this.svd.fssTobeAddedback.add(r);
        return r;
    }

    void dropProtectIndexesLevel() {
        if (this.svd.fssTobeAddedback.isEmpty()) {
            return;
        }
        this.svd.fssTobeAddedback.remove(this.svd.fssTobeAddedback.size() - 1);
    }

    void addbackModifiedFSs(FSsTobeAddedback addbacks) {
        ArrayList listOfAddbackInfos = this.svd.fssTobeAddedback;
        if (listOfAddbackInfos.get(listOfAddbackInfos.size() - 1) == addbacks) {
            listOfAddbackInfos.remove(listOfAddbackInfos.size() - 1);
            addbacks.addback();
            return;
        }
        int pos = listOfAddbackInfos.indexOf(addbacks);
        if (pos >= 0) {
            for (int i = listOfAddbackInfos.size() - 1; i >= pos; --i) {
                FSsTobeAddedback toAddBack = (FSsTobeAddedback)listOfAddbackInfos.remove(i);
                toAddBack.addback();
            }
            return;
        }
        addbacks.addback();
    }

    @Override
    public void protectIndexes(Runnable r) {
        AutoCloseableNoException addbacks = this.protectIndexes();
        try {
            r.run();
        }
        finally {
            this.addbackModifiedFSs((FSsTobeAddedback)addbacks);
        }
    }

    @Override
    public Marker createMarker() {
        if (this.isCasLocked()) {
            throw new CASAdminException("FLUSH_DISABLED", new Object[0]);
        }
        this.svd.trackingMark = new MarkerImpl(this.getLastUsedFsId() + 1, this);
        if (this.svd.modifiedPreexistingFSs == null) {
            this.svd.modifiedPreexistingFSs = new IdentityHashMap();
        }
        if (this.svd.modifiedPreexistingFSs.size() > 0) {
            this.errorMultipleMarkers();
        }
        if (this.svd.trackingMarkList == null) {
            this.svd.trackingMarkList = new ArrayList();
        } else {
            this.errorMultipleMarkers();
        }
        this.svd.trackingMarkList.add(this.svd.trackingMark);
        return this.svd.trackingMark;
    }

    private void errorMultipleMarkers() {
        throw new CASRuntimeException("MULTIPLE_CREATE_MARKER", new Object[0]);
    }

    public MarkerImpl getCurrentMark() {
        return this.svd.trackingMark;
    }

    FsChange[] getModifiedFSList() {
        Map mods = this.svd.modifiedPreexistingFSs;
        FsChange[] r = mods.values().toArray(new FsChange[mods.size()]);
        Arrays.sort(r, 0, mods.size(), (c1, c2) -> Integer.compare(c1.fs._id, c2.fs._id));
        return r;
    }

    boolean isInModifiedPreexisting(TOP fs) {
        return this.svd.modifiedPreexistingFSs.containsKey(fs);
    }

    public String toString() {
        String sofa = this.mySofaRef == null ? (this.isBaseCas() ? "Base CAS" : "_InitialView or no Sofa") : this.mySofaRef.getSofaID();
        return this.getClass().getSimpleName() + ":" + this.getCasId() + "[view: " + sofa + "]";
    }

    public int getCasResets() {
        return this.svd.casResets.get();
    }

    public String getCasId() {
        return this.svd.casId;
    }

    public final int getNextFsId(TOP fs) {
        return this.svd.getNextFsId(fs);
    }

    public void adjustLastFsV2Size_arrays(int arrayLength) {
        SharedViewData sharedViewData = this.svd;
        sharedViewData.lastFsV2Size = sharedViewData.lastFsV2Size + (1 + arrayLength);
    }

    public void adjustLastFsV2size_nonHeapStoredArrays() {
        SharedViewData sharedViewData = this.svd;
        sharedViewData.lastFsV2Size = sharedViewData.lastFsV2Size + 2;
    }

    public void setId2FSsMaybeUnconditionally(FeatureStructure ... fss) {
        for (FeatureStructure fs : fss) {
            this.setId2FsMaybeUnconditionally((TOP)fs);
        }
    }

    private void setId2FsMaybeUnconditionally(TOP fs) {
        if (this.svd.isId2Fs) {
            this.svd.id2fs.putUnconditionally(fs);
        } else {
            this.set_id2fs(fs);
        }
    }

    public final int getLastUsedFsId() {
        return this.svd.fsIdGenerator;
    }

    public final int peekNextFsId() {
        return this.svd.peekNextFsId();
    }

    public final int lastV2IdIncr() {
        return this.svd.lastFsV2IdIncr();
    }

    public final void captureLastFsIdForOtherThread() {
        this.svd.fsIdLastValue.set(this.svd.fsIdGenerator);
    }

    public <T extends TOP> T getFsFromId(int id) {
        return (T)this.svd.id2fs.get(id);
    }

    public List<TOP> walkReachablePlusFSsSorted(Consumer<TOP> action_filtered, MarkerImpl mark, Predicate<TOP> includeFilter, CasTypeSystemMapper typeMapper) {
        ArrayList<TOP> all = new AllFSs(this, mark, includeFilter, typeMapper).getAllFSsAllViews_sofas_reachable().getAllFSsSorted();
        List<TOP> filtered = CASImpl.filterAboveMark(all, mark);
        if (action_filtered != null) {
            for (TOP fs : filtered) {
                action_filtered.accept(fs);
            }
        }
        return all;
    }

    static List<TOP> filterAboveMark(List<TOP> all, MarkerImpl mark) {
        if (null == mark) {
            return all;
        }
        int c = Collections.binarySearch(all, TOP._createSearchKey(mark.nextFSId), (fs1, fs2) -> Integer.compare(fs1._id, fs2._id));
        if (c < 0) {
            c = -c - 1;
        }
        return all.subList(c, all.size());
    }

    public static final boolean isSameCAS(CAS c1, CAS c2) {
        CASImpl ci1 = (CASImpl)c1.getLowLevelCAS();
        CASImpl ci2 = (CASImpl)c2.getLowLevelCAS();
        return ci1.getBaseCAS() == ci2.getBaseCAS();
    }

    public boolean isInCAS(FeatureStructure fs) {
        return ((TOP)fs)._casView.getBaseCAS() == this.getBaseCAS();
    }

    public final void checkArrayPreconditions(int len) throws CASRuntimeException {
        if (len < 0) {
            throw new CASRuntimeException("ILLEGAL_ARRAY_SIZE", new Object[0]);
        }
    }

    @Override
    public <T extends TOP> EmptyFSList<T> emptyFSList() {
        if (null == this.svd.emptyFSList) {
            this.svd.emptyFSList = new EmptyFSList(this.getTypeSystemImpl().fsEListType, this);
        }
        return this.svd.emptyFSList;
    }

    @Override
    public EmptyFloatList emptyFloatList() {
        if (null == this.svd.emptyFloatList) {
            this.svd.emptyFloatList = new EmptyFloatList(this.getTypeSystemImpl().floatEListType, this);
        }
        return this.svd.emptyFloatList;
    }

    @Override
    public EmptyIntegerList emptyIntegerList() {
        if (null == this.svd.emptyIntegerList) {
            this.svd.emptyIntegerList = new EmptyIntegerList(this.getTypeSystemImpl().intEListType, this);
        }
        return this.svd.emptyIntegerList;
    }

    @Override
    public EmptyStringList emptyStringList() {
        if (null == this.svd.emptyStringList) {
            this.svd.emptyStringList = new EmptyStringList(this.getTypeSystemImpl().stringEListType, this);
        }
        return this.svd.emptyStringList;
    }

    public CommonArrayFS emptyArray(Type type) {
        switch (((TypeImpl)type).getCode()) {
            case 28: {
                return this.emptyBooleanArray();
            }
            case 29: {
                return this.emptyByteArray();
            }
            case 30: {
                return this.emptyShortArray();
            }
            case 8: {
                return this.emptyIntegerArray();
            }
            case 7: {
                return this.emptyFloatArray();
            }
            case 31: {
                return this.emptyLongArray();
            }
            case 32: {
                return this.emptyDoubleArray();
            }
            case 9: {
                return this.emptyStringArray();
            }
        }
        return this.emptyFSArray();
    }

    @Override
    public FloatArray emptyFloatArray() {
        if (null == this.svd.emptyFloatArray) {
            this.svd.emptyFloatArray = new FloatArray(this.getJCas(), 0);
        }
        return this.svd.emptyFloatArray;
    }

    @Override
    public <T extends FeatureStructure> FSArray<T> emptyFSArray() {
        return this.emptyFSArray(null);
    }

    @Override
    public <T extends FeatureStructure> FSArray<T> emptyFSArray(Type type) {
        return this.svd.emptyFSArrayMap.computeIfAbsent(type, t -> t == null ? new FSArray(this.getJCas(), 0) : new FSArray((TypeImpl)this.getTypeSystemImpl().getArrayType(type), this, 0));
    }

    @Override
    public IntegerArray emptyIntegerArray() {
        if (null == this.svd.emptyIntegerArray) {
            this.svd.emptyIntegerArray = new IntegerArray(this.getJCas(), 0);
        }
        return this.svd.emptyIntegerArray;
    }

    @Override
    public StringArray emptyStringArray() {
        if (null == this.svd.emptyStringArray) {
            this.svd.emptyStringArray = new StringArray(this.getJCas(), 0);
        }
        return this.svd.emptyStringArray;
    }

    @Override
    public DoubleArray emptyDoubleArray() {
        if (null == this.svd.emptyDoubleArray) {
            this.svd.emptyDoubleArray = new DoubleArray(this.getJCas(), 0);
        }
        return this.svd.emptyDoubleArray;
    }

    @Override
    public LongArray emptyLongArray() {
        if (null == this.svd.emptyLongArray) {
            this.svd.emptyLongArray = new LongArray(this.getJCas(), 0);
        }
        return this.svd.emptyLongArray;
    }

    @Override
    public ShortArray emptyShortArray() {
        if (null == this.svd.emptyShortArray) {
            this.svd.emptyShortArray = new ShortArray(this.getJCas(), 0);
        }
        return this.svd.emptyShortArray;
    }

    @Override
    public ByteArray emptyByteArray() {
        if (null == this.svd.emptyByteArray) {
            this.svd.emptyByteArray = new ByteArray(this.getJCas(), 0);
        }
        return this.svd.emptyByteArray;
    }

    @Override
    public BooleanArray emptyBooleanArray() {
        if (null == this.svd.emptyBooleanArray) {
            this.svd.emptyBooleanArray = new BooleanArray(this.getJCas(), 0);
        }
        return this.svd.emptyBooleanArray;
    }

    public EmptyList emptyList(int rangeCode) {
        return rangeCode == 101 ? this.emptyIntegerList() : (rangeCode == 102 ? this.emptyFloatList() : (rangeCode == 103 ? this.emptyStringList() : this.emptyFSList()));
    }

    public EmptyList emptyListFromTypeCode(int typeCode) {
        switch (typeCode) {
            case 11: 
            case 12: 
            case 13: {
                return this.emptyFSList();
            }
            case 14: 
            case 15: 
            case 16: {
                return this.emptyFloatList();
            }
            case 17: 
            case 18: 
            case 19: {
                return this.emptyIntegerList();
            }
            case 20: 
            case 21: 
            case 22: {
                return this.emptyStringList();
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean copyFeatureExceptFsRef(TOP fsSrc, FeatureImpl fiSrc, TOP fsTgt, FeatureImpl fiTgt) {
        switch (fiSrc.getRangeImpl().getCode()) {
            case 23: {
                fsTgt._setBooleanValueNcNj(fiTgt, fsSrc._getBooleanValueNc(fiSrc));
                break;
            }
            case 24: {
                fsTgt._setByteValueNcNj(fiTgt, fsSrc._getByteValueNc(fiSrc));
                break;
            }
            case 25: {
                fsTgt._setShortValueNcNj(fiTgt, fsSrc._getShortValueNc(fiSrc));
                break;
            }
            case 2: {
                fsTgt._setIntValueNcNj(fiTgt, fsSrc._getIntValueNc(fiSrc));
                break;
            }
            case 26: {
                fsTgt._setLongValueNcNj(fiTgt, fsSrc._getLongValueNc(fiSrc));
                break;
            }
            case 3: {
                fsTgt._setFloatValueNcNj(fiTgt, fsSrc._getFloatValueNc(fiSrc));
                break;
            }
            case 27: {
                fsTgt._setDoubleValueNcNj(fiTgt, fsSrc._getDoubleValueNc(fiSrc));
                break;
            }
            case 4: {
                fsTgt._setStringValueNcNj(fiTgt, fsSrc._getStringValueNc(fiSrc));
                break;
            }
            default: {
                if (fiSrc.getRangeImpl().isStringSubtype()) {
                    fsTgt._setStringValueNcNj(fiTgt, fsSrc._getStringValueNc(fiSrc));
                    break;
                }
                return false;
            }
        }
        return true;
    }

    public static CommonArrayFS copyArray(TOP srcArray) {
        CommonArrayFS srcCA = (CommonArrayFS)((Object)srcArray);
        CommonArrayFS copy = (CommonArrayFS)((Object)srcArray._casView.createArray(srcArray._getTypeImpl(), srcCA.size()));
        copy.copyValuesFrom(srcCA);
        return copy;
    }

    public BinaryCasSerDes getBinaryCasSerDes() {
        return this.svd.bcsd;
    }

    CommonSerDesSequential getCsds() {
        return this.svd.csds;
    }

    void setCsds(CommonSerDesSequential csds) {
        this.svd.csds = csds;
    }

    CommonSerDesSequential newCsds() {
        return this.svd.csds = new CommonSerDesSequential(this.getBaseCAS());
    }

    public void deltaMergesComplete() {
        this.svd.csds = null;
    }

    static <T extends FeatureStructure> T pearConvert(T aFs) {
        if (null == aFs) {
            return null;
        }
        TOP fs = (TOP)aFs;
        CASImpl view = fs._casView;
        TypeImpl ti = fs._getTypeImpl();
        FsGenerator3 generator = view.svd.generators[ti.getCode()];
        if (null == generator) {
            return aFs;
        }
        return (T)view.pearConvert(fs, generator);
    }

    private TOP pearConvert(TOP fs, FsGenerator3 g) {
        return this.svd.id2tramp.putIfAbsent(fs._id, k -> {
            TOP r;
            this.svd.reuseId = k;
            this.pearBaseFs = fs;
            try {
                r = g.createFS(fs._getTypeImpl(), this);
            }
            finally {
                this.svd.reuseId = 0;
                this.pearBaseFs = null;
            }
            assert (r != null);
            if (r instanceof UimaSerializable) {
                throw new UnsupportedOperationException("Pears with Alternate implementations of JCas classes implementing UimaSerializable not supported.");
            }
            return r;
        });
    }

    <T extends TOP> T getBaseFsFromTrampoline(T fs) {
        TOP r = this.svd.id2base.get(fs._id);
        assert (r != null);
        return (T)r;
    }

    public void traceFSCreate(FeatureStructureImplC fs) {
        StringBuilder b = this.svd.traceFScreationSb;
        if (b.length() > 0) {
            this.traceFSflush();
        }
        this.svd.id2addr.add(this.svd.nextId2Addr);
        SharedViewData sharedViewData = this.svd;
        sharedViewData.nextId2Addr = sharedViewData.nextId2Addr + fs._getTypeImpl().getFsSpaceReq((TOP)fs);
        this.traceFSfs(fs);
        this.svd.traceFSisCreate = true;
        if (fs._getTypeImpl().isArray()) {
            b.append(" l:").append(((CommonArrayFS)((Object)fs)).size());
        }
    }

    void traceFSfs(FeatureStructureImplC fs) {
        StringBuilder b = this.svd.traceFScreationSb;
        this.svd.traceFSid = fs._id;
        b.append("c:").append(String.format("%-3s", this.getCasId()));
        String viewName = fs._casView.getViewName();
        if (null == viewName) {
            viewName = "base";
        }
        b.append(" v:").append(Misc.elide(viewName, 8));
        b.append(" i:").append(String.format("%-5s", this.geti2addr(fs._id)));
        b.append(" t:").append(Misc.elide(fs._getTypeImpl().getShortName(), 10));
    }

    void traceIndexMod(boolean isAdd, TOP fs, boolean isAddbackOrSkipBag) {
        StringBuilder b = this.svd.traceCowSb;
        b.setLength(0);
        b.append(isAdd ? (isAddbackOrSkipBag ? "abk_idx " : "add_idx ") : (isAddbackOrSkipBag ? "rmv_auto_idx " : "rmv_norm_idx "));
        b.append(fs._getTypeImpl().getShortName()).append(":").append(fs._id);
        if (fs instanceof Annotation) {
            Annotation ann = (Annotation)fs;
            b.append(" begin: ").append(ann.getBegin());
            b.append(" end: ").append(ann.getEnd());
            b.append(" txt: \"").append(Misc.elide(ann.getCoveredText(), 10)).append("\"");
        }
        traceOut.println(b);
    }

    void traceCowCopy(FsIndex_singletype<?> index) {
        StringBuilder b = this.svd.traceCowSb;
        b.setLength(0);
        b.append("cow-copy:");
        b.append(" i: ").append(index);
        traceOut.println(b);
    }

    void traceCowCopyUse(FsIndex_singletype<?> index) {
        StringBuilder b = this.svd.traceCowSb;
        b.setLength(0);
        b.append("cow-copy-used:");
        b.append(" i: ").append(index);
        traceOut.println(b);
    }

    void traceCowReinit(String kind, FsIndex_singletype<?> index) {
        StringBuilder b = this.svd.traceCowSb;
        b.setLength(0);
        b.append("cow-redo: ");
        b.append(kind);
        b.append(" i: ").append(index);
        b.append(" c: ");
        b.append(Misc.getCaller());
        traceOut.println(b);
    }

    void traceFSfeat(FeatureStructureImplC fs, FeatureImpl fi, Object v) {
        FeatureImpl originalFi = fi;
        StringBuilder b = this.svd.traceFScreationSb;
        assert (b.length() > 0);
        if (fs._id != this.svd.traceFSid) {
            this.traceFSfeatUpdate(fs);
        }
        if (fi == null) {
            switch (this.prevFi.getSlotKind()) {
                case Slot_DoubleRef: {
                    v = fs._getDoubleValueNc(this.prevFi);
                    break;
                }
                case Slot_LongRef: {
                    v = fs._getLongValueNc(this.prevFi);
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
            fi = this.prevFi;
            this.prevFi = null;
        } else {
            this.prevFi = fi;
        }
        String fn = fi.getShortName();
        if (fi.getSlotKind() == SlotKinds.SlotKind.Slot_DoubleRef) {
            if (v instanceof Integer) {
                return;
            }
            if (v instanceof Long) {
                v = CASImpl.long2double((Long)v);
            }
        }
        if (fi.getSlotKind() == SlotKinds.SlotKind.Slot_LongRef && v instanceof Integer) {
            return;
        }
        String fv = this.getTraceRepOfObj(fi, v);
        int i_v = Math.max(0, 10 - fn.length());
        int i_n = Math.max(0, 10 - fv.length());
        fn = Misc.elide(fn, 10 + i_n, false);
        fv = Misc.elide(fv, 10 + i_v, false);
        b.append(' ').append(Misc.elide(fn + ':' + fv, 21));
    }

    private String getTraceRepOfObj(FeatureImpl fi, Object v) {
        if (v instanceof TOP) {
            TOP fs = (TOP)v;
            return Misc.elide(fs.getType().getShortName(), 5, false) + ':' + this.geti2addr(fs._id);
        }
        if (v == null) {
            return "null";
        }
        if (v instanceof String) {
            String s = Misc.elide((String)v, 50, false);
            return Misc.replaceWhiteSpace(s, "_");
        }
        if (v instanceof Integer) {
            int iv = (Integer)v;
            switch (fi.getSlotKind()) {
                case Slot_Boolean: {
                    return iv == 1 ? "true" : "false";
                }
                case Slot_Byte: 
                case Slot_Short: 
                case Slot_Int: {
                    return Integer.toString(iv);
                }
                case Slot_Float: {
                    return Float.toString(CASImpl.int2float(iv));
                }
            }
        }
        if (v instanceof Long) {
            long vl = (Long)v;
            return fi.getSlotKind() == SlotKinds.SlotKind.Slot_DoubleRef ? Double.toString(CASImpl.long2double(vl)) : Long.toString(vl);
        }
        return Misc.replaceWhiteSpace(v.toString(), "_");
    }

    private String geti2addr(int id) {
        if (id >= this.svd.id2addr.size()) {
            return Integer.toString(id) + '!';
        }
        return Integer.toString(this.svd.id2addr.get(id));
    }

    void traceFSfeatUpdate(FeatureStructureImplC fs) {
        this.traceFSflush();
        this.traceFSfs(fs);
        this.svd.traceFSisCreate = false;
    }

    public StringBuilder traceFSflush() {
        if (!traceFSs) {
            return null;
        }
        StringBuilder b = this.svd.traceFScreationSb;
        if (b.length() > 0) {
            traceOut.println((this.svd.traceFSisCreate ? "cr: " : "up: ") + b);
            b.setLength(0);
            this.svd.traceFSisCreate = false;
        }
        return b;
    }

    @Override
    @Deprecated
    public void setCAS(CAS cas) {
    }

    boolean inPearContext() {
        return this.svd.previousJCasClassLoader != null;
    }

    private void suspendPearContext() {
        this.svd.suspendPreviousJCasClassLoader = this.svd.previousJCasClassLoader;
        this.svd.previousJCasClassLoader = null;
    }

    private void restorePearContext() {
        this.svd.previousJCasClassLoader = this.svd.suspendPreviousJCasClassLoader;
    }

    public int getInitialHeapSize() {
        return this.svd.initialHeapSize;
    }

    public void reinit(CASSerializer ser) {
        this.svd.bcsd.reinit(ser);
    }

    public void reinit(CASCompleteSerializer casCompSer) {
        this.svd.bcsd.reinit(casCompSer);
    }

    public SerialFormat reinit(InputStream istream) throws CASRuntimeException {
        return this.svd.bcsd.reinit(istream);
    }

    void maybeHoldOntoFS(FeatureStructureImplC fs) {
        if (this.svd.isId2Fs) {
            this.svd.id2fs.put((TOP)fs);
        }
    }

    public void swapInPearVersion(Object[] a) {
        if (!this.inPearContext()) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            Object ao = a[i];
            if (!(ao instanceof TOP)) continue;
            a[i] = CASImpl.pearConvert((TOP)ao);
        }
    }

    public Collection<?> collectNonPearVersions(Collection<?> c) {
        if (c.size() == 0 || !this.inPearContext()) {
            return c;
        }
        ArrayList<TOP> items = new ArrayList<TOP>(c.size());
        for (Object o : c) {
            if (!(o instanceof TOP)) continue;
            items.add(CASImpl.pearConvert((TOP)o));
        }
        return items;
    }

    public <T> Spliterator<T> makePearAware(final Spliterator<T> baseSi) {
        if (!this.inPearContext()) {
            return baseSi;
        }
        return new Spliterator<T>(){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                return baseSi.tryAdvance(item -> action.accept(item instanceof TOP ? CASImpl.pearConvert((TOP)item) : item));
            }

            @Override
            public Spliterator<T> trySplit() {
                return baseSi.trySplit();
            }

            @Override
            public long estimateSize() {
                return baseSi.estimateSize();
            }

            @Override
            public int characteristics() {
                return baseSi.characteristics();
            }
        };
    }

    @Override
    public boolean is_ll_enableV2IdRefs() {
        return this.svd.isId2Fs;
    }

    @Override
    public AutoCloseableNoException ll_enableV2IdRefs(boolean enable) {
        boolean restoreState = this.svd.isId2Fs;
        if (enable && !restoreState && this.svd.fsIdGenerator != 0) {
            throw new IllegalStateException("CAS must be empty when switching to V2 ID References mode.");
        }
        AutoCloseableNoException r = () -> this.svd.isId2Fs = restoreState;
        this.svd.isId2Fs = enable;
        return r;
    }

    AutoCloseableNoException ll_forceEnableV2IdRefs(boolean enable) {
        boolean restoreState = this.svd.isId2Fs;
        AutoCloseableNoException r = () -> this.svd.isId2Fs = restoreState;
        this.svd.isId2Fs = enable;
        return r;
    }

    public void set_deserialized_doc_annot_not_indexed(Annotation doc_annot) {
        this.deserialized_doc_annot_not_indexed = doc_annot;
    }

    private static /* synthetic */ void lambda$static$13() {
        System.out.println("debug Switch Types dump, # entries: " + measureSwitches.size());
        int s1 = 0;
        int s2 = 0;
        int s3 = 0;
        for (MeasureSwitchType mst : measureSwitches.keySet()) {
            s1 = Math.max(s1, mst.oldType.getName().length());
            s2 = Math.max(s2, mst.newType.getName().length());
            s3 = Math.max(s3, mst.oldJCasClassName.length());
        }
        for (MeasureSwitchType mst : measureSwitches.keySet()) {
            System.out.format("count: %,6d scantime = %,7d ms,  subsumes: %s %s,   type: %-" + s1 + "s  newType: %-" + s2 + "s,  cl: %-" + s3 + "s, newCl: %s%n", mst.count, mst.scantime / 1000000L, mst.newSubsumesOld ? "n>o" : "   ", mst.oldSubsumesNew ? "o>w" : "   ", mst.oldType.getName(), mst.newType.getName(), mst.oldJCasClassName, mst.newJCasClassName);
        }
    }

    static {
        try {
            if (traceFSs) {
                System.out.println("Creating traceFSs file in directory " + System.getProperty("user.dir"));
                traceOut = traceFSs ? new PrintStream(new BufferedOutputStream(new FileOutputStream(traceFile, false))) : null;
            } else {
                traceOut = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        casIdProvider = new AtomicInteger(0);
        IS_THROW_EXCEPTION_CORRUPT_INDEX = Misc.getNoValueSystemProperty(THROW_EXCEPTION_FS_UPDATES_CORRUPTS);
        IS_REPORT_FS_UPDATE_CORRUPTS_INDEX = IS_THROW_EXCEPTION_CORRUPT_INDEX || Misc.getNoValueSystemProperty(REPORT_FS_UPDATES_CORRUPTS);
        IS_DISABLED_PROTECT_INDEXES = Misc.getNoValueSystemProperty(DISABLE_PROTECT_INDEXES) && !IS_REPORT_FS_UPDATE_CORRUPTS_INDEX && !IS_THROW_EXCEPTION_CORRUPT_INDEX;
        IS_ALWAYS_HOLD_ONTO_FSS = Misc.getNoValueSystemProperty(ALWAYS_HOLD_ONTO_FSS);
        new DebugNameValuePair(null, null);
        new DebugFSLogicalStructure();
        defaultV2IdRefs = InheritableThreadLocal.withInitial(() -> null);
        strictTypeSourceCheckMessageCount = new AtomicInteger(0);
        measureSwitches = new HashMap<MeasureSwitchType, MeasureSwitchType>();
        if (traceFSs) {
            Runtime.getRuntime().addShutdownHook(new Thread(null, () -> {
                System.out.println("closing traceOut");
                traceOut.close();
            }, "close trace output"));
        }
    }

    private static class MeasureSwitchType {
        TypeImpl oldType;
        TypeImpl newType;
        String oldJCasClassName;
        String newJCasClassName;
        int count = 0;
        boolean newSubsumesOld;
        boolean oldSubsumesNew;
        long scantime = 0L;

        MeasureSwitchType(TypeImpl oldType, TypeImpl newType) {
            this.oldType = oldType;
            this.oldJCasClassName = oldType.getJavaClass().getName();
            this.newType = newType;
            this.newJCasClassName = newType.getJavaClass().getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.newJCasClassName == null ? 0 : this.newJCasClassName.hashCode());
            result = 31 * result + (this.newType == null ? 0 : this.newType.hashCode());
            result = 31 * result + (this.oldJCasClassName == null ? 0 : this.oldJCasClassName.hashCode());
            result = 31 * result + (this.oldType == null ? 0 : this.oldType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MeasureSwitchType)) {
                return false;
            }
            MeasureSwitchType other = (MeasureSwitchType)obj;
            if (this.newJCasClassName == null ? other.newJCasClassName != null : !this.newJCasClassName.equals(other.newJCasClassName)) {
                return false;
            }
            if (this.newType == null ? other.newType != null : !this.newType.equals(other.newType)) {
                return false;
            }
            if (this.oldJCasClassName == null ? other.oldJCasClassName != null : !this.oldJCasClassName.equals(other.oldJCasClassName)) {
                return false;
            }
            return !(this.oldType == null ? other.oldType != null : !this.oldType.equals(other.oldType));
        }
    }

    static class SharedViewData {
        private final Id2FS id2fs;
        private int reuseId = 0;
        private final CASImpl baseCAS;
        private final BitSet featureCodesInIndexKeys = new BitSet(1024);
        ArrayList<FSIndexRepositoryImpl> sofa2indexMap;
        ArrayList<CASImpl> sofaNbr2ViewMap;
        private Set<String> sofaNameSet;
        private boolean initialSofaCreated = false;
        int viewCount;
        private ClassLoader jcasClassLoader = this.getClass().getClassLoader();
        private ClassLoader previousJCasClassLoader = null;
        private ClassLoader suspendPreviousJCasClassLoader;
        private JCasHashMap id2tramp = null;
        private JCasHashMap id2base = null;
        private final Map<ClassLoader, JCasHashMap> cl2id2tramp = new IdentityHashMap<ClassLoader, JCasHashMap>();
        private FsGenerator3[] generators;
        private FsGenerator3[] baseGenerators;
        private boolean flushEnabled = true;
        private TypeSystemImpl tsi;
        private ComponentInfo componentInfo;
        private MarkerImpl trackingMark;
        private Map<TOP, FsChange> modifiedPreexistingFSs;
        private List<MarkerImpl> trackingMarkList;
        private final ArrayList<FSsTobeAddedback> fssTobeAddedback = new ArrayList();
        private final FSsTobeAddedback.FSsTobeAddedbackSingle fsTobeAddedbackSingle = (FSsTobeAddedback.FSsTobeAddedbackSingle)FSsTobeAddedback.createSingle();
        boolean fsTobeAddedbackSingleInUse = false;
        boolean disableAutoCorruptionCheck = false;
        private int fsIdGenerator = 0;
        private int lastFsV2Size = 1;
        AtomicInteger fsIdLastValue = new AtomicInteger(0);
        private final AtomicInteger casResets = new AtomicInteger(0);
        private final String casId = String.valueOf(casIdProvider.incrementAndGet());
        private EmptyFSList emptyFSList;
        private EmptyFloatList emptyFloatList;
        private EmptyIntegerList emptyIntegerList;
        private EmptyStringList emptyStringList;
        private FloatArray emptyFloatArray;
        private final Map<Type, FSArray> emptyFSArrayMap = new HashMap<Type, FSArray>();
        private IntegerArray emptyIntegerArray;
        private StringArray emptyStringArray;
        private DoubleArray emptyDoubleArray;
        private LongArray emptyLongArray;
        private ShortArray emptyShortArray;
        private ByteArray emptyByteArray;
        private BooleanArray emptyBooleanArray;
        private final BinaryCasSerDes bcsd;
        private CommonSerDesSequential csds;
        private StringSet llstringSet = null;
        private LongSet lllongSet = null;
        private final StringBuilder traceFScreationSb = traceFSs ? new StringBuilder() : null;
        private final StringBuilder traceCowSb = null;
        private int traceFSid = 0;
        private boolean traceFSisCreate;
        private final IntVector id2addr = traceFSs ? new IntVector() : null;
        private int nextId2Addr = 1;
        private final int initialHeapSize;
        private boolean isId2Fs;
        private final Deque<SwitchControl> switchControl = new ArrayDeque<SwitchControl>();
        private final EnumSet<CasState> casState = EnumSet.noneOf(CasState.class);
        private static final MethodType noArgBoolean = MethodType.methodType(Boolean.TYPE);
        private static final MethodHandle mh_return_false;
        private static final MethodHandle mh_return_true;
        private final MutableCallSite is_updatable_callsite = new MutableCallSite(mh_return_true);
        private final MutableCallSite is_readable_callsite = new MutableCallSite(mh_return_true);
        private final MethodHandle is_updatable = this.is_updatable_callsite.dynamicInvoker();
        private final MethodHandle is_readable = this.is_readable_callsite.dynamicInvoker();
        private final MutableCallSite[] is_updatable_callsites = new MutableCallSite[]{this.is_updatable_callsite};
        private final MutableCallSite[] is_readable_callsites = new MutableCallSite[]{this.is_readable_callsite};
        private volatile Thread current_one_thread_access = null;

        private void updateCallSite(boolean desired_state, MethodHandle tester, MutableCallSite c, MethodHandle mh, MutableCallSite[] cs) {
            try {
                if (tester.invokeExact() != desired_state) {
                    c.setTarget(mh);
                    MutableCallSite.syncAll(cs);
                }
            }
            catch (Throwable e) {
                Misc.internalError(e);
            }
        }

        private synchronized boolean setCasState(CasState state, Thread thread) {
            boolean wasAdded = this.casState.add(state);
            if (wasAdded || state == CasState.NO_ACCESS && thread != this.current_one_thread_access) {
                switch (state) {
                    case READ_ONLY: {
                        if (this.casState.contains((Object)CasState.NO_ACCESS)) break;
                        this.updateCallSite(false, this.is_updatable, this.is_updatable_callsite, mh_return_false, this.is_updatable_callsites);
                        break;
                    }
                    case NO_ACCESS: {
                        this.current_one_thread_access = thread;
                        MethodHandle mh = CasState.produce_one_thread_access_test(thread);
                        boolean b = true;
                        try {
                            b = mh.invokeExact();
                        }
                        catch (Throwable e) {
                            Misc.internalError(e);
                        }
                        this.updateCallSite(b, this.is_updatable, this.is_updatable_callsite, mh, this.is_updatable_callsites);
                        this.updateCallSite(b, this.is_readable, this.is_readable_callsite, mh, this.is_readable_callsites);
                        break;
                    }
                }
            }
            return wasAdded;
        }

        private synchronized boolean clearCasState(CasState state) {
            boolean wasRemoved = this.casState.remove((Object)state);
            if (wasRemoved) {
                switch (state) {
                    case READ_ONLY: {
                        if (this.casState.contains((Object)CasState.NO_ACCESS)) break;
                        this.updateCallSite(true, this.is_updatable, this.is_updatable_callsite, mh_return_true, this.is_updatable_callsites);
                        break;
                    }
                    case NO_ACCESS: {
                        this.current_one_thread_access = null;
                        this.updateCallSite(true, this.is_updatable, this.is_updatable_callsite, mh_return_true, this.is_updatable_callsites);
                        this.updateCallSite(true, this.is_readable, this.is_readable_callsite, mh_return_true, this.is_readable_callsites);
                        break;
                    }
                }
            }
            return wasRemoved;
        }

        private SharedViewData(CASImpl baseCAS, int initialHeapSize, TypeSystemImpl tsi) {
            Boolean v;
            this.baseCAS = baseCAS;
            this.tsi = tsi;
            this.initialHeapSize = initialHeapSize;
            this.bcsd = new BinaryCasSerDes(baseCAS);
            this.id2fs = new Id2FS(initialHeapSize);
            if (traceFSs) {
                this.id2addr.add(0);
            }
            this.isId2Fs = (v = CASImpl.getDefaultV2IdRefs().get()) == null ? IS_ALWAYS_HOLD_ONTO_FSS : v;
        }

        void clearCasReset() {
            this.fsIdGenerator = 0;
            this.lastFsV2Size = 1;
            this.id2fs.clear();
            if (this.id2tramp != null) {
                this.id2tramp.clear();
            }
            if (this.id2base != null) {
                this.id2base.clear();
            }
            Iterator<Map.Entry<ClassLoader, JCasHashMap>> it = this.cl2id2tramp.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ClassLoader, JCasHashMap> e = it.next();
                ClassLoader cl = e.getKey();
                e.getValue().clear();
                if (!(cl instanceof UIMAClassLoader) || !((UIMAClassLoader)cl).isClosed()) continue;
                it.remove();
            }
            this.fssTobeAddedback.clear();
            this.fsTobeAddedbackSingle.clear();
            this.fsTobeAddedbackSingleInUse = false;
            this.disableAutoCorruptionCheck = false;
            this.flushEnabled = true;
            this.componentInfo = null;
            this.bcsd.clear();
            this.csds = null;
            this.llstringSet = null;
            this.traceFSid = 0;
            if (traceFSs) {
                this.traceFScreationSb.setLength(0);
                this.id2addr.removeAllElements();
                this.id2addr.add(0);
                this.nextId2Addr = 1;
            }
            this.emptyFloatList = null;
            this.emptyFSList = null;
            this.emptyIntegerList = null;
            this.emptyStringList = null;
            this.emptyFloatArray = null;
            this.emptyFSArrayMap.clear();
            this.emptyIntegerArray = null;
            this.emptyStringArray = null;
            this.emptyDoubleArray = null;
            this.emptyLongArray = null;
            this.emptyShortArray = null;
            this.emptyByteArray = null;
            this.emptyBooleanArray = null;
            this.current_one_thread_access = null;
            this.updateCallSite(true, this.is_updatable, this.is_updatable_callsite, mh_return_true, this.is_updatable_callsites);
            this.updateCallSite(true, this.is_readable, this.is_readable_callsite, mh_return_true, this.is_readable_callsites);
            this.clearNonSharedInstanceData();
        }

        void clearSofaInfo() {
            this.sofaNameSet.clear();
            this.initialSofaCreated = false;
        }

        void clear() {
            this.resetNoQuestions(false);
            this.tsi = null;
            this.featureCodesInIndexKeys.clear();
            if (this.sofaNbr2ViewMap.size() >= 1) {
                CASImpl localInitialView = this.sofaNbr2ViewMap.get(1);
                this.sofaNbr2ViewMap.clear();
                Misc.setWithExpand(this.sofaNbr2ViewMap, 1, localInitialView);
                this.viewCount = 1;
            } else {
                this.sofaNbr2ViewMap.clear();
                this.viewCount = 0;
            }
        }

        private void resetNoQuestions(boolean flushIndexRepos) {
            this.casResets.incrementAndGet();
            this.clearCasReset();
            if (flushIndexRepos) {
                this.flushIndexRepositoriesAllViews();
            }
            this.clearTrackingMarks();
            this.clearSofaInfo();
            this.viewCount = 1;
            this.traceFSid = 0;
            if (traceFSs) {
                this.traceFScreationSb.setLength(0);
            }
            this.componentInfo = null;
            this.switchControl.clear();
        }

        private void flushIndexRepositoriesAllViews() {
            int numViews = this.viewCount;
            for (int view = 1; view <= numViews; ++view) {
                CASImpl tcas;
                CASImpl cASImpl = tcas = view == 1 ? this.getInitialView() : this.getViewFromSofaNbr(view);
                if (tcas == null) continue;
                tcas.indexRepository.flush();
            }
            this.baseCAS.indexRepository.flush();
        }

        private void clearNonSharedInstanceData() {
            int numViews = this.viewCount;
            for (int view = 1; view <= numViews; ++view) {
                CASImpl tcas;
                CASImpl cASImpl = tcas = view == 1 ? this.getInitialView() : this.getViewFromSofaNbr(view);
                if (tcas == null) continue;
                tcas.mySofaRef = null;
                tcas.docAnnotIter = null;
            }
        }

        private void clearTrackingMarks() {
            if (this.trackingMarkList != null) {
                for (int i = 0; i < this.trackingMarkList.size(); ++i) {
                    this.trackingMarkList.get((int)i).isValid = false;
                }
            }
            this.trackingMark = null;
            if (null != this.modifiedPreexistingFSs) {
                this.modifiedPreexistingFSs.clear();
            }
            this.trackingMarkList = null;
        }

        void switchClassLoader(ClassLoader newClassLoader, boolean wasLocked) {
            SwitchControl switchControlInstance = new SwitchControl(wasLocked);
            this.switchControl.push(switchControlInstance);
            if (null == newClassLoader) {
                return;
            }
            if (!(newClassLoader instanceof UIMAClassLoader)) {
                UIMAFramework.getLogger().debug("Calling switchClassLoader with a classloader of type [{}] that is not a UIMAClassLoader may cause JCas wrappers to be loaded from the wrong classloader.", newClassLoader.getClass().getName());
            }
            if (newClassLoader != this.jcasClassLoader) {
                if (null != this.previousJCasClassLoader) {
                    throw new CASRuntimeException("SWITCH_CLASS_LOADER_NESTED", this.previousJCasClassLoader, this.jcasClassLoader, newClassLoader);
                }
                this.previousJCasClassLoader = this.jcasClassLoader;
                this.jcasClassLoader = newClassLoader;
                switchControlInstance.wasSwitched = true;
                this.generators = this.tsi.getGeneratorsForClassLoader(newClassLoader, true);
                assert (null == this.id2tramp);
                this.id2tramp = this.cl2id2tramp.get(newClassLoader);
                if (null == this.id2tramp) {
                    this.id2tramp = new JCasHashMap(32);
                    this.cl2id2tramp.put(newClassLoader, this.id2tramp);
                }
                if (this.id2base == null) {
                    this.id2base = new JCasHashMap(32);
                }
            }
        }

        void restoreClassLoader(boolean empty_switchControl, SwitchControl switchControlInstance) {
            if (null == this.previousJCasClassLoader) {
                return;
            }
            if ((empty_switchControl || switchControlInstance.wasSwitched) && this.previousJCasClassLoader != this.jcasClassLoader) {
                this.jcasClassLoader = this.previousJCasClassLoader;
                this.previousJCasClassLoader = null;
                this.generators = this.baseGenerators;
                this.id2tramp = null;
            }
        }

        private int getNextFsId(TOP fs) {
            if (this.reuseId != 0) {
                int r = this.reuseId;
                this.reuseId = 0;
                return r;
            }
            int p = this.fsIdGenerator;
            this.fsIdGenerator = this.peekNextFsId();
            int r = this.fsIdGenerator;
            if (r < p) {
                throw new RuntimeException("UIMA Cas Internal id value overflowed maximum int value");
            }
            if (this.isId2Fs) {
                this.lastFsV2Size = fs._getTypeImpl().getFsSpaceReq();
            }
            return r;
        }

        int peekNextFsId() {
            return this.fsIdGenerator + this.lastFsV2IdIncr();
        }

        int lastFsV2IdIncr() {
            return this.isId2Fs ? this.lastFsV2Size : 1;
        }

        private CASImpl getViewFromSofaNbr(int nbr) {
            ArrayList<CASImpl> sn2v = this.sofaNbr2ViewMap;
            if (nbr < sn2v.size()) {
                return sn2v.get(nbr);
            }
            return null;
        }

        CASImpl getInitialView() {
            CASImpl couldBeThis = this.getViewFromSofaNbr(1);
            if (couldBeThis != null) {
                return couldBeThis;
            }
            CASImpl aView = new CASImpl(this.baseCAS, null);
            this.setViewForSofaNbr(1, aView);
            assert (this.viewCount <= 1);
            this.viewCount = 1;
            return aView;
        }

        void setViewForSofaNbr(int nbr, CASImpl view) {
            Misc.setWithExpand(this.sofaNbr2ViewMap, nbr, view);
        }

        static /* synthetic */ FsGenerator3[] access$2202(SharedViewData x0, FsGenerator3[] x1) {
            x0.baseGenerators = x1;
            return x1;
        }

        static /* synthetic */ FsGenerator3[] access$2102(SharedViewData x0, FsGenerator3[] x1) {
            x0.generators = x1;
            return x1;
        }

        static {
            try {
                mh_return_false = MethodHandles.lookup().findStatic(CasState.class, "return_false", noArgBoolean);
                mh_return_true = MethodHandles.lookup().findStatic(CasState.class, "return_true", noArgBoolean);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class SwitchControl {
        final boolean wasLocked;
        boolean wasSwitched = false;

        SwitchControl(boolean wasLocked) {
            this.wasLocked = wasLocked;
        }
    }

    public static class FsChange {
        final TOP fs;
        final BitSet featuresModified;
        final PositiveIntSet arrayUpdates;

        FsChange(TOP fs) {
            this.fs = fs;
            TypeImpl ti = fs._getTypeImpl();
            this.featuresModified = ti.highestOffset == -1 ? null : new BitSet(ti.highestOffset + 1);
            this.arrayUpdates = ti.isArray() ? new PositiveIntSet_impl() : null;
        }

        void addFeatData(int v) {
            this.featuresModified.set(v);
        }

        void addArrayData(int v, int nbrOfConsecutive) {
            for (int i = 0; i < nbrOfConsecutive; ++i) {
                this.arrayUpdates.add(v++);
            }
        }

        void addArrayData(PositiveIntSet indexesPlus1) {
            indexesPlus1.forAllInts(i -> this.arrayUpdates.add(i - 1));
        }

        public int hashCode() {
            return 31 + (this.fs == null ? 0 : this.fs._id);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FsChange)) {
                return false;
            }
            return ((FsChange)obj).fs._id == this.fs._id;
        }
    }
}

