/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.internal.util.Int2ObjHashMap;
import org.apache.uima.internal.util.Obj2IntIdentityHashMap;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.xml.sax.Attributes;

public class XmiSerializationSharedData {
    private Obj2IntIdentityHashMap<TOP> fsToXmiId = new Obj2IntIdentityHashMap<TOP>(TOP.class, TOP._singleton);
    private Int2ObjHashMap<TOP, TOP> xmiIdToFs = new Int2ObjHashMap(TOP.class);
    private List<OotsElementData> ootsFs = new ArrayList<OotsElementData>();
    private Map<String, List<String>> ootsViewMembers = new HashMap<String, List<String>>();
    private Map<TOP, OotsElementData> ootsFeatures = new IdentityHashMap<TOP, OotsElementData>();
    private Map<FSArray, List<XmiArrayElement>> ootsArrayElements = new HashMap<FSArray, List<XmiArrayElement>>();
    private int maxXmiId = 0;
    Map<TOP, TOP> nonsharedfeatureIdToFSId = new IdentityHashMap<TOP, TOP>();

    void addIdMapping(TOP fs, int xmiId) {
        this.fsToXmiId.put(fs, xmiId);
        this.xmiIdToFs.put(xmiId, fs);
        if (xmiId > this.maxXmiId) {
            this.maxXmiId = xmiId;
        }
    }

    public String getXmiId(TOP fs) {
        return Integer.toString(this.getXmiIdAsInt(fs));
    }

    public TOP getFsForXmiId(int xmiId) {
        return this.xmiIdToFs.get(xmiId);
    }

    int getXmiIdAsInt(TOP fs) {
        int xmiId = this.fsToXmiId.get(fs);
        if (xmiId == 0) {
            xmiId = ++this.maxXmiId;
            this.addIdMapping(fs, xmiId);
        }
        return xmiId;
    }

    public int getMaxXmiId() {
        return this.maxXmiId;
    }

    public void clearIdMap() {
        this.fsToXmiId.clear();
        this.xmiIdToFs.clear();
        this.nonsharedfeatureIdToFSId.clear();
        this.maxXmiId = 0;
    }

    public void addOutOfTypeSystemElement(OotsElementData elemData) {
        this.ootsFs.add(elemData);
        int xmiId = Integer.parseInt(elemData.xmiId);
        if (xmiId > this.maxXmiId) {
            this.maxXmiId = xmiId;
        }
    }

    public List<OotsElementData> getOutOfTypeSystemElements() {
        return Collections.unmodifiableList(this.ootsFs);
    }

    public void addOutOfTypeSystemViewMember(String sofaXmiId, String memberXmiId) {
        List membersList = this.ootsViewMembers.computeIfAbsent(sofaXmiId, k -> new ArrayList());
        membersList.add(memberXmiId);
    }

    public List<String> getOutOfTypeSystemViewMembers(String sofaXmiId) {
        List<String> members = this.ootsViewMembers.get(sofaXmiId);
        return members == null ? null : Collections.unmodifiableList(members);
    }

    public void addOutOfTypeSystemAttribute(TOP fs, String featName, String featVal) {
        OotsElementData oed = this.ootsFeatures.get(fs);
        if (oed == null) {
            oed = new OotsElementData(null, null, -1, -1);
            this.ootsFeatures.put(fs, oed);
        }
        oed.attributes.add(new XmlAttribute(featName, featVal));
    }

    public void addOutOfTypeSystemChildElements(TOP fs, String featName, ArrayList<String> featVals) {
        OotsElementData oed = this.ootsFeatures.get(fs);
        if (oed == null) {
            oed = new OotsElementData(null, null, -1, -1);
            this.ootsFeatures.put(fs, oed);
        }
        XmiSerializationSharedData.addOutOfTypeSystemFeature(oed, featName, featVals);
    }

    public static void addOutOfTypeSystemFeature(OotsElementData oed, String featName, ArrayList<String> featVals) {
        oed.multiValuedFeatures.add(new NameMultiValue(featName, featVals));
        XmlElementName elemName = new XmlElementName("", featName, featName);
        for (String val : featVals) {
            oed.childElements.add(new XmlElementNameAndContents(elemName, val));
        }
    }

    public OotsElementData getOutOfTypeSystemFeatures(TOP fs) {
        return this.ootsFeatures.get(fs);
    }

    public TOP[] getAndSortByIdAllFSsInIdMap() {
        TOP[] keys = this.fsToXmiId.getKeys();
        Arrays.sort(keys, (fs1, fs2) -> Integer.compare(fs1._id, fs2._id));
        return keys;
    }

    public List<XmiArrayElement> getOutOfTypeSystemArrayElements(FSArray fsarray) {
        return this.ootsArrayElements.get(fsarray);
    }

    public boolean hasOutOfTypeSystemArrayElements() {
        return this.ootsArrayElements != null && this.ootsArrayElements.size() > 0;
    }

    public void addOutOfTypeSystemArrayElement(FSArray fsarray, int index, int xmiId) {
        List list = this.ootsArrayElements.computeIfAbsent(fsarray, k -> new ArrayList());
        list.add(new XmiArrayElement(index, Integer.toString(xmiId)));
    }

    public void addNonsharedRefToFSMapping(TOP nonsharedFS, TOP fs) {
        this.nonsharedfeatureIdToFSId.put(nonsharedFS, fs);
    }

    public TOP[] getNonsharedMulitValuedFSs() {
        return this.getSortedKeys(this.nonsharedfeatureIdToFSId);
    }

    private TOP[] getSortedKeys(Map<TOP, ?> map) {
        TOP[] keys = map.keySet().toArray(new TOP[map.size()]);
        Arrays.sort(keys, (fs1, fs2) -> Integer.compare(fs1._id, fs2._id));
        return keys;
    }

    public TOP getEncompassingFS(TOP nonsharedFS) {
        return this.nonsharedfeatureIdToFSId.get(nonsharedFS);
    }

    public String toString() {
        TOP[] keys;
        StringBuilder buf = new StringBuilder();
        for (TOP fs : keys = this.getAndSortByIdAllFSsInIdMap()) {
            buf.append(fs._id).append(": ").append(this.fsToXmiId.get(fs)).append('\n');
        }
        return buf.toString();
    }

    public static class NameMultiValue {
        public final String name;
        public final ArrayList<String> values;

        NameMultiValue(String name, ArrayList<String> values) {
            this.name = name;
            this.values = values;
        }
    }

    public static class XmiArrayElement {
        public final int index;
        public final String xmiId;

        XmiArrayElement(int index, String xmiId) {
            this.index = index;
            this.xmiId = xmiId;
        }
    }

    public static class OotsElementData {
        final String xmiId;
        final XmlElementName elementName;
        public final List<XmlAttribute> attributes = new ArrayList<XmlAttribute>();
        final List<XmlElementNameAndContents> childElements = new ArrayList<XmlElementNameAndContents>();
        final ArrayList<NameMultiValue> multiValuedFeatures = new ArrayList();
        final int lineNumber;
        final int colNumber;

        public OotsElementData(String xmiId, XmlElementName elementName) {
            this(xmiId, elementName, -1, -1);
        }

        public OotsElementData(String xmiId, XmlElementName elementName, int lineNumber, int colNumber) {
            this.xmiId = xmiId;
            this.elementName = elementName;
            this.lineNumber = lineNumber;
            this.colNumber = colNumber;
        }

        public Attributes getAttributes() {
            return new Attributes(){

                @Override
                public int getLength() {
                    return attributes.size();
                }

                @Override
                public String getURI(int index) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getLocalName(int index) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getQName(int index) {
                    return attributes.get((int)index).name;
                }

                @Override
                public String getType(int index) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getValue(int index) {
                    return attributes.get((int)index).value;
                }

                @Override
                public int getIndex(String uri, String localName) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int getIndex(String qName) {
                    int i = 0;
                    for (XmlAttribute attr : attributes) {
                        if (attr.name.equals(qName)) {
                            return i;
                        }
                        ++i;
                    }
                    return -1;
                }

                @Override
                public String getType(String uri, String localName) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getType(String qName) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getValue(String uri, String localName) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getValue(String qName) {
                    for (XmlAttribute attr : attributes) {
                        if (!attr.name.equals(qName)) continue;
                        return attr.value;
                    }
                    return null;
                }
            };
        }
    }
}

