/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.request.useragent;

import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.apache.unomi.plugins.request.useragent.UserAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentDetectorServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger((String)UserAgentDetectorServiceImpl.class.getName());
    private UserAgentAnalyzer userAgentAnalyzer;

    public void postConstruct() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.userAgentAnalyzer = ((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withCache(10000).withField("OperatingSystemClass")).withField("OperatingSystemName")).withField("AgentName")).withField("AgentVersion")).withField("DeviceClass")).withField("DeviceName")).withField("DeviceBrand")).build();
            this.userAgentAnalyzer.immediateInitialization();
            this.userAgentAnalyzer.initializeMatchers();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        logger.info("UserAgentDetector service initialized.");
    }

    public void preDestroy() {
        this.userAgentAnalyzer = null;
        logger.info("UserAgentDetector service shutdown.");
    }

    public UserAgent parseUserAgent(String header) {
        nl.basjes.parse.useragent.UserAgent yauaaAgent = this.userAgentAnalyzer.parse(header);
        UserAgent userAgent = new UserAgent();
        userAgent.setDeviceCategory(yauaaAgent.getValue("DeviceClass"));
        userAgent.setDeviceName(yauaaAgent.getValue("DeviceName"));
        userAgent.setDeviceBrand(yauaaAgent.getValue("DeviceBrand"));
        userAgent.setOperatingSystemFamily(yauaaAgent.getValue("OperatingSystemClass"));
        userAgent.setOperatingSystemName(yauaaAgent.getValue("OperatingSystemName"));
        userAgent.setUserAgentName(yauaaAgent.getValue("AgentName"));
        userAgent.setUserAgentVersion(yauaaAgent.getValue("AgentVersion"));
        if (logger.isDebugEnabled()) {
            logger.debug(userAgent.toString());
        }
        return userAgent;
    }
}

