/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features;

import java.net.URI;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.features.ClusterRepositoryEvent;
import org.apache.karaf.cellar.features.FeaturesSupport;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.RepositoryEvent;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryEventHandler
extends FeaturesSupport
implements EventHandler<ClusterRepositoryEvent> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(RepositoryEventHandler.class);
    public static final String SWITCH_ID = "org.apache.karaf.cellar.event.repository.handler";
    private final Switch eventSwitch = new BasicSwitch("org.apache.karaf.cellar.event.repository.handler");

    @Override
    public void init(BundleContext bundleContext) {
        super.init(bundleContext);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handle(ClusterRepositoryEvent event) {
        if (this.eventSwitch.getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR FEATURE: {} switch is OFF, cluster event is not handled", (Object)SWITCH_ID);
            return;
        }
        if (this.groupManager == null) {
            LOGGER.error("CELLAR FEATURE: retrieved event {} while groupManager is not available yet!", (Object)event);
            return;
        }
        if (!this.groupManager.isLocalGroup(event.getSourceGroup().getName())) {
            LOGGER.debug("CELLAR FEATURE: node is not part of the event cluster group");
            return;
        }
        if (event.getLocal() != null && event.getLocal().getId().equals(this.clusterManager.getNode().getId())) {
            LOGGER.trace("CELLAR FEATURE: event is local (coming from synchronizer or listener)");
            return;
        }
        String uri = event.getId();
        RepositoryEvent.EventType type = event.getType();
        try {
            if (RepositoryEvent.EventType.RepositoryAdded.equals((Object)type)) {
                if (event.getRefresh() != null && event.getRefresh().booleanValue()) {
                    if (uri == null) {
                        Repository[] repositories;
                        for (Repository repository : repositories = this.featuresService.listRepositories()) {
                            LOGGER.debug("CELLAR FEATURE: refresh repository {}", (Object)repository.getURI().toString());
                            this.featuresService.refreshRepository(repository.getURI());
                        }
                    } else {
                        LOGGER.debug("CELLAR FEATURE: refresh repository {}", (Object)uri);
                        this.featuresService.refreshRepository(new URI(uri));
                    }
                } else if (!this.isRepositoryRegisteredLocally(uri).booleanValue()) {
                    LOGGER.debug("CELLAR FEATURE: adding repository URI {}", (Object)uri);
                    this.featuresService.addRepository(new URI(uri), event.getInstall().booleanValue());
                } else {
                    LOGGER.debug("CELLAR FEATURE: repository URI {} is already registered locally", (Object)uri);
                }
            } else if (this.isRepositoryRegisteredLocally(uri).booleanValue()) {
                LOGGER.debug("CELLAR FEATURE: removing repository URI {}", (Object)uri);
                this.featuresService.removeRepository(new URI(uri), event.getUninstall().booleanValue());
            } else {
                LOGGER.debug("CELLAR FEATURE: repository URI {} is not registered locally");
            }
        }
        catch (Exception e) {
            LOGGER.error("CELLAR FEATURE: failed to add/remove repository URL {}", (Object)uri, (Object)e);
        }
    }

    public Class<ClusterRepositoryEvent> getType() {
        return ClusterRepositoryEvent.class;
    }

    public Switch getSwitch() {
        return this.eventSwitch;
    }
}

