/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indexlifecycle;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class RemoveIndexLifecyclePolicyResponse {
    public static final ParseField HAS_FAILURES_FIELD = new ParseField("has_failures", new String[0]);
    public static final ParseField FAILED_INDEXES_FIELD = new ParseField("failed_indexes", new String[0]);
    public static final ConstructingObjectParser<RemoveIndexLifecyclePolicyResponse, Void> PARSER = new ConstructingObjectParser("change_policy_for_index_response", true, args -> new RemoveIndexLifecyclePolicyResponse((List)args[0]));
    private final List<String> failedIndexes;

    public RemoveIndexLifecyclePolicyResponse(List<String> failedIndexes) {
        if (failedIndexes == null) {
            throw new IllegalArgumentException(FAILED_INDEXES_FIELD.getPreferredName() + " cannot be null");
        }
        this.failedIndexes = Collections.unmodifiableList(failedIndexes);
    }

    public List<String> getFailedIndexes() {
        return this.failedIndexes;
    }

    public boolean hasFailures() {
        return !this.failedIndexes.isEmpty();
    }

    public static RemoveIndexLifecyclePolicyResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public int hashCode() {
        return Objects.hash(this.failedIndexes);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveIndexLifecyclePolicyResponse other = (RemoveIndexLifecyclePolicyResponse)obj;
        return Objects.equals(this.failedIndexes, other.failedIndexes);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), FAILED_INDEXES_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), HAS_FAILURES_FIELD);
    }
}

