/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;
import org.javamoney.moneta.function.DefaultMonetaryRoundedFactory;
import org.javamoney.moneta.function.MonetaryRoundedFactoryBuilder;
import org.javamoney.moneta.function.PrecisionContextRoundedOperator;

public interface MonetaryRoundedFactory {
    public MonetaryOperator getRoundingOperator();

    public MonetaryAmount create(Number var1, CurrencyUnit var2);

    public static MonetaryRoundedFactoryBuilder withRoundingMode(RoundingMode roundingMode) {
        return new MonetaryRoundedFactoryBuilder(Objects.requireNonNull(roundingMode));
    }

    public static MonetaryRoundedFactory of(MathContext mathContext) {
        return new DefaultMonetaryRoundedFactory(PrecisionContextRoundedOperator.of(Objects.requireNonNull(mathContext)));
    }

    public static MonetaryRoundedFactory of(MonetaryOperator roundingOperator) {
        return new DefaultMonetaryRoundedFactory(Objects.requireNonNull(roundingOperator));
    }
}

