/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.convert;

import java.io.InputStream;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.internal.convert.IMFHistoricalType;
import org.javamoney.moneta.internal.convert.IMFRemoteSearchCallable;

public enum IMFRemoteSearch {
    INSTANCE;

    private static final Logger LOG;
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public Map<IMFHistoricalType, InputStream> getResources(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth);
        EnumMap<IMFHistoricalType, InputStream> map = new EnumMap<IMFHistoricalType, InputStream>(IMFHistoricalType.class);
        try {
            ArrayList<Future<IMFRemoteSearchCallable.IMFRemoteSearchResult>> results = new ArrayList<Future<IMFRemoteSearchCallable.IMFRemoteSearchResult>>(2);
            for (IMFHistoricalType type : IMFHistoricalType.values()) {
                results.add(this.executor.submit(new IMFRemoteSearchCallable(type, yearMonth)));
            }
            for (Future future : results) {
                IMFRemoteSearchCallable.IMFRemoteSearchResult imfRemoteSearchResult = (IMFRemoteSearchCallable.IMFRemoteSearchResult)future.get();
                if (!Objects.nonNull(imfRemoteSearchResult)) continue;
                map.put(imfRemoteSearchResult.getType(), imfRemoteSearchResult.getStream());
            }
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Failed to load resource input for find resource from date " + yearMonth, exception);
        }
        return map;
    }

    static {
        LOG = Logger.getLogger(IMFRemoteSearch.class.getName());
    }
}

