/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.authentication.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.unomi.rest.authentication.RestAuthenticationConfig;
import org.osgi.service.component.annotations.Component;

@Component(service={RestAuthenticationConfig.class})
public class DefaultRestAuthenticationConfig
implements RestAuthenticationConfig {
    private static final String GUEST_ROLES = "ROLE_UNOMI_PUBLIC";
    private static final String ADMIN_ROLES = "ROLE_UNOMI_ADMIN";
    private static final List<Pattern> PUBLIC_PATH_PATTERNS = Arrays.asList(Pattern.compile("(GET|POST|OPTIONS) context\\.js(on|)"), Pattern.compile("(GET|POST|OPTIONS) eventcollector"), Pattern.compile("(GET|OPTIONS) client/.*"));
    private static final Map<String, String> ROLES_MAPPING;

    @Override
    public List<Pattern> getPublicPathPatterns() {
        return PUBLIC_PATH_PATTERNS;
    }

    @Override
    public Map<String, String> getMethodRolesMap() {
        return ROLES_MAPPING;
    }

    @Override
    public String getGlobalRoles() {
        return ADMIN_ROLES;
    }

    static {
        HashMap<String, String> roles = new HashMap<String, String>();
        roles.put("org.apache.unomi.rest.endpoints.ContextJsonEndpoint.contextJSAsGet", GUEST_ROLES);
        roles.put("org.apache.unomi.rest.endpoints.ContextJsonEndpoint.contextJSAsPost", GUEST_ROLES);
        roles.put("org.apache.unomi.rest.endpoints.ContextJsonEndpoint.contextJSONAsGet", GUEST_ROLES);
        roles.put("org.apache.unomi.rest.endpoints.ContextJsonEndpoint.contextJSONAsPost", GUEST_ROLES);
        roles.put("org.apache.unomi.rest.endpoints.ContextJsonEndpoint.options", GUEST_ROLES);
        roles.put("org.apache.unomi.rest.endpoints.EventsCollectorEndpoint.collectAsGet", GUEST_ROLES);
        roles.put("org.apache.unomi.rest.endpoints.EventsCollectorEndpoint.collectAsPost", GUEST_ROLES);
        roles.put("org.apache.unomi.rest.endpoints.EventsCollectorEndpoint.options", GUEST_ROLES);
        roles.put("org.apache.unomi.rest.endpoints.ClientEndpoint.getClient", GUEST_ROLES);
        roles.put("org.apache.unomi.rest.endpoints.ClientEndpoint.options", GUEST_ROLES);
        ROLES_MAPPING = Collections.unmodifiableMap(roles);
    }
}

