/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection;

import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;

public abstract class ClientConnectionStrategy {
    protected ClientContext clientContext;
    protected ILogger logger;
    protected ClientConnectionStrategyConfig clientConnectionStrategyConfig;

    public void init(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.clientConnectionStrategyConfig = clientContext.getClientConfig().getConnectionStrategyConfig();
        this.logger = clientContext.getLoggingService().getLogger(ClientConnectionStrategy.class);
    }

    public abstract void start();

    public abstract void beforeGetConnection(Address var1);

    public abstract void beforeOpenConnection(Address var1);

    public abstract void beforeConnectToCluster(Address var1);

    public abstract void onClusterConnect();

    public abstract void onDisconnectFromCluster();

    public abstract void onConnect(ClientConnection var1);

    public abstract void onDisconnect(ClientConnection var1);

    public abstract void shutdown();
}

