/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpEventListener;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystem;

public abstract class Handle
implements Channel,
AttributeStore {
    private final SftpSubsystem sftpSubsystem;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Path file;
    private final String handle;
    private final Map<AttributeRepository.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();

    protected Handle(SftpSubsystem subsystem, Path file, String handle) {
        this.sftpSubsystem = Objects.requireNonNull(subsystem, "No subsystem instance provided");
        this.file = Objects.requireNonNull(file, "No local file path");
        this.handle = ValidateUtils.checkNotNullAndNotEmpty((String)handle, (String)"No assigned handle for %s", (Object)file);
    }

    protected SftpSubsystem getSubsystem() {
        return this.sftpSubsystem;
    }

    protected void signalHandleOpening() throws IOException {
        SftpSubsystem subsystem = this.getSubsystem();
        SftpEventListener listener = subsystem.getSftpEventListenerProxy();
        ServerSession session = subsystem.getServerSession();
        listener.opening(session, this.handle, this);
    }

    protected void signalHandleOpen() throws IOException {
        SftpSubsystem subsystem = this.getSubsystem();
        SftpEventListener listener = subsystem.getSftpEventListenerProxy();
        ServerSession session = subsystem.getServerSession();
        listener.open(session, this.handle, this);
    }

    public Path getFile() {
        return this.file;
    }

    public String getFileHandle() {
        return this.handle;
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public <T> T getAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.get(Objects.requireNonNull(key, "No key"));
    }

    public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    public <T> T computeAttributeIfAbsent(AttributeRepository.AttributeKey<T> key, Function<? super AttributeRepository.AttributeKey<T>, ? extends T> resolver) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(key, "No key"), resolver);
    }

    public <T> T setAttribute(AttributeRepository.AttributeKey<T> key, T value) {
        return (T)this.attributes.put(Objects.requireNonNull(key, "No key"), Objects.requireNonNull(value, "No value"));
    }

    public <T> T removeAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.remove(Objects.requireNonNull(key, "No key"));
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            return;
        }
    }

    public String toString() {
        return Objects.toString(this.getFile());
    }
}

