/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.apache.commons.ssl.Base64;
import org.apache.commons.ssl.Base64InputStream;
import org.apache.commons.ssl.ComboInputStream;
import org.apache.commons.ssl.DerivedKey;
import org.apache.commons.ssl.PKCS8Key;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.Version;
import org.apache.commons.ssl.util.Hex;

public class OpenSSL {
    public static byte[] decrypt(String cipher, char[] pwd, byte[] encrypted) throws IOException, GeneralSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(encrypted);
        InputStream decrypted = OpenSSL.decrypt(cipher, pwd, in);
        return Util.streamToBytes(decrypted);
    }

    public static InputStream decrypt(String cipher, char[] pwd, InputStream encrypted) throws IOException, GeneralSecurityException {
        CipherInfo cipherInfo = OpenSSL.lookup(cipher);
        boolean salted = false;
        byte[] saltLine = Util.streamToBytes(encrypted, 16);
        if (saltLine.length <= 0) {
            throw new IOException("encrypted InputStream is empty");
        }
        String firstEightBytes = "";
        if (saltLine.length >= 8) {
            firstEightBytes = new String(saltLine, 0, 8);
        }
        if ("SALTED__".equalsIgnoreCase(firstEightBytes)) {
            salted = true;
        } else if (Base64.isArrayByteBase64(saltLine)) {
            ByteArrayInputStream head = new ByteArrayInputStream(saltLine);
            encrypted = new ComboInputStream(head, encrypted);
            saltLine = Util.streamToBytes(encrypted = new Base64InputStream(encrypted), 16);
            if (saltLine.length >= 8) {
                firstEightBytes = new String(saltLine, 0, 8);
            }
            if ("SALTED__".equalsIgnoreCase(firstEightBytes)) {
                salted = true;
            }
        }
        byte[] salt = null;
        if (salted) {
            salt = new byte[8];
            System.arraycopy(saltLine, 8, salt, 0, 8);
        } else {
            ByteArrayInputStream head = new ByteArrayInputStream(saltLine);
            encrypted = new ComboInputStream(head, encrypted);
        }
        int keySize = cipherInfo.keySize;
        int ivSize = cipherInfo.ivSize;
        boolean des2 = cipherInfo.des2;
        DerivedKey dk = OpenSSL.deriveKey(pwd, salt, keySize, ivSize, des2);
        Cipher c = PKCS8Key.generateCipher(cipherInfo.javaCipher, cipherInfo.blockMode, dk, des2, null, true);
        return new CipherInputStream(encrypted, c);
    }

    public static byte[] encrypt(String cipher, char[] pwd, byte[] data) throws IOException, GeneralSecurityException {
        return OpenSSL.encrypt(cipher, pwd, data, true);
    }

    public static InputStream encrypt(String cipher, char[] pwd, InputStream data) throws IOException, GeneralSecurityException {
        return OpenSSL.encrypt(cipher, pwd, data, true);
    }

    public static byte[] encrypt(String cipher, char[] pwd, byte[] data, boolean toBase64) throws IOException, GeneralSecurityException {
        return OpenSSL.encrypt(cipher, pwd, data, toBase64, true);
    }

    public static InputStream encrypt(String cipher, char[] pwd, InputStream data, boolean toBase64) throws IOException, GeneralSecurityException {
        return OpenSSL.encrypt(cipher, pwd, data, toBase64, true);
    }

    public static byte[] encrypt(String cipher, char[] pwd, byte[] data, boolean toBase64, boolean useSalt) throws IOException, GeneralSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        InputStream encrypted = OpenSSL.encrypt(cipher, pwd, in, toBase64, useSalt);
        return Util.streamToBytes(encrypted);
    }

    public static InputStream encrypt(String cipher, char[] pwd, InputStream data, boolean toBase64, boolean useSalt) throws IOException, GeneralSecurityException {
        CipherInfo cipherInfo = OpenSSL.lookup(cipher);
        byte[] salt = null;
        if (useSalt) {
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            salt = new byte[8];
            rand.nextBytes(salt);
        }
        int keySize = cipherInfo.keySize;
        int ivSize = cipherInfo.ivSize;
        boolean des2 = cipherInfo.des2;
        DerivedKey dk = OpenSSL.deriveKey(pwd, salt, keySize, ivSize, des2);
        Cipher c = PKCS8Key.generateCipher(cipherInfo.javaCipher, cipherInfo.blockMode, dk, des2, null, false);
        InputStream cipherStream = new CipherInputStream(data, c);
        if (useSalt) {
            byte[] saltLine = new byte[16];
            byte[] salted = "Salted__".getBytes();
            System.arraycopy(salted, 0, saltLine, 0, salted.length);
            System.arraycopy(salt, 0, saltLine, salted.length, salt.length);
            ByteArrayInputStream head = new ByteArrayInputStream(saltLine);
            cipherStream = new ComboInputStream(head, cipherStream);
        }
        if (toBase64) {
            cipherStream = new Base64InputStream(cipherStream, true);
        }
        return cipherStream;
    }

    public static byte[] decrypt(String cipher, byte[] key, byte[] iv, byte[] encrypted) throws IOException, GeneralSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(encrypted);
        InputStream decrypted = OpenSSL.decrypt(cipher, key, iv, in);
        return Util.streamToBytes(decrypted);
    }

    public static InputStream decrypt(String cipher, byte[] key, byte[] iv, InputStream encrypted) throws IOException, GeneralSecurityException {
        ByteArrayInputStream head;
        CipherInfo cipherInfo = OpenSSL.lookup(cipher);
        byte[] firstLine = Util.streamToBytes(encrypted, 16);
        if (Base64.isArrayByteBase64(firstLine)) {
            head = new ByteArrayInputStream(firstLine);
            encrypted = new ComboInputStream(head, encrypted);
            encrypted = new Base64InputStream(encrypted);
        } else {
            head = new ByteArrayInputStream(firstLine);
            encrypted = new ComboInputStream(head, encrypted);
        }
        int keySize = cipherInfo.keySize;
        int ivSize = cipherInfo.ivSize;
        if (key.length == keySize / 4) {
            key = Hex.decode(key);
        }
        if (iv.length == ivSize / 4) {
            iv = Hex.decode(iv);
        }
        DerivedKey dk = new DerivedKey(key, iv);
        Cipher c = PKCS8Key.generateCipher(cipherInfo.javaCipher, cipherInfo.blockMode, dk, cipherInfo.des2, null, true);
        return new CipherInputStream(encrypted, c);
    }

    public static byte[] encrypt(String cipher, byte[] key, byte[] iv, byte[] data) throws IOException, GeneralSecurityException {
        return OpenSSL.encrypt(cipher, key, iv, data, true);
    }

    public static byte[] encrypt(String cipher, byte[] key, byte[] iv, byte[] data, boolean toBase64) throws IOException, GeneralSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        InputStream encrypted = OpenSSL.encrypt(cipher, key, iv, in, toBase64);
        return Util.streamToBytes(encrypted);
    }

    public static InputStream encrypt(String cipher, byte[] key, byte[] iv, InputStream data) throws IOException, GeneralSecurityException {
        return OpenSSL.encrypt(cipher, key, iv, data, true);
    }

    public static InputStream encrypt(String cipher, byte[] key, byte[] iv, InputStream data, boolean toBase64) throws IOException, GeneralSecurityException {
        CipherInfo cipherInfo = OpenSSL.lookup(cipher);
        int keySize = cipherInfo.keySize;
        int ivSize = cipherInfo.ivSize;
        if (key.length == keySize / 4) {
            key = Hex.decode(key);
        }
        if (iv.length == ivSize / 4) {
            iv = Hex.decode(iv);
        }
        DerivedKey dk = new DerivedKey(key, iv);
        Cipher c = PKCS8Key.generateCipher(cipherInfo.javaCipher, cipherInfo.blockMode, dk, cipherInfo.des2, null, false);
        FilterInputStream cipherStream = new CipherInputStream(data, c);
        if (toBase64) {
            cipherStream = new Base64InputStream(cipherStream, true);
        }
        return cipherStream;
    }

    public static DerivedKey deriveKey(char[] password, byte[] salt, int keySize, boolean des2) throws NoSuchAlgorithmException {
        return OpenSSL.deriveKey(password, salt, keySize, 0, des2);
    }

    public static DerivedKey deriveKey(char[] password, byte[] salt, int keySize, int ivSize, boolean des2) throws NoSuchAlgorithmException {
        if (des2) {
            keySize = 128;
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] pwdAsBytes = new byte[password.length];
        for (int i = 0; i < password.length; ++i) {
            pwdAsBytes[i] = (byte)password[i];
        }
        md.reset();
        byte[] keyAndIv = new byte[keySize / 8 + ivSize / 8];
        if (salt == null || salt.length == 0) {
            salt = null;
        }
        int currentPos = 0;
        while (currentPos < keyAndIv.length) {
            int stillNeed;
            byte[] result;
            md.update(pwdAsBytes);
            if (salt != null) {
                md.update(salt, 0, 8);
            }
            if ((result = md.digest()).length > (stillNeed = keyAndIv.length - currentPos)) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result, 0, b, 0, b.length);
                result = b;
            }
            System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
            if ((currentPos += result.length) >= keyAndIv.length) continue;
            md.reset();
            md.update(result);
        }
        if (des2) {
            keySize = 192;
            byte[] buf = new byte[keyAndIv.length + 8];
            System.arraycopy(keyAndIv, 0, buf, 0, 16);
            if (ivSize > 0) {
                System.arraycopy(keyAndIv, 16, buf, 24, keyAndIv.length - 16);
            }
            keyAndIv = buf;
            System.arraycopy(keyAndIv, 0, keyAndIv, 16, 8);
        }
        if (ivSize == 0) {
            return new DerivedKey(keyAndIv, salt);
        }
        byte[] key = new byte[keySize / 8];
        byte[] iv = new byte[ivSize / 8];
        System.arraycopy(keyAndIv, 0, key, 0, key.length);
        System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
        return new DerivedKey(key, iv);
    }

    public static CipherInfo lookup(String openSSLCipher) {
        boolean des2;
        int ivSize;
        int keySize;
        String blockMode;
        String javaCipher;
        block58: {
            if ((openSSLCipher = openSSLCipher.trim()).charAt(0) == '-') {
                openSSLCipher = openSSLCipher.substring(1);
            }
            javaCipher = openSSLCipher.toUpperCase();
            blockMode = "CBC";
            keySize = -1;
            ivSize = 64;
            des2 = false;
            StringTokenizer st = new StringTokenizer(openSSLCipher, "-");
            if (st.hasMoreTokens()) {
                javaCipher = st.nextToken().toUpperCase();
                if (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (st.hasMoreTokens()) {
                        block57: {
                            try {
                                keySize = Integer.parseInt(tok);
                            }
                            catch (NumberFormatException nfe) {
                                String upper = tok.toUpperCase();
                                if (upper.startsWith("EDE3")) {
                                    javaCipher = "DESede";
                                }
                                if (!upper.startsWith("EDE")) break block57;
                                javaCipher = "DESede";
                                des2 = true;
                            }
                        }
                        blockMode = st.nextToken().toUpperCase();
                    } else {
                        try {
                            keySize = Integer.parseInt(tok);
                        }
                        catch (NumberFormatException nfe) {
                            blockMode = tok.toUpperCase();
                            if (blockMode.startsWith("EDE3")) {
                                javaCipher = "DESede";
                                blockMode = "ECB";
                            }
                            if (!blockMode.startsWith("EDE")) break block58;
                            javaCipher = "DESede";
                            blockMode = "ECB";
                            des2 = true;
                        }
                    }
                }
            }
        }
        if (javaCipher.startsWith("BF")) {
            javaCipher = "Blowfish";
        } else if (javaCipher.startsWith("TWOFISH")) {
            javaCipher = "Twofish";
            ivSize = 128;
        } else if (javaCipher.startsWith("IDEA")) {
            javaCipher = "IDEA";
        } else if (javaCipher.startsWith("CAST6")) {
            javaCipher = "CAST6";
            ivSize = 128;
        } else if (javaCipher.startsWith("CAST")) {
            javaCipher = "CAST5";
        } else if (javaCipher.startsWith("GOST")) {
            keySize = 256;
        } else if (javaCipher.startsWith("DESX")) {
            javaCipher = "DESX";
        } else if ("DES3".equals(javaCipher)) {
            javaCipher = "DESede";
        } else if ("DES2".equals(javaCipher)) {
            javaCipher = "DESede";
            des2 = true;
        } else if (javaCipher.startsWith("RIJNDAEL")) {
            javaCipher = "Rijndael";
            ivSize = 128;
        } else if (javaCipher.startsWith("SEED")) {
            javaCipher = "SEED";
            ivSize = 128;
        } else if (javaCipher.startsWith("SERPENT")) {
            javaCipher = "Serpent";
            ivSize = 128;
        } else if (javaCipher.startsWith("Skipjack")) {
            javaCipher = "Skipjack";
            ivSize = 128;
        } else if (javaCipher.startsWith("RC6")) {
            javaCipher = "RC6";
            ivSize = 128;
        } else if (javaCipher.startsWith("TEA")) {
            javaCipher = "TEA";
        } else if (javaCipher.startsWith("XTEA")) {
            javaCipher = "XTEA";
        } else if (javaCipher.startsWith("AES")) {
            if (javaCipher.startsWith("AES128")) {
                keySize = 128;
            } else if (javaCipher.startsWith("AES192")) {
                keySize = 192;
            } else if (javaCipher.startsWith("AES256")) {
                keySize = 256;
            }
            javaCipher = "AES";
            ivSize = 128;
        } else if (javaCipher.startsWith("CAMELLIA")) {
            if (javaCipher.startsWith("CAMELLIA128")) {
                keySize = 128;
            } else if (javaCipher.startsWith("CAMELLIA192")) {
                keySize = 192;
            } else if (javaCipher.startsWith("CAMELLIA256")) {
                keySize = 256;
            }
            javaCipher = "CAMELLIA";
            ivSize = 128;
        }
        if (keySize == -1) {
            keySize = javaCipher.startsWith("DESede") ? 192 : (javaCipher.startsWith("DES") ? 64 : 128);
        }
        return new CipherInfo(javaCipher, blockMode, keySize, ivSize, des2);
    }

    public static void main(String[] args) throws IOException, GeneralSecurityException {
        if (args.length < 3) {
            System.out.println(Version.versionString());
            System.out.println("Pure-java utility to decrypt files previously encrypted by 'openssl enc'");
            System.out.println();
            System.out.println("Usage:  java -cp commons-ssl.jar org.apache.commons.ssl.OpenSSL [args]");
            System.out.println("        [args]   == [password] [cipher] [file-to-decrypt]");
            System.out.println("        [cipher] == des, des3, des-ede3-cbc, aes256, rc2, rc4, bf, bf-cbc, etc...");
            System.out.println("                    Try 'man enc' on a unix box to see what's possible.");
            System.out.println();
            System.out.println("This utility can handle base64 or raw, salted or unsalted.");
            System.out.println();
            System.exit(1);
        }
        char[] password = args[0].toCharArray();
        InputStream in = new FileInputStream(args[2]);
        in = OpenSSL.decrypt(args[1], password, in);
        in = new BufferedInputStream(in);
        BufferedOutputStream bufOut = new BufferedOutputStream(System.out);
        Util.pipeStream(in, bufOut, false);
        bufOut.flush();
        System.out.flush();
    }

    public static class CipherInfo {
        public final String javaCipher;
        public final String blockMode;
        public final int keySize;
        public final int ivSize;
        public final boolean des2;

        public CipherInfo(String javaCipher, String blockMode, int keySize, int ivSize, boolean des2) {
            this.javaCipher = javaCipher;
            this.blockMode = blockMode;
            this.keySize = keySize;
            this.ivSize = ivSize;
            this.des2 = des2;
        }

        public String toString() {
            return this.javaCipher + "/" + this.blockMode + " " + this.keySize + "bit  des2=" + this.des2;
        }
    }
}

