/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.Collections;
import java.util.Set;
import javax.money.AbstractContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;

public final class ProviderContext
extends AbstractContext {
    private static final long serialVersionUID = 3536713139786856877L;
    static final String KEY_RATE_TYPES = "rateTypes";

    ProviderContext(ProviderContextBuilder builder) {
        super(builder);
    }

    public Set<RateType> getRateTypes() {
        Set rateSet = this.get(KEY_RATE_TYPES, Set.class);
        if (rateSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(rateSet);
    }

    public ProviderContextBuilder toBuilder() {
        return ProviderContextBuilder.create(this);
    }

    public static ProviderContext of(String provider, RateType rateType, RateType ... rateTypes) {
        return ProviderContextBuilder.of(provider, rateType, rateTypes).build();
    }

    public static ProviderContext of(String provider) {
        return ProviderContextBuilder.of(provider, RateType.ANY, new RateType[0]).build();
    }
}

