/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast.management.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.command.Command;
import org.apache.karaf.cellar.core.command.ExecutionContext;
import org.apache.karaf.cellar.core.management.CellarNodeMBean;
import org.apache.karaf.cellar.utils.ping.Ping;

public class CellarNodeMBeanImpl
extends StandardMBean
implements CellarNodeMBean {
    private ClusterManager clusterManager;
    private ExecutionContext executionContext;

    public CellarNodeMBeanImpl() throws NotCompliantMBeanException {
        super(CellarNodeMBean.class);
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public long pingNode(String nodeIdOrAlias) throws Exception {
        Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
        if (node == null) {
            throw new IllegalArgumentException("Cluster group " + nodeIdOrAlias + " doesn't exist");
        }
        Long start = System.currentTimeMillis();
        Ping ping = new Ping(this.clusterManager.generateId());
        ping.setDestination(new HashSet<Node>(Arrays.asList(node)));
        this.executionContext.execute((Command)ping);
        Long stop = System.currentTimeMillis();
        return stop - start;
    }

    public void setAlias(String alias) throws Exception {
        if (alias == null) {
            throw new IllegalArgumentException("Alias is null");
        }
        if (this.clusterManager.findNodeByAlias(alias) != null) {
            throw new IllegalArgumentException("Alias " + alias + " already exists");
        }
        this.clusterManager.setNodeAlias(alias);
    }

    public String getAlias(String id) throws Exception {
        Node node = this.clusterManager.findNodeById(id);
        if (node != null) {
            return node.getAlias();
        }
        return null;
    }

    public String getId(String alias) throws Exception {
        Node node = this.clusterManager.findNodeByAlias(alias);
        if (node != null) {
            return node.getId();
        }
        return null;
    }

    public TabularData getNodes() throws Exception {
        CompositeType nodeType = new CompositeType("Node", "Karaf Cellar cluster node", new String[]{"id", "alias", "hostname", "port", "local"}, new String[]{"ID of the node", "Alias of the node", "Hostname of the node", "Port number of the node", "Flag defining if the node is local"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN});
        TabularType tableType = new TabularType("Nodes", "Table of all Karaf Cellar nodes", nodeType, new String[]{"id"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        Set nodes = this.clusterManager.listNodes();
        for (Node node : nodes) {
            boolean local = node.equals(this.clusterManager.getNode());
            CompositeDataSupport data = new CompositeDataSupport(nodeType, new String[]{"id", "alias", "hostname", "port", "local"}, new Object[]{node.getId(), node.getAlias(), node.getHost(), node.getPort(), local});
            table.put(data);
        }
        return table;
    }
}

