/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.services;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.router.api.ExportConfiguration;
import org.apache.unomi.router.api.ImportExportConfiguration;
import org.apache.unomi.router.api.RouterConstants;
import org.apache.unomi.router.api.RouterUtils;
import org.apache.unomi.router.api.services.ProfileExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileExportServiceImpl
implements ProfileExportService {
    private static final Logger logger = LoggerFactory.getLogger((String)ProfileExportServiceImpl.class.getName());
    private PersistenceService persistenceService;
    private DefinitionsService definitionsService;
    private ConfigSharingService configSharingService;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setConfigSharingService(ConfigSharingService configSharingService) {
        this.configSharingService = configSharingService;
    }

    public String extractProfilesBySegment(ExportConfiguration exportConfiguration) {
        List propertiesDef = this.persistenceService.query("target", "profiles", null, PropertyType.class);
        Condition segmentCondition = new Condition();
        segmentCondition.setConditionType(this.definitionsService.getConditionType("profileSegmentCondition"));
        segmentCondition.setParameter("segments", Collections.singletonList((String)exportConfiguration.getProperty("segment")));
        segmentCondition.setParameter("matchType", (Object)"in");
        StringBuilder csvContent = new StringBuilder();
        PartialList profiles = this.persistenceService.query(segmentCondition, null, Profile.class, 0, 1000, "10m");
        int counter = 0;
        while (profiles != null && profiles.getList().size() > 0) {
            List scrolledProfiles = profiles.getList();
            for (Profile profile : scrolledProfiles) {
                csvContent.append(this.convertProfileToCSVLine(profile, exportConfiguration, propertiesDef));
                csvContent.append(RouterUtils.getCharFromLineSeparator((String)exportConfiguration.getLineSeparator()));
            }
            counter += scrolledProfiles.size();
            profiles = this.persistenceService.continueScrollQuery(Profile.class, profiles.getScrollIdentifier(), profiles.getScrollTimeValidity());
        }
        HashMap<Object, Number> execution = new HashMap<Object, Number>();
        execution.put(RouterConstants.KEY_EXECS_DATE, new Date().getTime());
        execution.put(RouterConstants.KEY_EXECS_EXTRACTED, counter);
        exportConfiguration = (ExportConfiguration)RouterUtils.addExecutionEntry((ImportExportConfiguration)exportConfiguration, execution, (int)Integer.parseInt((String)this.configSharingService.getProperty("historySize")));
        this.persistenceService.save((Item)exportConfiguration);
        return csvContent.toString();
    }

    public String convertProfileToCSVLine(Profile profile, ExportConfiguration exportConfiguration) {
        List propertiesDef = this.persistenceService.query("target", "profiles", null, PropertyType.class);
        return this.convertProfileToCSVLine(profile, exportConfiguration, propertiesDef);
    }

    public String convertProfileToCSVLine(Profile profile, ExportConfiguration exportConfiguration, Collection<PropertyType> propertiesDef) {
        Map mapping = (Map)exportConfiguration.getProperty("mapping");
        String lineToWrite = "";
        for (int i = 0; i < mapping.size(); ++i) {
            String propertyName = (String)mapping.get(String.valueOf(i));
            if (propertyName == null) {
                logger.error("No index {} found in the provided mapping!", (Object)i);
                return "";
            }
            PropertyType propType = RouterUtils.getPropertyTypeById(propertiesDef, (String)propertyName);
            Object propertyValue = profile.getProperty(propertyName);
            if (propType != null && BooleanUtils.isTrue((Boolean)propType.isMultivalued())) {
                if (propertyValue != null) {
                    List multiValue = (List)propertyValue;
                    lineToWrite = lineToWrite + (StringUtils.isNotBlank((CharSequence)exportConfiguration.getMultiValueDelimiter()) ? Character.valueOf(exportConfiguration.getMultiValueDelimiter().charAt(0)) : "");
                    int j = 0;
                    for (String entry : multiValue) {
                        lineToWrite = lineToWrite + entry.replaceAll("\"", "\"\"");
                        if (j + 1 < multiValue.size()) {
                            lineToWrite = lineToWrite + exportConfiguration.getMultiValueSeparator();
                        }
                        ++j;
                    }
                    lineToWrite = lineToWrite + (StringUtils.isNotBlank((CharSequence)exportConfiguration.getMultiValueDelimiter()) ? Character.valueOf(exportConfiguration.getMultiValueDelimiter().charAt(1)) : "");
                } else {
                    lineToWrite = lineToWrite + "";
                }
            } else if (propertyValue != null) {
                if (StringUtils.contains((CharSequence)(propertyValue = propertyValue.toString().replaceAll("\"", "\"\"")).toString(), (CharSequence)exportConfiguration.getColumnSeparator())) {
                    propertyValue = "\"" + propertyValue + "\"";
                }
                lineToWrite = lineToWrite + propertyValue.toString();
            } else {
                lineToWrite = lineToWrite + "";
            }
            if (i + 1 >= mapping.size()) continue;
            lineToWrite = lineToWrite + exportConfiguration.getColumnSeparator();
        }
        return lineToWrite;
    }
}

