/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtendedHttpServiceRuntime;
import org.ops4j.pax.web.extender.whiteboard.internal.element.FilterWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ListenerWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ResourceWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ServletWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WelcomeFileWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.tracker.ReplaceableService;
import org.ops4j.pax.web.extender.whiteboard.internal.util.tracker.ReplaceableServiceListener;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.whiteboard.HttpContextMapping;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.context.ServletContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplication
implements ReplaceableServiceListener<HttpService> {
    private static final Logger LOG = LoggerFactory.getLogger(WebApplication.class);
    private final Bundle bundle;
    private final String httpContextId;
    private final Boolean sharedHttpContext;
    private final List<WebElement> webElements;
    private final ReadWriteLock httpServiceLock;
    private final ExtendedHttpServiceRuntime httpServiceRuntime;
    private HttpContextMapping httpContextMapping;
    private ReplaceableService<HttpService> httpServiceTracker;
    private WebContainer webContainer;
    private HttpContext httpContext;
    private ServletContextHelper servletContextHelper;

    public WebApplication(Bundle bundle, String httpContextId, Boolean sharedHttpContext, ExtendedHttpServiceRuntime httpServiceRuntime) {
        this.bundle = bundle;
        this.httpContextId = httpContextId;
        this.sharedHttpContext = sharedHttpContext;
        this.webElements = new CopyOnWriteArrayList<WebElement>();
        this.httpServiceLock = new ReentrantReadWriteLock();
        this.httpServiceTracker = new ReplaceableService<HttpService>(bundle.getBundleContext(), HttpService.class, this);
        this.httpServiceRuntime = httpServiceRuntime;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getHttpContextId() {
        return this.httpContextId;
    }

    public Boolean getSharedHttpContext() {
        return this.sharedHttpContext;
    }

    public void start() {
        this.httpServiceTracker.start();
    }

    public void stop() {
        this.httpServiceTracker.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebElement(WebElement webElement) {
        NullArgumentException.validateNotNull(webElement, "Registerer");
        this.httpServiceLock.writeLock().lock();
        try {
            if (webElement instanceof ListenerWebElement) {
                LOG.debug("registering a ListenerWebElement");
                List<WebElement> stoppableElements = this.webElements.stream().filter(element -> !(element instanceof ListenerWebElement)).filter(element -> !(element instanceof ResourceWebElement)).collect(Collectors.toList());
                stoppableElements.forEach(element -> {
                    LOG.debug("unregistering element {}", element);
                    this.unregisterWebElement((WebElement)element);
                });
                LOG.debug("registering weblement:{}", (Object)webElement);
                this.registerWebElement(webElement);
                LOG.debug("registering servlet elements again");
                stoppableElements.stream().filter(elem -> elem instanceof ServletWebElement).forEach(this::registerWebElement);
                LOG.debug("registering filters again");
                stoppableElements.stream().filter(elem -> elem instanceof FilterWebElement).forEach(this::registerWebElement);
                LOG.debug("registering the others");
                stoppableElements.stream().filter(elem -> !(elem instanceof ServletWebElement) && !(elem instanceof FilterWebElement)).forEach(this::registerWebElement);
            } else if (webElement instanceof ServletWebElement) {
                List<WebElement> filterWebElements = this.webElements.stream().filter(elem -> elem instanceof FilterWebElement).collect(Collectors.toList());
                LOG.debug("de-registering {} servlet filters", (Object)filterWebElements.size());
                filterWebElements.forEach(this::unregisterWebElement);
                List<WebElement> welcomeFileMappings = this.webElements.stream().filter(elem -> elem instanceof WelcomeFileWebElement).collect(Collectors.toList());
                LOG.debug("de-registering {} welcomefilemappings", (Object)welcomeFileMappings.size());
                welcomeFileMappings.forEach(this::unregisterWebElement);
                LOG.debug("registering weblement:{}", (Object)webElement);
                this.registerWebElement(webElement);
                LOG.debug("registering filters again");
                filterWebElements.forEach(this::registerWebElement);
                LOG.debug("filters registerd again");
                LOG.debug("registering welcomefiles again");
                welcomeFileMappings.forEach(this::registerWebElement);
                LOG.debug("registered welcomeFiles again");
            } else {
                LOG.debug("registering weblement:{}", (Object)webElement);
                this.registerWebElement(webElement);
            }
        }
        finally {
            this.webElements.add(webElement);
            this.httpServiceLock.writeLock().unlock();
        }
    }

    public boolean removeWebElement(WebElement webElement) {
        boolean empty;
        NullArgumentException.validateNotNull(webElement, "Registerer");
        this.httpServiceLock.readLock().lock();
        try {
            this.webElements.remove(webElement);
            empty = this.webElements.isEmpty();
            this.unregisterWebElement(webElement);
        }
        finally {
            this.httpServiceRuntime.removeWhiteboardElement(webElement);
            this.httpServiceLock.readLock().unlock();
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceChanged(HttpService oldService, HttpService newService, Map<String, Object> serviceProperties) {
        if (newService != null && !WebContainerUtils.isWebContainer(newService)) {
            throw new IllegalStateException("HttpService must be implementing Pax-Web WebContainer!");
        }
        this.httpServiceLock.writeLock().lock();
        try {
            this.unregisterWebElements();
            this.webContainer = (WebContainer)newService;
            this.httpContext = null;
            this.registerHttpContext();
        }
        finally {
            this.httpServiceLock.writeLock().unlock();
        }
    }

    public boolean hasHttpContextMapping() {
        return this.httpContextMapping != null;
    }

    public void setHttpContextMapping(HttpContextMapping httpContextMapping) {
        this.httpServiceLock.writeLock().lock();
        try {
            if (this.hasHttpContextMapping()) {
                this.unregisterHttpContext();
            }
            this.httpContextMapping = httpContextMapping;
            this.registerHttpContext();
        }
        finally {
            this.httpServiceLock.writeLock().unlock();
        }
    }

    private void unregisterHttpContext() {
        if (this.httpContext != null) {
            this.unregisterWebElements();
            this.httpContext = null;
        }
    }

    private void registerHttpContext() {
        if (this.httpContextMapping != null && this.webContainer != null) {
            this.getHttpContext();
            if (WebContainerUtils.isWebContainer((HttpService)this.webContainer)) {
                HashMap<String, String> contextparams = new HashMap<String, String>();
                if (this.httpContextMapping.getPath() != null) {
                    contextparams.put("webapp.context", this.httpContextMapping.getPath());
                }
                if (this.httpContextMapping.getParameters() != null) {
                    contextparams.putAll(this.httpContextMapping.getParameters());
                    String virtualHosts = (String)contextparams.remove("httpContext.virtualhosts");
                    List<String> virtualHostsList = this.convertToList(virtualHosts);
                    String connectors = (String)contextparams.remove("httpContext.connectors");
                    List<String> connectorsList = this.convertToList(connectors);
                    this.webContainer.setConnectorsAndVirtualHosts(connectorsList, virtualHostsList, this.httpContext);
                }
                this.webContainer.setContextParam(DictionaryUtils.adapt(contextparams), this.httpContext);
            }
            this.registerWebElements();
        }
    }

    private void getHttpContext() {
        this.httpContext = this.httpContextMapping.getHttpContext();
        if (this.httpContext == null) {
            if (this.servletContextHelper != null) {
                this.httpContext = new WebContainerContext(){

                    public Set<String> getResourcePaths(String name) {
                        return null;
                    }

                    public String getContextId() {
                        return WebApplication.this.httpContextId;
                    }

                    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
                        return WebApplication.this.servletContextHelper.handleSecurity(request, response);
                    }

                    public URL getResource(String name) {
                        return WebApplication.this.servletContextHelper.getResource(name);
                    }

                    public String getMimeType(String name) {
                        return WebApplication.this.servletContextHelper.getMimeType(name);
                    }
                };
            } else {
                String sharedContext = null;
                if (this.httpContextMapping != null && this.httpContextMapping.getParameters() != null) {
                    sharedContext = (String)this.httpContextMapping.getParameters().get("httpContext.shared");
                }
                this.httpContext = Boolean.parseBoolean(sharedContext) && WebContainerUtils.isWebContainer((HttpService)this.webContainer) ? this.webContainer.createDefaultSharedHttpContext() : (this.httpContextId != null && WebContainerUtils.isWebContainer((HttpService)this.webContainer) ? this.webContainer.createDefaultHttpContext(this.httpContextId) : this.webContainer.createDefaultHttpContext());
            }
        } else if (!(this.httpContext instanceof WebContainerContext)) {
            final HttpContext localHttpContext = this.httpContext;
            this.httpContext = new WebContainerContext(){

                public Set<String> getResourcePaths(String name) {
                    return null;
                }

                public String getContextId() {
                    return WebApplication.this.httpContextId;
                }

                public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
                    return localHttpContext.handleSecurity(request, response);
                }

                public URL getResource(String name) {
                    return localHttpContext.getResource(name);
                }

                public String getMimeType(String name) {
                    return localHttpContext.getMimeType(name);
                }
            };
        }
    }

    private void registerWebElements() {
        this.httpServiceLock.readLock().lock();
        try {
            if (this.webContainer != null && this.httpContext != null) {
                for (WebElement registerer : this.webElements) {
                    this.registerWebElement(registerer);
                }
            }
        }
        finally {
            this.httpServiceLock.readLock().unlock();
        }
    }

    private List<String> convertToList(String elementListAsString) {
        List<String> elementList = new LinkedList<String>();
        if (elementListAsString != null) {
            String[] elementArray = elementListAsString.split(",");
            elementList = Arrays.stream(elementArray).map(String::trim).collect(Collectors.toList());
        }
        return elementList;
    }

    private void registerWebElement(WebElement registerer) {
        try {
            if (this.webContainer != null && this.httpContext != null && registerer.isValid()) {
                registerer.register(this.webContainer, this.httpContext);
            }
        }
        catch (Exception ignore) {
            LOG.error("Registration skipped for [" + registerer + "] due to error during registration", (Throwable)ignore);
        }
        finally {
            this.httpServiceRuntime.addWhiteboardElement(registerer);
        }
    }

    private void unregisterWebElements() {
        block2: {
            this.httpServiceLock.readLock().lock();
            try {
                if (this.webContainer == null || this.httpContext == null) break block2;
                this.webElements.forEach(this::unregisterWebElement);
            }
            catch (Throwable throwable) {
                this.webElements.forEach(this.httpServiceRuntime::removeWhiteboardElement);
                this.httpServiceLock.readLock().unlock();
                throw throwable;
            }
        }
        this.webElements.forEach(this.httpServiceRuntime::removeWhiteboardElement);
        this.httpServiceLock.readLock().unlock();
    }

    private void unregisterWebElement(WebElement registerer) {
        if (this.webContainer != null && this.httpContext != null && registerer.isValid()) {
            registerer.unregister(this.webContainer, this.httpContext);
        }
    }

    public void setServletContextHelper(ServletContextHelper servletContextHelper, HttpContextMapping httpContextMapping) {
        this.httpServiceLock.writeLock().lock();
        try {
            if (this.hasHttpContextMapping()) {
                this.unregisterHttpContext();
            }
            this.servletContextHelper = servletContextHelper;
            this.httpContextMapping = httpContextMapping;
            this.registerHttpContext();
        }
        finally {
            this.httpServiceLock.writeLock().unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mapping=" + this.httpContextMapping + "}";
    }
}

