/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.KeyStoreBuilder;
import org.apache.commons.ssl.TrustMaterial;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.X509CertificateChainBuilder;

public class KeyMaterial
extends TrustMaterial {
    private final Object keyManagerFactory;
    private final List aliases;
    private final List associatedChains;

    public KeyMaterial(InputStream jks, char[] password) throws GeneralSecurityException, IOException {
        this(Util.streamToBytes(jks), password);
    }

    public KeyMaterial(InputStream jks, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        this(Util.streamToBytes(jks), jksPass, keyPass);
    }

    public KeyMaterial(InputStream jks, InputStream key, char[] password) throws GeneralSecurityException, IOException {
        this(jks != null ? Util.streamToBytes(jks) : null, key != null ? Util.streamToBytes(key) : null, password);
    }

    public KeyMaterial(InputStream jks, InputStream key, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        this(jks != null ? Util.streamToBytes(jks) : null, key != null ? Util.streamToBytes(key) : null, jksPass, keyPass);
    }

    public KeyMaterial(String pathToJksFile, char[] password) throws GeneralSecurityException, IOException {
        this(new File(pathToJksFile), password);
    }

    public KeyMaterial(String pathToJksFile, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        this(new File(pathToJksFile), jksPass, keyPass);
    }

    public KeyMaterial(String pathToCerts, String pathToKey, char[] password) throws GeneralSecurityException, IOException {
        this(pathToCerts != null ? new File(pathToCerts) : null, pathToKey != null ? new File(pathToKey) : null, password);
    }

    public KeyMaterial(String pathToCerts, String pathToKey, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        this(pathToCerts != null ? new File(pathToCerts) : null, pathToKey != null ? new File(pathToKey) : null, jksPass, keyPass);
    }

    public KeyMaterial(File jksFile, char[] password) throws GeneralSecurityException, IOException {
        this(new FileInputStream(jksFile), password);
    }

    public KeyMaterial(File jksFile, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        this((InputStream)new FileInputStream(jksFile), jksPass, keyPass);
    }

    public KeyMaterial(File certsFile, File keyFile, char[] password) throws GeneralSecurityException, IOException {
        this((InputStream)(certsFile != null ? new FileInputStream(certsFile) : null), keyFile != null ? new FileInputStream(keyFile) : null, password);
    }

    public KeyMaterial(File certsFile, File keyFile, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        this(certsFile != null ? new FileInputStream(certsFile) : null, keyFile != null ? new FileInputStream(keyFile) : null, jksPass, keyPass);
    }

    public KeyMaterial(URL urlToJKS, char[] password) throws GeneralSecurityException, IOException {
        this(urlToJKS.openStream(), password);
    }

    public KeyMaterial(URL urlToJKS, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        this(urlToJKS.openStream(), jksPass, keyPass);
    }

    public KeyMaterial(URL urlToCerts, URL urlToKey, char[] password) throws GeneralSecurityException, IOException {
        this(urlToCerts.openStream(), urlToKey.openStream(), password);
    }

    public KeyMaterial(URL urlToCerts, URL urlToKey, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        this(urlToCerts.openStream(), urlToKey.openStream(), jksPass, keyPass);
    }

    public KeyMaterial(byte[] jks, char[] password) throws GeneralSecurityException, IOException {
        this(jks, (byte[])null, password);
    }

    public KeyMaterial(byte[] jks, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        this(jks, null, jksPass, keyPass);
    }

    public KeyMaterial(byte[] jksOrCerts, byte[] key, char[] password) throws GeneralSecurityException, IOException {
        this(jksOrCerts, key, password, password);
    }

    public KeyMaterial(byte[] jksOrCerts, byte[] key, char[] jksPass, char[] keyPass) throws GeneralSecurityException, IOException {
        super(KeyStoreBuilder.build(jksOrCerts, key, jksPass, keyPass), 0);
        KeyStore ks = this.getKeyStore();
        Enumeration<String> en = ks.aliases();
        LinkedList<String> myAliases = new LinkedList<String>();
        LinkedList<Certificate[]> myChains = new LinkedList<Certificate[]>();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            try {
                ks.getKey(alias, keyPass);
                myAliases.add(alias);
                Certificate[] chain = ks.getCertificateChain(alias);
                if (chain != null) {
                    Certificate[] c = Certificates.x509ifyChain(chain);
                    if (c != null) {
                        X509Certificate l = c[0];
                        c = X509CertificateChainBuilder.buildPath(l, c);
                    }
                    myChains.add(c);
                    continue;
                }
                throw new KeyStoreException("Could not find KeyMaterial's associated certificate chain with alis=[" + alias + "]");
            }
            catch (GeneralSecurityException gse) {
            }
        }
        if (myAliases.isEmpty()) {
            throw new KeyStoreException("KeyMaterial provided does not contain any keys!");
        }
        this.aliases = Collections.unmodifiableList(myAliases);
        this.associatedChains = Collections.unmodifiableList(myChains);
        this.keyManagerFactory = JavaImpl.newKeyManagerFactory(ks, keyPass);
    }

    public Object[] getKeyManagers() {
        return JavaImpl.getKeyManagers(this.keyManagerFactory);
    }

    public List getAssociatedCertificateChains() {
        return this.associatedChains;
    }

    public KeyStore getKeyStore() {
        return super.getKeyStore();
    }

    public List getAliases() {
        return this.aliases;
    }

    public static void main(String[] args) throws Exception {
        File f;
        char[] jksPass;
        if (args.length < 2) {
            System.out.println("Usage1:  java org.apache.commons.ssl.KeyMaterial [password] [pkcs12 or jks]");
            System.out.println("Usage2:  java org.apache.commons.ssl.KeyMaterial [password] [private-key] [cert-chain]");
            System.exit(1);
        }
        char[] keyPass = jksPass = args[0].toCharArray();
        String path1 = args[1];
        String path2 = null;
        if (args.length >= 3) {
            path2 = args[2];
        }
        if (args.length >= 4) {
            keyPass = args[3].toCharArray();
        } else if (path2 != null && !(f = new File(path2)).exists()) {
            keyPass = path2.toCharArray();
            path2 = null;
        }
        KeyMaterial km = new KeyMaterial(path1, path2, jksPass, keyPass);
        System.out.println(km);
    }

    public String toString() {
        List chains = this.getAssociatedCertificateChains();
        List aliases = this.getAliases();
        Iterator it = chains.iterator();
        Iterator aliasesIt = aliases.iterator();
        StringBuffer buf = new StringBuffer(8192);
        while (it.hasNext()) {
            X509Certificate[] certs = (X509Certificate[])it.next();
            String alias = (String)aliasesIt.next();
            buf.append("Alias: ");
            buf.append(alias);
            buf.append('\n');
            if (certs == null) continue;
            for (int i = 0; i < certs.length; ++i) {
                buf.append(Certificates.toString(certs[i]));
                try {
                    buf.append(Certificates.toPEMString(certs[i]));
                    continue;
                }
                catch (CertificateEncodingException cee) {
                    buf.append(cee.toString());
                    buf.append('\n');
                }
            }
        }
        return buf.toString();
    }
}

