package org.apache.dvsl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 *  This is the tool interface exposed to the stylesheet.
 *
 *  @author <a href="mailto:geirm@apache.org">Geir Magnusson Jr.</a>
 */
public interface TransformTool
{
    /**
     *  <p>
     *  Applies templates in the current stylesheet
     *  to the nodeset returned by the XPath expression
     *  </p>
     *
     *  @param xpath  XPath expression to select nodes
     *  @return The rendered result
     */
    public String applyTemplates(String xpath) throws Exception;

    public String applyTemplates(DVSLNode node) throws Exception;

    public String applyTemplates(DVSLNode node, String xpath) throws Exception;

    public String applyTemplates() throws Exception;

    public String copy() throws Exception;

    public Object get(String key);

    public Object getAppValue(Object key);
    public Object putAppValue(Object key, Object value);
}
