/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.serializer.push;

import java.util.HashSet;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.ext.stax.DTDReader;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerReader;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.util.OMDataSourceUtil;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;

public abstract class Serializer {
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_LOCAL_NAME = "type";
    private final OMSerializable root;
    private final OMElement contextElement;
    private final boolean namespaceRepairing;
    private final boolean preserveNamespaceContext;

    public Serializer(OMSerializable root, boolean namespaceRepairing, boolean preserveNamespaceContext) {
        OMContainer parent;
        this.root = root;
        this.contextElement = root instanceof OMNode ? ((parent = ((OMNode)root).getParent()) instanceof OMElement ? (OMElement)parent : null) : null;
        this.namespaceRepairing = namespaceRepairing;
        this.preserveNamespaceContext = preserveNamespaceContext;
    }

    public final void serializeStartpart(OMElement element) throws OutputException {
        Iterator it;
        OMNamespace ns = element.getNamespace();
        if (ns == null) {
            this.internalBeginStartElement("", "", element.getLocalName());
        } else {
            this.internalBeginStartElement(ns.getPrefix(), ns.getNamespaceURI(), element.getLocalName());
        }
        if (this.preserveNamespaceContext && element == this.root) {
            HashSet<String> seenPrefixes = new HashSet<String>();
            OMElement current = element;
            while (true) {
                Iterator it2 = current.getAllDeclaredNamespaces();
                while (it2.hasNext()) {
                    ns = (OMNamespace)it2.next();
                    if (!seenPrefixes.add(ns.getPrefix())) continue;
                    this.mapNamespace(ns.getPrefix(), ns.getNamespaceURI(), true, false);
                }
                OMContainer parent = current.getParent();
                if (parent instanceof OMElement) {
                    current = (OMElement)parent;
                    continue;
                }
                break;
            }
        } else {
            it = element.getAllDeclaredNamespaces();
            while (it.hasNext()) {
                ns = (OMNamespace)it.next();
                this.mapNamespace(ns.getPrefix(), ns.getNamespaceURI(), true, false);
            }
        }
        it = element.getAllAttributes();
        while (it.hasNext()) {
            OMAttribute attr = (OMAttribute)it.next();
            ns = attr.getNamespace();
            if (ns == null) {
                this.processAttribute("", "", attr.getLocalName(), attr.getAttributeType(), attr.getAttributeValue());
                continue;
            }
            this.processAttribute(ns.getPrefix(), ns.getNamespaceURI(), attr.getLocalName(), attr.getAttributeType(), attr.getAttributeValue());
        }
        this.finishStartElement();
    }

    public final void copyEvent(XMLStreamReader reader, DataHandlerReader dataHandlerReader) throws OutputException {
        try {
            int eventType = reader.getEventType();
            switch (eventType) {
                case 11: {
                    DTDReader dtdReader;
                    try {
                        dtdReader = (DTDReader)reader.getProperty(DTDReader.PROPERTY);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dtdReader = null;
                    }
                    if (dtdReader == null) {
                        throw new XMLStreamException("Cannot serialize the DTD because the XMLStreamReader doesn't support the DTDReader extension");
                    }
                    this.writeDTD(dtdReader.getRootName(), dtdReader.getPublicId(), dtdReader.getSystemId(), reader.getText());
                    break;
                }
                case 1: {
                    this.internalBeginStartElement(Serializer.normalize(reader.getPrefix()), Serializer.normalize(reader.getNamespaceURI()), reader.getLocalName());
                    int i = 0;
                    int count = reader.getNamespaceCount();
                    while (i < count) {
                        this.mapNamespace(Serializer.normalize(reader.getNamespacePrefix(i)), Serializer.normalize(reader.getNamespaceURI(i)), true, false);
                        ++i;
                    }
                    i = 0;
                    count = reader.getAttributeCount();
                    while (i < count) {
                        this.processAttribute(Serializer.normalize(reader.getAttributePrefix(i)), Serializer.normalize(reader.getAttributeNamespace(i)), reader.getAttributeLocalName(i), reader.getAttributeType(i), reader.getAttributeValue(i));
                        ++i;
                    }
                    this.finishStartElement();
                    break;
                }
                case 2: {
                    this.writeEndElement();
                    break;
                }
                case 4: {
                    if (dataHandlerReader != null && dataHandlerReader.isBinary()) {
                        if (dataHandlerReader.isDeferred()) {
                            this.writeDataHandler(dataHandlerReader.getDataHandlerProvider(), dataHandlerReader.getContentID(), dataHandlerReader.isOptimized());
                        } else {
                            this.writeDataHandler(dataHandlerReader.getDataHandler(), dataHandlerReader.getContentID(), dataHandlerReader.isOptimized());
                        }
                        break;
                    }
                }
                case 6: 
                case 12: {
                    this.writeText(eventType, reader.getText());
                    break;
                }
                case 3: {
                    this.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 5: {
                    this.writeComment(reader.getText());
                    break;
                }
                case 9: {
                    this.writeEntityRef(reader.getLocalName());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new DeferredParsingException(ex);
        }
    }

    private static String normalize(String s) {
        return s == null ? "" : s;
    }

    private void internalBeginStartElement(String prefix, String namespaceURI, String localName) throws OutputException {
        this.beginStartElement(prefix, namespaceURI, localName);
        this.mapNamespace(prefix, namespaceURI, false, false);
    }

    private void processAttribute(String prefix, String namespaceURI, String localName, String type, String value) throws OutputException {
        String refPrefix;
        OMNamespace ns;
        String trimmedValue;
        this.mapNamespace(prefix, namespaceURI, false, true);
        if (this.namespaceRepairing && this.contextElement != null && namespaceURI.equals(XSI_URI) && localName.equals(XSI_LOCAL_NAME) && (trimmedValue = value.trim()).indexOf(":") > 0 && (ns = this.contextElement.findNamespaceURI(refPrefix = trimmedValue.substring(0, trimmedValue.indexOf(":")))) != null) {
            this.mapNamespace(refPrefix, ns.getNamespaceURI(), false, true);
        }
        this.addAttribute(prefix, namespaceURI, localName, type, value);
    }

    private void mapNamespace(String prefix, String namespaceURI, boolean fromDecl, boolean attr) throws OutputException {
        if (this.namespaceRepairing) {
            if (this.isAssociated(prefix, namespaceURI)) {
                return;
            }
            if (prefix.length() == 0 && namespaceURI.length() == 0 && attr) {
                return;
            }
            this.addNamespace(prefix, namespaceURI);
        } else if (fromDecl) {
            this.addNamespace(prefix, namespaceURI);
        }
    }

    public final void serialize(OMDataSource dataSource) throws OutputException {
        if (OMDataSourceUtil.isPullDataSource(dataSource)) {
            try {
                int eventType;
                XMLStreamReader reader = dataSource.getReader();
                DataHandlerReader dataHandlerReader = XMLStreamReaderUtils.getDataHandlerReader(reader);
                int depth = 0;
                while ((eventType = reader.next()) != 8) {
                    if (eventType == 1) {
                        ++depth;
                    }
                    if (depth > 0) {
                        this.copyEvent(reader, dataHandlerReader);
                    }
                    if (eventType != 2) continue;
                    --depth;
                }
                reader.close();
            }
            catch (XMLStreamException ex) {
                throw new DeferredParsingException(ex);
            }
        } else {
            this.serializePushOMDataSource(dataSource);
        }
    }

    protected abstract boolean isAssociated(String var1, String var2) throws OutputException;

    public abstract void writeStartDocument(String var1) throws OutputException;

    public abstract void writeStartDocument(String var1, String var2) throws OutputException;

    public abstract void writeDTD(String var1, String var2, String var3, String var4) throws OutputException;

    protected abstract void beginStartElement(String var1, String var2, String var3) throws OutputException;

    protected abstract void addNamespace(String var1, String var2) throws OutputException;

    protected abstract void addAttribute(String var1, String var2, String var3, String var4, String var5) throws OutputException;

    protected abstract void finishStartElement() throws OutputException;

    public abstract void writeEndElement() throws OutputException;

    public abstract void writeText(int var1, String var2) throws OutputException;

    public abstract void writeComment(String var1) throws OutputException;

    public abstract void writeProcessingInstruction(String var1, String var2) throws OutputException;

    public abstract void writeEntityRef(String var1) throws OutputException;

    public abstract void writeDataHandler(DataHandler var1, String var2, boolean var3) throws OutputException;

    public abstract void writeDataHandler(DataHandlerProvider var1, String var2, boolean var3) throws OutputException;

    protected abstract void serializePushOMDataSource(OMDataSource var1) throws OutputException;

    public abstract void writeEndDocument() throws OutputException;
}

