/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.xop;

import java.io.IOException;
import javax.activation.DataHandler;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicy;
import org.apache.axiom.util.activation.DataHandlerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OptimizationPolicyImpl
implements OptimizationPolicy {
    private static final Log log = LogFactory.getLog(OptimizationPolicyImpl.class);
    private final OMOutputFormat format;

    public OptimizationPolicyImpl(OMOutputFormat format) {
        this.format = format;
    }

    @Override
    public boolean isOptimized(DataHandler dataHandler, boolean optimize) {
        if (!optimize) {
            return false;
        }
        int threshold = this.format.getOptimizedThreshold();
        if (threshold == 0) {
            return true;
        }
        try {
            return DataHandlerUtils.isLargerThan(dataHandler, threshold);
        }
        catch (IOException ex) {
            log.warn((Object)"DataHandler.writeTo(OutputStream) threw IOException", (Throwable)ex);
            return true;
        }
    }

    @Override
    public boolean isOptimized(DataHandlerProvider dataHandlerProvider, boolean optimize) throws IOException {
        if (!optimize) {
            return false;
        }
        if (this.format.getOptimizedThreshold() == 0) {
            return true;
        }
        return this.isOptimized(dataHandlerProvider.getDataHandler(), optimize);
    }
}

