/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.QNameAwareOMDataSource;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.apache.axiom.om.ds.jaxb.AttachmentMarshallerImpl;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;

public class JAXBOMDataSource
extends AbstractPushOMDataSource
implements QNameAwareOMDataSource {
    private final JAXBContext context;
    private final Object object;
    private QName cachedQName;

    public JAXBOMDataSource(JAXBContext context, Object object) {
        this.context = context;
        this.object = object;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        try {
            MTOMXMLStreamWriter mtomWriter;
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            if (writer instanceof MTOMXMLStreamWriter && (mtomWriter = (MTOMXMLStreamWriter)writer).isOptimized()) {
                marshaller.setAttachmentMarshaller((AttachmentMarshaller)new AttachmentMarshallerImpl(mtomWriter));
            }
            marshaller.marshal(this.object, writer);
        }
        catch (JAXBException ex) {
            for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof XMLStreamException)) continue;
                throw (XMLStreamException)cause;
            }
            throw new OMException("Error marshalling JAXB object", (Throwable)ex);
        }
    }

    private QName getQName() {
        if (this.cachedQName == null) {
            if (this.object instanceof JAXBElement) {
                this.cachedQName = ((JAXBElement)this.object).getName();
            } else {
                this.cachedQName = this.context.createJAXBIntrospector().getElementName(this.object);
                if (this.cachedQName == null) {
                    throw new OMException("Unable to determine the element name of the object");
                }
            }
        }
        return this.cachedQName;
    }

    public String getLocalName() {
        return this.getQName().getLocalPart();
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public String getPrefix() {
        return null;
    }

    public Object getObject() {
        return this.object;
    }

    public OMDataSourceExt copy() {
        return new JAXBOMDataSource(this.context, this.object);
    }
}

